/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.service.management;

import com.android.tradefed.command.CommandScheduler;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.FreeDeviceState;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.google.common.base.Strings;
import com.proto.tradefed.device.DeviceManagementGrpc;
import com.proto.tradefed.device.DeviceStatus;
import com.proto.tradefed.device.GetDevicesStatusRequest;
import com.proto.tradefed.device.GetDevicesStatusResponse;
import com.proto.tradefed.device.ReleaseReservationRequest;
import com.proto.tradefed.device.ReleaseReservationResponse;
import com.proto.tradefed.device.ReserveDeviceRequest;
import com.proto.tradefed.device.ReserveDeviceResponse;
import com.proto.tradefed.device.StopLeasingRequest;
import com.proto.tradefed.device.StopLeasingResponse;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class DeviceManagementGrpcServer
extends DeviceManagementGrpc.DeviceManagementImplBase {
    private static final String TF_DEVICE_MANAGEMENT_PORT = "TF_DEVICE_MANAGEMENT_PORT";
    private final Server mServer;
    private final IDeviceManager mDeviceManager;
    private final ICommandScheduler mCommandScheduler;
    private final Map<String, ReservationInformation> mSerialToReservation = new ConcurrentHashMap<String, ReservationInformation>();

    public static Integer getPort() {
        return System.getenv(TF_DEVICE_MANAGEMENT_PORT) != null ? Integer.valueOf(Integer.parseInt(System.getenv(TF_DEVICE_MANAGEMENT_PORT))) : null;
    }

    public DeviceManagementGrpcServer(int port, IDeviceManager deviceManager, ICommandScheduler scheduler) {
        this(ServerBuilder.forPort(port), deviceManager, scheduler);
    }

    public DeviceManagementGrpcServer(ServerBuilder<?> serverBuilder, IDeviceManager deviceManager, ICommandScheduler scheduler) {
        this.mServer = ((ServerBuilder)serverBuilder.addService(this)).build();
        this.mDeviceManager = deviceManager;
        this.mCommandScheduler = scheduler;
    }

    public DeviceManagementGrpcServer(Server server, IDeviceManager deviceManager, ICommandScheduler scheduler) {
        this.mServer = server;
        this.mDeviceManager = deviceManager;
        this.mCommandScheduler = scheduler;
    }

    public void start() {
        try {
            LogUtil.CLog.d("Starting device management server.");
            this.mServer.start();
        }
        catch (IOException e) {
            LogUtil.CLog.w("Device management server already started: %s", e.getMessage());
        }
    }

    public void shutdown() throws InterruptedException {
        if (this.mServer != null) {
            LogUtil.CLog.d("Stopping device management server.");
            this.mServer.shutdown();
            this.mServer.awaitTermination();
        }
    }

    @Override
    public void getDevicesStatus(GetDevicesStatusRequest request, StreamObserver<GetDevicesStatusResponse> responseObserver) {
        GetDevicesStatusResponse.Builder responseBuilder = GetDevicesStatusResponse.newBuilder();
        if (request.getDeviceIdList().isEmpty()) {
            for (DeviceDescriptor descriptor : this.mDeviceManager.listAllDevices(true)) {
                responseBuilder.addDeviceStatus(this.descriptorToStatus(descriptor));
            }
        } else {
            for (String serial : request.getDeviceIdList()) {
                DeviceDescriptor descriptor = this.mDeviceManager.getDeviceDescriptor(serial);
                responseBuilder.addDeviceStatus(this.descriptorToStatus(descriptor));
            }
        }
        responseObserver.onNext(responseBuilder.build());
        responseObserver.onCompleted();
    }

    @Override
    public void releaseReservation(ReleaseReservationRequest request, StreamObserver<ReleaseReservationResponse> responseObserver) {
        ReleaseReservationResponse.Builder responseBuilder = ReleaseReservationResponse.newBuilder();
        ITestDevice device = this.getDeviceFromReservation(request.getReservationId());
        if (device == null) {
            responseBuilder.setResult(ReleaseReservationResponse.Result.RESERVATION_NOT_EXIST).setMessage(String.format("Reservation id released '%s' is untracked", request.getReservationId()));
        } else if (this.mCommandScheduler.isDeviceInInvocationThread(device)) {
            responseBuilder.setResult(ReleaseReservationResponse.Result.DEVICE_IN_USE).setMessage(String.format("Reservation '%s' is still in use", request.getReservationId()));
        } else {
            this.releaseReservationInternal(request.getReservationId());
            responseBuilder.setResult(ReleaseReservationResponse.Result.SUCCEED);
        }
        responseObserver.onNext(responseBuilder.build());
        responseObserver.onCompleted();
    }

    @Override
    public void reserveDevice(ReserveDeviceRequest request, StreamObserver<ReserveDeviceResponse> responseObserver) {
        ReserveDeviceResponse.Builder responseBuilder = ReserveDeviceResponse.newBuilder();
        ServerCallStreamObserver serverCallStreamObserver = (ServerCallStreamObserver)responseObserver;
        String serial = request.getDeviceId();
        if (Strings.isNullOrEmpty(serial)) {
            responseBuilder.setResult(ReserveDeviceResponse.Result.UNKNOWN).setMessage("serial requested was null or empty.");
            responseObserver.onNext(responseBuilder.build());
            responseObserver.onCompleted();
            return;
        }
        if (this.mCommandScheduler instanceof CommandScheduler && ((CommandScheduler)this.mCommandScheduler).isShuttingDown()) {
            responseBuilder.setResult(ReserveDeviceResponse.Result.UNKNOWN).setMessage("Tradefed is shutting down, rejecting reservation.");
            responseObserver.onNext(responseBuilder.build());
            responseObserver.onCompleted();
            return;
        }
        DeviceDescriptor descriptor = this.mDeviceManager.getDeviceDescriptor(serial);
        if (descriptor == null) {
            responseBuilder.setResult(ReserveDeviceResponse.Result.UNKNOWN).setMessage("No descriptor found for serial " + serial);
            responseObserver.onNext(responseBuilder.build());
            responseObserver.onCompleted();
            return;
        }
        if (DeviceAllocationState.Allocated.equals(descriptor.getState())) {
            ReserveDeviceResponse.Result result = ReserveDeviceResponse.Result.ALREADY_ALLOCATED;
            if (this.mSerialToReservation.containsKey(serial)) {
                result = ReserveDeviceResponse.Result.ALREADY_RESERVED;
            }
            responseBuilder.setResult(result).setMessage("device is currently in allocated state.");
        } else if (DeviceAllocationState.Unavailable.equals(descriptor.getState())) {
            responseBuilder.setResult(ReserveDeviceResponse.Result.UNAVAILABLE).setMessage("device is currently in unavailable state.");
        } else if (!serverCallStreamObserver.isCancelled()) {
            DeviceSelectionOptions selection = new DeviceSelectionOptions();
            if (serial.startsWith("gce-device")) {
                selection.setGceDeviceRequested(true);
            }
            if (serial.startsWith("null-device")) {
                selection.setNullDeviceRequested(true);
            }
            selection.addSerial(serial);
            ITestDevice device = this.mDeviceManager.allocateDevice(selection);
            if (device == null) {
                responseBuilder.setResult(ReserveDeviceResponse.Result.UNKNOWN).setMessage(String.format("Failed to allocate '%s' reason: '%s'", serial, selection.getNoMatchReason()));
            } else {
                String reservationId = UUID.randomUUID().toString();
                responseBuilder.setResult(ReserveDeviceResponse.Result.SUCCEED).setReservationId(reservationId);
                this.mSerialToReservation.put(serial, new ReservationInformation(device, reservationId));
            }
        }
        if (serverCallStreamObserver.isCancelled()) {
            LogUtil.CLog.d("The client call is cancelled.");
            if (responseBuilder.getResult().equals(ReserveDeviceResponse.Result.SUCCEED) && !responseBuilder.getReservationId().isEmpty()) {
                this.releaseReservationInternal(responseBuilder.getReservationId());
            }
            responseBuilder.clear().setResult(ReserveDeviceResponse.Result.UNKNOWN).setMessage("The device reservation RPC is cancelled by client.");
        }
        responseObserver.onNext(responseBuilder.build());
        responseObserver.onCompleted();
    }

    @Override
    public void stopLeasing(StopLeasingRequest request, StreamObserver<StopLeasingResponse> responseObserver) {
        StopLeasingResponse.Builder responseBuilder = StopLeasingResponse.newBuilder();
        try {
            this.mCommandScheduler.stopScheduling();
            responseBuilder.setResult(StopLeasingResponse.Result.SUCCEED);
        }
        catch (RuntimeException e) {
            responseBuilder.setResult(StopLeasingResponse.Result.FAIL);
            responseBuilder.setMessage(e.getMessage());
        }
        responseObserver.onNext(responseBuilder.build());
        responseObserver.onCompleted();
    }

    private void releaseReservationInternal(String reservationId) {
        Map.Entry<String, ReservationInformation> entry = this.getDeviceEntryFromReservation(reservationId);
        if (entry != null) {
            this.mDeviceManager.freeDevice(entry.getValue().device, FreeDeviceState.AVAILABLE);
            this.mSerialToReservation.remove(entry.getKey());
        }
    }

    private DeviceStatus descriptorToStatus(DeviceDescriptor descriptor) {
        DeviceStatus.Builder deviceStatusBuilder = DeviceStatus.newBuilder();
        deviceStatusBuilder.setDeviceId(descriptor.getSerial());
        deviceStatusBuilder.setReservationStatus(this.allocationStateToReservation(descriptor.getState(), descriptor.getSerial()));
        return deviceStatusBuilder.build();
    }

    private DeviceStatus.ReservationStatus allocationStateToReservation(DeviceAllocationState state, String serial) {
        switch (state) {
            case Available: {
                return DeviceStatus.ReservationStatus.READY;
            }
            case Allocated: {
                if (this.mSerialToReservation.containsKey(serial)) {
                    return DeviceStatus.ReservationStatus.RESERVED;
                }
                return DeviceStatus.ReservationStatus.ALLOCATED;
            }
            case Unavailable: 
            case Ignored: {
                return DeviceStatus.ReservationStatus.UNAVAILABLE;
            }
        }
        return DeviceStatus.ReservationStatus.UNKNOWN;
    }

    private Map.Entry<String, ReservationInformation> getDeviceEntryFromReservation(String reservationId) {
        for (Map.Entry<String, ReservationInformation> info : this.mSerialToReservation.entrySet()) {
            if (!info.getValue().reservationId.equals(reservationId)) continue;
            return info;
        }
        return null;
    }

    public ITestDevice getDeviceFromReservation(String reservationId) {
        Map.Entry<String, ReservationInformation> entry = this.getDeviceEntryFromReservation(reservationId);
        if (entry != null) {
            return entry.getValue().device;
        }
        return null;
    }

    private class ReservationInformation {
        final ITestDevice device;
        final String reservationId;

        ReservationInformation(ITestDevice device, String reservationId) {
            this.device = device;
            this.reservationId = reservationId;
        }
    }
}

