/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.service.management;

import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.proto.FileProtoResultReporter;
import com.android.tradefed.service.management.CommandStatusHandler;
import com.android.tradefed.service.management.DeviceManagementGrpcServer;
import com.android.tradefed.service.management.ScheduledInvocationForwarder;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.proto.tradefed.invocation.CommandErrorInfo;
import com.proto.tradefed.invocation.InvocationDetailRequest;
import com.proto.tradefed.invocation.InvocationDetailResponse;
import com.proto.tradefed.invocation.InvocationStatus;
import com.proto.tradefed.invocation.NewTestCommandRequest;
import com.proto.tradefed.invocation.NewTestCommandResponse;
import com.proto.tradefed.invocation.StopInvocationRequest;
import com.proto.tradefed.invocation.StopInvocationResponse;
import com.proto.tradefed.invocation.TestInvocationManagementGrpc;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class TestInvocationManagementServer
extends TestInvocationManagementGrpc.TestInvocationManagementImplBase {
    private static final String TF_INVOCATION_SERVER_PORT = "TF_INVOCATION_SERVER_PORT";
    private final Server mServer;
    private final ICommandScheduler mCommandScheduler;
    private final DeviceManagementGrpcServer mDeviceReservationManager;
    private Map<String, InvocationInformation> mTracker = new ConcurrentHashMap<String, InvocationInformation>();

    public static Integer getPort() {
        return System.getenv(TF_INVOCATION_SERVER_PORT) != null ? Integer.valueOf(Integer.parseInt(System.getenv(TF_INVOCATION_SERVER_PORT))) : null;
    }

    public TestInvocationManagementServer(int port, ICommandScheduler commandScheduler, DeviceManagementGrpcServer deviceReservationManager) {
        this(ServerBuilder.forPort(port), commandScheduler, deviceReservationManager);
    }

    public TestInvocationManagementServer(ServerBuilder<?> serverBuilder, ICommandScheduler commandScheduler, DeviceManagementGrpcServer deviceReservationManager) {
        this.mServer = ((ServerBuilder)serverBuilder.addService(this)).build();
        this.mCommandScheduler = commandScheduler;
        this.mDeviceReservationManager = deviceReservationManager;
    }

    public TestInvocationManagementServer(Server server, ICommandScheduler commandScheduler, DeviceManagementGrpcServer deviceReservationManager) {
        this.mServer = server;
        this.mCommandScheduler = commandScheduler;
        this.mDeviceReservationManager = deviceReservationManager;
    }

    public void start() {
        try {
            LogUtil.CLog.d("Starting invocation server.");
            this.mServer.start();
        }
        catch (IOException e) {
            LogUtil.CLog.w("Invocation server already started: %s", e.getMessage());
        }
    }

    public void shutdown() throws InterruptedException {
        if (this.mServer != null) {
            LogUtil.CLog.d("Stopping invocation server.");
            if (this.mTracker.size() > 0) {
                LogUtil.CLog.d("Remaining tracked test invocations: %s", this.mTracker.size());
            }
            this.mServer.shutdown();
            this.mServer.awaitTermination();
        }
    }

    @Override
    public void submitTestCommand(NewTestCommandRequest request, StreamObserver<NewTestCommandResponse> responseObserver) {
        NewTestCommandResponse.Builder responseBuilder = NewTestCommandResponse.newBuilder();
        String[] command = request.getArgsList().toArray(new String[0]);
        File record = null;
        try {
            record = FileUtil.createTempFile("test_record", ".pb");
            CommandStatusHandler handler = new CommandStatusHandler();
            FileProtoResultReporter fileReporter = new FileProtoResultReporter();
            fileReporter.setOutputFile(record);
            fileReporter.setDelimitedOutput(false);
            fileReporter.setGranularResults(false);
            ScheduledInvocationForwarder forwarder = new ScheduledInvocationForwarder(handler, fileReporter);
            List<ITestDevice> devices = null;
            if (!request.getReservationIdList().isEmpty()) {
                devices = this.getReservedDevices(request.getReservationIdList());
            }
            long invocationId = -1L;
            invocationId = devices == null ? this.mCommandScheduler.execCommand(forwarder, command) : this.mCommandScheduler.execCommand((ICommandScheduler.IScheduledInvocationListener)forwarder, devices, command);
            if (invocationId == -1L) {
                responseBuilder.setCommandErrorInfo(CommandErrorInfo.newBuilder().setErrorMessage("Something went wrong to execute the command."));
            } else {
                String trackerId = UUID.randomUUID().toString();
                this.mTracker.put(trackerId, new InvocationInformation(invocationId, forwarder));
                responseBuilder.setInvocationId(trackerId);
            }
        }
        catch (ConfigurationException | IOException | RuntimeException e) {
            FileUtil.deleteFile(record);
            CommandErrorInfo.Builder commandError = CommandErrorInfo.newBuilder();
            commandError.setErrorMessage(StreamUtil.getStackTrace(e));
            if (e instanceof IHarnessException && ((IHarnessException)((Object)e)).getErrorId() != null) {
                commandError.setErrorName(((IHarnessException)((Object)e)).getErrorId().name());
                commandError.setErrorCode(((IHarnessException)((Object)e)).getErrorId().code());
            }
            responseBuilder.setCommandErrorInfo(commandError);
        }
        responseObserver.onNext(responseBuilder.build());
        responseObserver.onCompleted();
    }

    @Override
    public void getInvocationDetail(InvocationDetailRequest request, StreamObserver<InvocationDetailResponse> responseObserver) {
        InvocationDetailResponse.Builder responseBuilder = InvocationDetailResponse.newBuilder();
        String invocationId = request.getInvocationId();
        if (this.mTracker.containsKey(invocationId)) {
            responseBuilder.setInvocationStatus(this.createStatus(this.mTracker.get((Object)invocationId).scheduledInvocationForwarder.getListeners()));
            if (responseBuilder.getInvocationStatus().getStatus().equals(InvocationStatus.Status.DONE)) {
                responseBuilder.setTestRecordPath(this.getProtoPath(this.mTracker.get((Object)invocationId).scheduledInvocationForwarder.getListeners()));
                this.mTracker.remove(invocationId);
            }
        } else {
            responseBuilder.setInvocationStatus(InvocationStatus.newBuilder().setStatus(InvocationStatus.Status.UNKNOWN).setStatusReason("invocation id is not tracked."));
        }
        responseObserver.onNext(responseBuilder.build());
        responseObserver.onCompleted();
    }

    @Override
    public void stopInvocation(StopInvocationRequest request, StreamObserver<StopInvocationResponse> responseObserver) {
        StopInvocationResponse.Builder responseBuilder = StopInvocationResponse.newBuilder();
        String invocationId = request.getInvocationId();
        if (this.mTracker.containsKey(invocationId)) {
            long realInvocationId = this.mTracker.get((Object)invocationId).invocationId;
            boolean found = this.mCommandScheduler.stopInvocation((int)realInvocationId, request.getReason());
            if (found) {
                responseBuilder.setStatus(StopInvocationResponse.Status.SUCCESS);
            } else {
                responseBuilder.setStatus(StopInvocationResponse.Status.ERROR).setCommandErrorInfo(CommandErrorInfo.newBuilder().setErrorMessage("No running matching invocation to stop."));
            }
        } else {
            responseBuilder.setStatus(StopInvocationResponse.Status.ERROR).setCommandErrorInfo(CommandErrorInfo.newBuilder().setErrorMessage("invocation id is not tracked."));
        }
        responseObserver.onNext(responseBuilder.build());
        responseObserver.onCompleted();
    }

    private InvocationStatus createStatus(List<ITestInvocationListener> listeners) {
        InvocationStatus.Builder invocationStatusBuilder = InvocationStatus.newBuilder();
        InvocationStatus.Status status = InvocationStatus.Status.UNKNOWN;
        for (ITestInvocationListener listener : listeners) {
            if (!(listener instanceof CommandStatusHandler)) continue;
            status = ((CommandStatusHandler)listener).getCurrentStatus();
        }
        invocationStatusBuilder.setStatus(status);
        if (InvocationStatus.Status.UNKNOWN.equals(status)) {
            invocationStatusBuilder.setStatusReason("Failed to find the CommandStatusHandler.");
        }
        return invocationStatusBuilder.build();
    }

    private String getProtoPath(List<ITestInvocationListener> listeners) {
        for (ITestInvocationListener listener : listeners) {
            if (!(listener instanceof FileProtoResultReporter)) continue;
            return ((FileProtoResultReporter)listener).getOutputFile().getAbsolutePath();
        }
        return null;
    }

    private List<ITestDevice> getReservedDevices(List<String> reservationIds) {
        if (this.mDeviceReservationManager == null) {
            return null;
        }
        ArrayList<ITestDevice> devices = new ArrayList<ITestDevice>();
        for (String id : reservationIds) {
            ITestDevice device = this.mDeviceReservationManager.getDeviceFromReservation(id);
            if (device == null) {
                throw new RuntimeException(String.format("Device with reservationId %s not found", id));
            }
            devices.add(device);
        }
        return devices;
    }

    public class InvocationInformation {
        public final long invocationId;
        public final ScheduledInvocationForwarder scheduledInvocationForwarder;

        InvocationInformation(long invocationId, ScheduledInvocationForwarder scheduledInvocationForwarder) {
            this.invocationId = invocationId;
            this.scheduledInvocationForwarder = scheduledInvocationForwarder;
        }
    }
}

