/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.suite.checker;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.StatusCheckerResult;
import com.android.tradefed.util.StreamUtil;

public class ActivityStatusChecker
implements ISystemStatusChecker,
ITestLoggerReceiver {
    private ITestLogger mLogger;

    @Override
    public StatusCheckerResult postExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        return this.isFrontActivityLauncher(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatusCheckerResult isFrontActivityLauncher(ITestDevice device) throws DeviceNotAvailableException {
        StatusCheckerResult result = new StatusCheckerResult();
        String output = "";
        int apiLevel = device.getApiLevel();
        if (apiLevel >= 29) {
            output = device.executeShellCommand("dumpsys window displays | grep -E 'mCurrentFocus|mFocusedApp'");
            LogUtil.CLog.d("dumpsys window displays: %s", output);
        } else {
            output = device.executeShellCommand("dumpsys window windows | grep -E 'mCurrentFocus|mFocusedApp'");
            LogUtil.CLog.d("dumpsys window windows: %s", output);
        }
        if (output.contains("Launcher")) {
            result.setStatus(StatusCheckerResult.CheckStatus.SUCCESS);
            return result;
        }
        InputStreamSource screen = device.getScreenshot("JPEG");
        try {
            this.mLogger.testLog("status_checker_front_activity", LogDataType.JPEG, screen);
        }
        finally {
            StreamUtil.cancel(screen);
        }
        result.setStatus(StatusCheckerResult.CheckStatus.FAILED);
        result.setBugreportNeeded(true);
        result.setErrorMessage("Launcher activity is not in front.");
        return result;
    }

    @Override
    public void setTestLogger(ITestLogger testLogger) {
        this.mLogger = testLogger;
    }
}

