/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.suite.checker;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.SetterHelper;
import com.android.tradefed.suite.checker.StatusCheckerResult;
import com.android.tradefed.suite.checker.baseline.DeviceBaselineSetter;
import com.android.tradefed.testtype.suite.ITestSuite;
import com.android.tradefed.util.Pair;
import com.android.tradefed.util.StreamUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceBaselineChecker
implements ISystemStatusChecker {
    private static final String DEVICE_BASELINE_CONFIG_FILE = "/config/checker/baseline_config.json";
    private static final int N_THREAD = 8;
    private static final String SET_SUCCESS_MESSAGE = "SUCCESS";
    private static final String SET_FAIL_MESSAGE = "FAIL";
    private List<DeviceBaselineSetter> mDeviceBaselineSetters;
    @Option(name="enable-device-baseline-settings", description="Whether or not to apply device baseline settings before each test module. ")
    private boolean mEnableDeviceBaselineSettings = true;
    @Option(name="enable-experimental-device-baseline-setters", description="Set of experimental baseline setters to be enabled. Each value is the setter\u2019s name")
    private Set<String> mEnableExperimentDeviceBaselineSetters = new HashSet<String>();

    public static String getSetSuccessMessage() {
        return SET_SUCCESS_MESSAGE;
    }

    public static String getSetFailMessage() {
        return SET_FAIL_MESSAGE;
    }

    @VisibleForTesting
    void setDeviceBaselineSetters(List<DeviceBaselineSetter> deviceBaselineSetters) {
        this.mDeviceBaselineSetters = deviceBaselineSetters;
    }

    private void initializeDeviceBaselineSetters() {
        ArrayList<DeviceBaselineSetter> deviceBaselineSetters = new ArrayList<DeviceBaselineSetter>();
        if (this.mEnableDeviceBaselineSettings) {
            try {
                InputStream configStream = ITestSuite.class.getResourceAsStream(DEVICE_BASELINE_CONFIG_FILE);
                String jsonStr = StreamUtil.getStringFromStream(configStream);
                JSONObject jsonObject = new JSONObject(jsonStr);
                JSONArray names = jsonObject.names();
                for (int i = 0; i < names.length(); ++i) {
                    String name = names.getString(i);
                    JSONObject objectValue = jsonObject.getJSONObject(name);
                    String className = objectValue.getString("class_name");
                    Class<?> setterClass = Class.forName(className);
                    Constructor<?> constructor = setterClass.getConstructor(JSONObject.class, String.class);
                    deviceBaselineSetters.add((DeviceBaselineSetter)constructor.newInstance(objectValue, name));
                }
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | JSONException e) {
                throw new RuntimeException(e);
            }
        }
        this.setDeviceBaselineSetters(deviceBaselineSetters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatusCheckerResult preExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        if (this.mDeviceBaselineSetters == null) {
            this.initializeDeviceBaselineSetters();
        }
        StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        StringBuilder errorMessage = new StringBuilder();
        ExecutorService pool = Executors.newFixedThreadPool(8);
        ArrayList<SetterHelper> setterHelperList = new ArrayList<SetterHelper>();
        ArrayList<String> enabledDeviceBaselines = new ArrayList<String>();
        for (DeviceBaselineSetter deviceBaselineSetter : this.mDeviceBaselineSetters) {
            if (deviceBaselineSetter.isExperimental() && !this.mEnableExperimentDeviceBaselineSetters.contains(deviceBaselineSetter.getName()) || !device.checkApiLevelAgainstNextRelease(deviceBaselineSetter.getMinimalApiLevel())) continue;
            setterHelperList.add(new SetterHelper(deviceBaselineSetter, device));
        }
        try {
            List setterResultList = pool.invokeAll(setterHelperList);
            for (Future future : setterResultList) {
                Pair pairResult = (Pair)future.get();
                if (SET_FAIL_MESSAGE.equals(pairResult.second)) {
                    result.setStatus(StatusCheckerResult.CheckStatus.FAILED);
                    errorMessage.append(String.format("Failed to set baseline %s. ", pairResult.first));
                    continue;
                }
                enabledDeviceBaselines.add((String)pairResult.first);
            }
        }
        catch (ExecutionException e) {
            result.setStatus(StatusCheckerResult.CheckStatus.FAILED);
            errorMessage.append(StreamUtil.getStackTrace(e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            result.setStatus(StatusCheckerResult.CheckStatus.FAILED);
            errorMessage.append(StreamUtil.getStackTrace(e));
        }
        finally {
            pool.shutdown();
        }
        if (result.getStatus() == StatusCheckerResult.CheckStatus.FAILED) {
            result.setErrorMessage(errorMessage.toString());
        }
        String timeInfo = String.valueOf(System.currentTimeMillis() - startTime);
        String string = String.join((CharSequence)",", enabledDeviceBaselines);
        LogUtil.CLog.i("Enable device baselines %s in %s millis.", string, timeInfo);
        result.addModuleProperty("enabled_device_baseline", string);
        result.addModuleProperty("time_for_device_baseline", timeInfo);
        return result;
    }
}

