/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.suite.checker;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.StatusCheckerResult;
import com.android.tradefed.util.ArrayUtil;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DeviceSettingChecker
implements ISystemStatusChecker {
    private static final String NAMESPACE_SYSTEM = "system";
    private static final String NAMESPACE_GLOBAL = "global";
    private static final String NAMESPACE_SECURE = "secure";
    private static final Set<String> NAMESPACES = new HashSet<String>();
    @Option(name="ignore-system-setting", description="Specify a system setting that's exempted from the checker; may be repeated")
    private Set<String> mIgnoredSystemSettings = new HashSet<String>();
    @Option(name="ignore-secure-setting", description="Specify a secure setting that's exempted from the checker; may be repeated")
    private Set<String> mIgnoredSecureSettings = new HashSet<String>();
    @Option(name="ignore-global-setting", description="Specify a global setting that's exempted from the checker; may be repeated")
    private Set<String> mIgnoredGlobalSettings = new HashSet<String>();
    private Map<String, Map<String, String>> mSettingValPair = new HashMap<String, Map<String, String>>();

    @Override
    public StatusCheckerResult preExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        this.mSettingValPair = new HashMap<String, Map<String, String>>();
        LogUtil.CLog.d("Begin preExecutionCheck for checking device setting");
        HashSet<String> failedNamespaces = new HashSet<String>();
        for (String namespace : NAMESPACES) {
            Map<String, String> newSettings = this.getSettingsHelper(device, namespace);
            if (newSettings == null || newSettings.isEmpty()) {
                failedNamespaces.add(namespace);
                continue;
            }
            this.mSettingValPair.put(namespace, newSettings);
        }
        if (failedNamespaces.isEmpty()) {
            return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        }
        StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.FAILED);
        String errorMessage = String.format("Failed to get setting in pre-execution: %s\n", String.join((CharSequence)",", failedNamespaces));
        LogUtil.CLog.w(errorMessage);
        result.setErrorMessage(errorMessage);
        return result;
    }

    @Override
    public StatusCheckerResult postExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        LogUtil.CLog.d("Begin postExecution for checking device setting");
        HashMap failureMap = new HashMap();
        for (String namespace : NAMESPACES) {
            Set<String> settingsOnlyInNew;
            LinkedList<String> failureInfo = new LinkedList<String>();
            Map<String, String> newSettings = this.getSettingsHelper(device, namespace);
            Map<String, String> oldSettings = this.mSettingValPair.get(namespace);
            if (oldSettings == null) continue;
            MapDifference<String, String> diff = Maps.difference(oldSettings, newSettings);
            Map<String, MapDifference.ValueDifference<String>> entriesDiff = diff.entriesDiffering();
            for (Map.Entry<String, MapDifference.ValueDifference<String>> entry : entriesDiff.entrySet()) {
                String failure = String.format("%s changes from %s to %s", entry.getKey(), entry.getValue().leftValue(), entry.getValue().rightValue());
                failureInfo.add(failure);
            }
            Set<String> settingsOnlyInOld = diff.entriesOnlyOnLeft().keySet();
            if (!settingsOnlyInOld.isEmpty()) {
                failureInfo.add(String.format("%s is not found after module run", String.join((CharSequence)",", settingsOnlyInOld)));
            }
            if (!(settingsOnlyInNew = diff.entriesOnlyOnRight().keySet()).isEmpty()) {
                failureInfo.add(String.format("%s is not found before module run", String.join((CharSequence)",", settingsOnlyInNew)));
            }
            if (failureInfo.isEmpty()) continue;
            failureMap.put(namespace, failureInfo);
        }
        if (failureMap.isEmpty()) {
            return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        }
        StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.FAILED);
        StringBuilder failureMessage = new StringBuilder();
        for (String namespace : failureMap.keySet()) {
            failureMessage.append(String.format("Setting in namespace %s fails:\n %s\n", namespace, ArrayUtil.join("\n", failureMap.get(namespace))));
        }
        LogUtil.CLog.w(failureMessage.toString());
        result.setErrorMessage(failureMessage.toString());
        return result;
    }

    private Map<String, String> getSettingsHelper(ITestDevice device, String namespace) throws DeviceNotAvailableException {
        Map<String, String> settingsPair = device.getAllSettings(namespace);
        Set<Object> ignoredSettings = new HashSet();
        switch (namespace) {
            case "global": {
                ignoredSettings = this.mIgnoredGlobalSettings;
                break;
            }
            case "secure": {
                ignoredSettings = this.mIgnoredSecureSettings;
                break;
            }
            case "system": {
                ignoredSettings = this.mIgnoredSystemSettings;
            }
        }
        for (String ignoredSetting : ignoredSettings) {
            settingsPair.remove(ignoredSetting);
        }
        return settingsPair;
    }

    static {
        NAMESPACES.add(NAMESPACE_SYSTEM);
        NAMESPACES.add(NAMESPACE_GLOBAL);
        NAMESPACES.add(NAMESPACE_SECURE);
    }
}

