/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.suite.checker;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.StatusCheckerResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class DeviceStorageStatusChecker
implements ISystemStatusChecker {
    @Option(name="minimal-storage-bytes", description="Number of bytes that should be left free on the device.")
    private long mMinimalStorage = 0x3200000L;
    @Option(name="partition", description="Partition needed to be checked on the device.")
    private Set<String> mPartitions = new HashSet<String>();

    @Override
    public StatusCheckerResult preExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        ArrayList<String> noEnoughStorage = new ArrayList<String>();
        for (String partition : this.mPartitions) {
            long freeSpace = device.getPartitionFreeSpace(partition) * 1024L;
            String message2 = String.format("%s bytes left on the partition %s", freeSpace, partition);
            LogUtil.CLog.i(message2);
            if (freeSpace >= this.mMinimalStorage) continue;
            noEnoughStorage.add(message2);
        }
        if (noEnoughStorage.isEmpty()) {
            return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        }
        StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.FAILED);
        String errorMessage = String.format("No enough storage left on the device in pre-execution: %s\n", String.join((CharSequence)",", noEnoughStorage));
        LogUtil.CLog.e(errorMessage);
        result.setErrorMessage(errorMessage);
        return result;
    }
}

