/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.suite.checker;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.StatusCheckerResult;

public class EnforcedSeLinuxChecker
implements ISystemStatusChecker {
    private static final String ENFORCING_STRING = "enforcing";
    @Option(name="expect-enforced", description="Controls whether or not Selinux is enforced between modules.")
    private boolean mExpectedEnforced = false;

    @Override
    public StatusCheckerResult postExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        if (this.mExpectedEnforced && !this.isEnforced(device)) {
            result.setStatus(StatusCheckerResult.CheckStatus.FAILED);
            result.setErrorMessage("Device is in permissive mode while enforced was expected.");
            this.setEnforced(device, true);
        } else if (!this.mExpectedEnforced && this.isEnforced(device)) {
            result.setStatus(StatusCheckerResult.CheckStatus.FAILED);
            result.setErrorMessage("Device is in enforced mode while permissive was expected.");
            this.setEnforced(device, false);
        }
        return result;
    }

    private boolean isEnforced(ITestDevice device) throws DeviceNotAvailableException {
        String result = device.executeShellCommand("getenforce");
        return ENFORCING_STRING.equals(result.toLowerCase().trim());
    }

    private void setEnforced(ITestDevice device, boolean enforced) throws DeviceNotAvailableException {
        String enforce = enforced ? "1" : "0";
        device.executeShellCommand("su root setenforce " + enforce);
    }
}

