/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.suite.checker;

import com.android.ddmlib.Log;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.StatusCheckerResult;
import com.android.tradefed.util.KeyguardControllerState;

public class KeyguardStatusChecker
implements ISystemStatusChecker {
    private boolean mIsKeyguardShowing;
    private boolean mIsKeyguardOccluded;

    @Override
    public StatusCheckerResult postExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        KeyguardControllerState ksc = device.getKeyguardState();
        if (ksc == null) {
            LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "KeyguardControllerState is not supported by the device. Skipping System Checker.");
            return result;
        }
        this.mIsKeyguardShowing = ksc.isKeyguardShowing();
        this.mIsKeyguardOccluded = ksc.isKeyguardOccluded();
        if (this.mIsKeyguardShowing || this.mIsKeyguardOccluded) {
            String message2 = String.format("SystemChecker - post-execution:\n\tKeyguard on: %s, occluded: %s", this.mIsKeyguardShowing, this.mIsKeyguardOccluded);
            LogUtil.CLog.logAndDisplay(Log.LogLevel.WARN, message2);
            LogUtil.CLog.w("Also attempting to dismiss keyguard.");
            device.disableKeyguard();
            result.setStatus(StatusCheckerResult.CheckStatus.FAILED);
            result.setErrorMessage(message2);
            return result;
        }
        return result;
    }
}

