/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.suite.checker;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.StatusCheckerResult;
import java.util.ArrayList;
import java.util.Arrays;

public class LeakedThreadStatusChecker
implements ISystemStatusChecker {
    private static final int EXPECTED_THREAD_COUNT = 1;

    @Override
    public StatusCheckerResult postExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        int numThread = Thread.currentThread().getThreadGroup().activeCount();
        if (numThread == 1) {
            return result;
        }
        Thread[] listThreads = new Thread[numThread];
        Thread.currentThread().getThreadGroup().enumerate(listThreads);
        ArrayList<Thread> arrayThread = new ArrayList<Thread>(Arrays.asList(listThreads));
        if (numThread == 2) {
            for (Thread t : arrayThread) {
                if (!t.getName().contains("BackgroundDeviceAction")) continue;
                return result;
            }
        }
        result.setStatus(StatusCheckerResult.CheckStatus.FAILED);
        String message2 = String.format("We have %s threads instead of 1. List: %s", numThread, arrayThread);
        result.setErrorMessage(message2);
        LogUtil.CLog.e(message2);
        return result;
    }
}

