/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.suite.checker;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.StatusCheckerResult;

@OptionClass(alias="shell-status-checker")
public class ShellStatusChecker
implements ISystemStatusChecker {
    private static final String FAIL_STRING = " Reset failed.";
    @Option(name="expect-root", description="Controls whether the shell root status is expected to be root ('true') or non-root ('false'). The checker will warn and try to revert the state if not as expected at pre- or post-check.")
    private boolean mExpectedRoot = false;

    @Override
    public StatusCheckerResult preExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        if (this.mExpectedRoot != device.isAdbRoot()) {
            String message2 = "This module unexpectedly started in a " + (this.mExpectedRoot ? "non-root" : "root") + " shell. Leaked from earlier module?";
            result.setStatus(StatusCheckerResult.CheckStatus.FAILED);
            boolean reset = this.mExpectedRoot ? device.enableAdbRoot() : device.disableAdbRoot();
            if (!reset) {
                message2 = message2 + FAIL_STRING;
            }
            LogUtil.CLog.w(message2);
            result.setErrorMessage(message2);
        }
        return result;
    }

    @Override
    public StatusCheckerResult postExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        if (this.mExpectedRoot != device.isAdbRoot()) {
            String message2 = "This module changed shell root status to " + (this.mExpectedRoot ? "non-root" : "root") + ". Leaked from a test case or setup?";
            result.setStatus(StatusCheckerResult.CheckStatus.FAILED);
            boolean reset = this.mExpectedRoot ? device.enableAdbRoot() : device.disableAdbRoot();
            if (!reset) {
                message2 = message2 + FAIL_STRING;
            }
            LogUtil.CLog.w(message2);
            result.setErrorMessage(message2);
        }
        return result;
    }
}

