/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.suite.checker;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.StatusCheckerResult;

public class SystemServerFileDescriptorChecker
implements ISystemStatusChecker {
    private static final int MAX_EXPECTED_FDS = 900;
    private static final String USER_BUILD = "user";
    private String mBuildType = null;

    @Override
    public StatusCheckerResult preExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mBuildType == null) {
            this.mBuildType = device.getProperty("ro.build.type");
        }
        return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
    }

    @Override
    public StatusCheckerResult postExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        if (USER_BUILD.equals(this.mBuildType)) {
            LogUtil.CLog.d("Skipping system_server fd check on user builds.");
            return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        }
        Integer pid = SystemServerFileDescriptorChecker.getIntegerFromCommand(device, "pidof system_server");
        if (pid == null) {
            LogUtil.CLog.d("Unable to find system_server pid.");
            return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        }
        Integer fds = SystemServerFileDescriptorChecker.getIntegerFromCommand(device, "su root ls /proc/" + pid + "/fd | wc -w");
        if (fds == null) {
            LogUtil.CLog.d("Unable to query system_server fd count.");
            return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        }
        if (fds > 900) {
            StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.FAILED);
            String message2 = String.format("FDs currently allocated in system server %s", fds);
            LogUtil.CLog.w(message2);
            result.setErrorMessage(message2);
            return result;
        }
        return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
    }

    private static Integer getIntegerFromCommand(ITestDevice device, String command) throws DeviceNotAvailableException {
        String output = device.executeShellCommand(command);
        if (output == null) {
            LogUtil.CLog.w("no shell output for command: " + command);
            return null;
        }
        output = output.trim();
        try {
            return Integer.parseInt(output);
        }
        catch (NumberFormatException e) {
            LogUtil.CLog.w("unable to parse result of '" + command + "' : " + output);
            return null;
        }
    }
}

