/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.suite.checker;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.StatusCheckerResult;
import com.android.tradefed.util.ProcessInfo;
import com.android.tradefed.util.StreamUtil;

public class SystemServerStatusChecker
implements ISystemStatusChecker {
    @Option(name="disable-recovery-reboot", description="If status checker is detected down (no process), attempt to reboot the device.")
    private boolean mShouldRecover = true;
    private ProcessInfo mSystemServerProcess;
    private boolean mShouldSkip = false;

    @Override
    public StatusCheckerResult preExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mShouldSkip) {
            return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        }
        if (device.getApiLevel() < 29) {
            this.mShouldSkip = true;
            LogUtil.CLog.d("Api level is under 29 skipping SystemServerStatusChecker");
            return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        }
        this.mSystemServerProcess = device.getProcessByName("system_server");
        StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        if (this.mSystemServerProcess == null) {
            if (this.mShouldRecover) {
                device.reboot();
            }
            String message2 = "No valid system_server process is found.";
            LogUtil.CLog.w(message2);
            result.setStatus(StatusCheckerResult.CheckStatus.FAILED);
            result.setBugreportNeeded(true);
            result.setErrorMessage(message2);
            return result;
        }
        return result;
    }

    @Override
    public StatusCheckerResult postExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mShouldSkip) {
            return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        }
        if (this.mSystemServerProcess == null) {
            LogUtil.CLog.d("No valid system_server process was found in preExecutionCheck, skipping system_server postExecutionCheck.");
            return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        }
        try {
            if (!device.deviceSoftRestarted(this.mSystemServerProcess)) {
                return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
            }
        }
        catch (RuntimeException e) {
            LogUtil.CLog.w(StreamUtil.getStackTrace(e));
            StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.FAILED);
            result.setBugreportNeeded(true);
            result.setErrorMessage(StreamUtil.getStackTrace(e));
            return result;
        }
        StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.FAILED);
        result.setErrorMessage("The system-server crashed during test execution");
        return result;
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }
}

