/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.suite.checker;

import com.android.ddmlib.Log;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.StatusCheckerResult;
import com.android.tradefed.util.TimeUtil;
import java.util.Date;

public class TimeStatusChecker
implements ISystemStatusChecker {
    private boolean mFailing = false;

    @Override
    public StatusCheckerResult postExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        long difference = device.getDeviceTimeOffset(new Date());
        if (difference > 5000L) {
            String message2 = String.format("Found a difference of '%s' between the host and device clock, resetting the device time.", TimeUtil.formatElapsedTime(difference));
            LogUtil.CLog.w(message2);
            device.logOnDevice("Tradefed.TimeStatusChecker", Log.LogLevel.VERBOSE, "Module Checker is about to reset the time.", new Object[0]);
            device.setDate(new Date());
            if (this.mFailing) {
                LogUtil.CLog.w("TimeStatusChecker is still failing on %s", device.getSerialNumber());
                return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
            }
            StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.FAILED);
            result.setErrorMessage(message2);
            this.mFailing = true;
            return result;
        }
        this.mFailing = false;
        return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
    }
}

