/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.suite.checker;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.UserInfo;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.StatusCheckerResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

@OptionClass(alias="user-system-checker")
public class UserChecker
implements ISystemStatusChecker {
    @Option(name="user-type", description="The type of user to switch to before each module run.")
    private UserInfo.UserType mUserToSwitchTo = UserInfo.UserType.CURRENT;
    @Option(name="user-cleanup", description="If true, attempt to cleanup any changes made to users:\n - switch to previous current-user\n - remove any created users\n\nThis does NOT:\n - attempt to re-create a user that was deleted\n - start/stop existing users if their running status changed")
    private boolean mCleanup = false;
    private UserInfo mPreCurrentUserInfo = null;
    private Map<Integer, UserInfo> mPreUsersInfo = null;
    private int mSwitchedToUserId = -1;

    @Override
    public StatusCheckerResult preExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        this.mPreUsersInfo = device.getUserInfos();
        this.mPreCurrentUserInfo = this.mPreUsersInfo.get(device.getCurrentUser());
        if (this.mPreCurrentUserInfo.isUserType(this.mUserToSwitchTo, this.mPreCurrentUserInfo.userId())) {
            LogUtil.CLog.i("Current user %d is already user type %s, no action.", this.mPreCurrentUserInfo.userId(), this.mUserToSwitchTo.toString());
            return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
        }
        this.mSwitchedToUserId = this.findMatchingUser(this.mPreUsersInfo.values());
        if (this.mSwitchedToUserId < 0) {
            this.mSwitchedToUserId = device.createUser("Tf" + this.mUserToSwitchTo.toString().toLowerCase(), this.mUserToSwitchTo.isGuest(), false);
            LogUtil.CLog.i("No user of type %s found, created user %d", this.mUserToSwitchTo.toString(), this.mSwitchedToUserId);
        }
        LogUtil.CLog.i("Current user is %d, switching to user %s of type %s", new Object[]{this.mPreCurrentUserInfo.userId(), this.mSwitchedToUserId, this.mUserToSwitchTo});
        if (!device.switchUser(this.mSwitchedToUserId)) {
            return UserChecker.statusFail(String.format("Failed to switch to user %d", this.mSwitchedToUserId));
        }
        return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
    }

    @Override
    public StatusCheckerResult postExecutionCheck(ITestDevice device) throws DeviceNotAvailableException {
        Map<Integer, UserInfo> postUsersInfo = device.getUserInfos();
        UserInfo postCurrentUserInfo = postUsersInfo.get(device.getCurrentUser());
        ArrayList<String> errors = new ArrayList<String>();
        if (this.mPreCurrentUserInfo.userId() != postCurrentUserInfo.userId()) {
            if (postCurrentUserInfo.userId() != this.mSwitchedToUserId) {
                errors.add(String.format("User %d was the currentUser before, has changed to %d", this.mPreCurrentUserInfo.userId(), postCurrentUserInfo.userId()));
            }
            if (this.mCleanup && !device.switchUser(this.mPreCurrentUserInfo.userId())) {
                errors.add(String.format("Failed to switch back to previous current user %d. Check if it was removed.", this.mPreCurrentUserInfo.userId()));
            }
        }
        for (UserInfo preUserInfo : this.mPreUsersInfo.values()) {
            int preUserId = preUserInfo.userId();
            if (!postUsersInfo.containsKey(preUserId)) {
                errors.add(String.format("User %d no longer exists after test", preUserId));
                continue;
            }
            UserInfo postUserInfo = postUsersInfo.get(preUserId);
            if (preUserInfo.isRunning() == postUserInfo.isRunning()) continue;
            LogUtil.CLog.w("User %d running status changed from %b -> %b", preUserId, preUserInfo.isRunning(), postUserInfo.isRunning());
        }
        Iterator<Object> iterator2 = postUsersInfo.keySet().iterator();
        while (iterator2.hasNext()) {
            int postUserId = (Integer)iterator2.next();
            if (this.mPreUsersInfo.containsKey(postUserId)) continue;
            if (this.mSwitchedToUserId != postUserId) {
                errors.add(String.format("User %d was created during test and not deleted", postUserId));
            }
            if (!this.mCleanup || device.removeUser(postUserId)) continue;
            errors.add(String.format("Failed to remove new user %d", postUserId));
        }
        if (errors.size() > 0) {
            return UserChecker.statusFail(String.join((CharSequence)"\n", errors));
        }
        return new StatusCheckerResult(StatusCheckerResult.CheckStatus.SUCCESS);
    }

    private int findMatchingUser(Collection<UserInfo> usersInfo) {
        for (UserInfo userInfo : usersInfo) {
            if (!userInfo.isUserType(this.mUserToSwitchTo, this.mPreCurrentUserInfo.userId())) continue;
            return userInfo.userId();
        }
        return -1;
    }

    private static StatusCheckerResult statusFail(String msg) {
        StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.FAILED);
        result.setErrorMessage(msg);
        return result;
    }
}

