/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.suite.checker.baseline;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.suite.checker.baseline.DeviceBaselineSetter;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LockSettingsBaselineSetter
extends DeviceBaselineSetter {
    private final List<String> mClearPwdCommands;
    private static final String GET_LOCK_SCREEN_COMMAND = "locksettings get-disabled";
    private static final String LOCK_SCREEN_OFF_COMMAND = "locksettings set-disabled true";
    private static final String CLEAR_PWD_COMMAND = "locksettings clear --old %s";

    public LockSettingsBaselineSetter(JSONObject object, String name) throws JSONException {
        super(object, name);
        ArrayList<String> clearPwdCommands = new ArrayList<String>();
        JSONArray pwds = object.getJSONArray("clear_pwds");
        for (int index = 0; index < pwds.length(); ++index) {
            clearPwdCommands.add(String.format(CLEAR_PWD_COMMAND, pwds.getString(index)));
        }
        this.mClearPwdCommands = clearPwdCommands;
    }

    @Override
    public boolean setBaseline(ITestDevice mDevice) throws DeviceNotAvailableException {
        if ("true".equals(mDevice.executeShellCommand(GET_LOCK_SCREEN_COMMAND).trim())) {
            return true;
        }
        for (String command : this.mClearPwdCommands) {
            mDevice.executeShellCommand(command);
        }
        mDevice.executeShellCommand(LOCK_SCREEN_OFF_COMMAND);
        return "true".equals(mDevice.executeShellCommand(GET_LOCK_SCREEN_COMMAND).trim());
    }
}

