/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseEmulatorPreparer
extends BaseTargetPreparer {
    @Option(name="gpu", description="emulator gpu mode to use")
    private String mGpu = "swiftshader_indirect";
    @Option(name="emulator-path", description="path to emulator binary")
    private String mEmulatorPath = "emulator";
    @Option(name="window", description="launch emulator with a window")
    private boolean mWindow = false;
    @Option(name="feature", description="comma separated list of emulator features to enable")
    private String mFeatures = "";
    @Option(name="avd-name", description="avd name to use")
    private String mAvdName = null;
    @Option(name="sdk-root", description="Android SDK root file path. If set, --emulator-path will be ignored")
    private File mSdkRoot = null;
    @Option(name="avd-root", description="file path to custom AVD storage location. If unset, emulator will use the default AVD folder.")
    private File mAvdRoot = null;

    protected List<String> buildEmulatorLaunchArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.mSdkRoot != null) {
            args.add(Paths.get(this.mSdkRoot.getAbsolutePath(), "emulator", "emulator").toString());
        } else {
            args.add(this.mEmulatorPath);
        }
        args.add("-gpu");
        args.add(this.mGpu);
        if (!this.mWindow) {
            args.add("-no-window");
        }
        if (!this.mFeatures.isEmpty()) {
            args.add("-feature");
            args.add(this.mFeatures);
        }
        if (this.mAvdName != null) {
            args.add("-avd");
            args.add(this.mAvdName);
        }
        return args;
    }

    protected RunUtil buildRunUtilForEmulatorLaunch() {
        RunUtil runUtil = new RunUtil();
        if (this.mSdkRoot != null) {
            runUtil.setEnvVariable("ANDROID_HOME", this.mSdkRoot.getAbsolutePath());
        }
        if (this.mAvdRoot != null) {
            runUtil.setEnvVariable("ANDROID_AVD_HOME", this.mAvdRoot.getAbsolutePath());
        }
        return runUtil;
    }
}

