/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;

@OptionClass(alias="build-info-recorder")
public class BuildInfoRecorder
extends BaseTargetPreparer {
    @Option(name="build-info-file", description="when specified, build info will be written into the file specified. Any existing file will be overwritten.")
    private File mBuildInfoFile = null;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mBuildInfoFile != null) {
            IBuildInfo buildInfo = testInfo.getBuildInfo();
            try {
                String alias = buildInfo.getBuildAttributes().get("build_alias");
                if (alias == null) {
                    alias = buildInfo.getBuildId();
                }
                FileUtil.writeToFile(String.format("%s=%s\n%s=%s\n", "build_id", buildInfo.getBuildId(), "build_alias", alias), this.mBuildInfoFile);
            }
            catch (IOException ioe) {
                LogUtil.CLog.e("Exception while writing build info into %s", this.mBuildInfoFile.getAbsolutePath());
                LogUtil.CLog.e(ioe);
            }
        }
    }
}

