/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.google.common.annotations.VisibleForTesting;

@OptionClass(alias="boot-image-speed-preparer")
public final class CompileBootImageWithSpeedTargetPreparer
extends BaseTargetPreparer {
    @Option(name="compile-boot-image-speed", description="Compile the boot image in speed, not speed-profile")
    private boolean mEnableBootImageSpeed = true;
    @VisibleForTesting
    static final String COMPILE_BOOT_IMAGE_SPEED_CMD = "odrefresh --system-server-compiler-filter=speed --boot-image-compiler-filter=speed --force-compile";
    @VisibleForTesting
    static final String COMPILE_BOOT_IMAGE_SPEED_PROFILE_CMD = "odrefresh --force-compile";

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        if (device.getIDevice() instanceof StubDevice) {
            return;
        }
        device.executeShellCommand("stop");
        device.executeShellCommand("setprop dev.bootcomplete 0");
        if (this.mEnableBootImageSpeed) {
            device.executeShellCommand(COMPILE_BOOT_IMAGE_SPEED_CMD);
        } else {
            device.executeShellCommand(COMPILE_BOOT_IMAGE_SPEED_PROFILE_CMD);
        }
        device.executeShellCommand("start");
        device.waitForDeviceAvailable();
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        if (device.getIDevice() instanceof StubDevice) {
            return;
        }
    }
}

