/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

@OptionClass(alias="avd")
public class CreateAvdPreparer
extends BaseTargetPreparer
implements IConfigurationReceiver {
    @Option(name="avd-device", description="The device configuration to use for AVD. eg 'Nexus One'. See sdk/cmdline-tools/bin/avdmanager list devices for full list")
    private String mDeviceType = "Nexus One";
    @Option(name="sdk-root", description="The root filesystem path of Android SDK.")
    private File mSdkRoot = null;
    @Option(name="system-image-path", description="The path to system image to use. Expected format: 'system-images;android-30;default;x86. If unset, the first system image found in --sdk-root will be used")
    private String mSystemImagePath = null;
    private IConfiguration mConfig;

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfig = configuration;
    }

    @Override
    public void setUp(TestInformation testInformation) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        Preconditions.checkNotNull(this.mSdkRoot, "Invalid configuration: --sdk-root was not set");
        try {
            File avdHome = FileUtil.createTempDir("avd-home", CurrentInvocation.getWorkFolder());
            Path avdManagerPath = Paths.get(this.mSdkRoot.getAbsolutePath(), "cmdline-tools", "latest", "bin", "avdmanager");
            String systemImagePath = this.getSystemImagePath(this.mSdkRoot);
            String avdName = this.mDeviceType.replace(' ', '_');
            RunUtil runUtil = new RunUtil();
            runUtil.setEnvVariable("ANDROID_SDK_ROOT", this.mSdkRoot.getAbsolutePath());
            runUtil.setEnvVariable("ANDROID_AVD_HOME", avdHome.getAbsolutePath());
            CommandResult result = runUtil.runTimedCmd(10000L, avdManagerPath.toString(), "create", "avd", "--device", this.mDeviceType, "--name", avdName, "--package", systemImagePath);
            if (result.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.e("avdmanager failed: stderr: \n" + result.getStderr());
                LogUtil.CLog.e("avdmanager failed: stdout: \n" + result.getStdout());
                throw new TargetSetupError("failed to create avd via avdmanager", testInformation.getDevice().getDeviceDescriptor());
            }
            LogUtil.CLog.i("Successfully created avd %s for %s", avdName, systemImagePath);
            this.mConfig.injectOptionValue("avd-root", avdHome.getAbsolutePath());
            this.mConfig.injectOptionValue("avd-name", avdName);
        }
        catch (ConfigurationException | IOException e) {
            throw new TargetSetupError("failed to create avd", (Throwable)e, testInformation.getDevice().getDeviceDescriptor());
        }
    }

    private String getSystemImagePath(File sdk) throws IOException {
        Optional<Path> firstSystemImage;
        if (this.mSystemImagePath != null) {
            return this.mSystemImagePath;
        }
        Path systemImagesRoot = sdk.toPath().resolve("system-images");
        try (Stream<Path> stream = Files.walk(systemImagesRoot, new FileVisitOption[0]);){
            firstSystemImage = stream.filter(new Predicate<Path>(){

                @Override
                public boolean test(Path path) {
                    return path.getFileName().toString().equals("system.img") && Files.isRegularFile(path, new LinkOption[0]);
                }
            }).findFirst();
        }
        if (!firstSystemImage.isPresent()) {
            throw new IOException("failed to find any system.img file inside " + systemImagesRoot);
        }
        Path systemImageDir = firstSystemImage.get().getParent();
        return sdk.toPath().relativize(systemImageDir).toString().replace(File.separatorChar, ';');
    }
}

