/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.UserHelper;

@OptionClass(alias="create-user-preparer")
public class CreateUserPreparer
extends BaseTargetPreparer {
    @Option(name="reuse-test-user", description="Whether or not to reuse already created tradefed test user, or remove them  and re-create them between module runs.")
    private boolean mReuseTestUser;
    private Integer mOriginalUser;
    private Integer mCreatedUserId;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        this.mOriginalUser = device.getCurrentUser();
        if (this.mOriginalUser == -10000) {
            this.mOriginalUser = null;
            throw new TargetSetupError("Failed to get the current user.", device.getDeviceDescriptor());
        }
        LogUtil.CLog.i("setUp(): mOriginalUser=%d, mReuseTestUser=%b", this.mOriginalUser, this.mReuseTestUser);
        this.mCreatedUserId = UserHelper.createUser(device, this.mReuseTestUser);
        this.switchCurrentUser(device, this.mCreatedUserId);
        device.waitForDeviceAvailable();
        device.postBootSetup();
    }

    private void switchCurrentUser(ITestDevice device, int userId) throws TargetSetupError, DeviceNotAvailableException {
        if (!device.startUser(this.mCreatedUserId, true)) {
            throw new TargetSetupError(String.format("Failed to start to user '%s'", this.mCreatedUserId), device.getDeviceDescriptor());
        }
        if (!device.switchUser(this.mCreatedUserId)) {
            throw new TargetSetupError(String.format("Failed to switch to user '%s'", this.mCreatedUserId), device.getDeviceDescriptor());
        }
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (this.mCreatedUserId == null) {
            LogUtil.CLog.d("Skipping teardown because no user was created");
            return;
        }
        if (e instanceof DeviceNotAvailableException) {
            LogUtil.CLog.d("Skipping teardown due to dnae: %s", e.getMessage());
            return;
        }
        ITestDevice device = testInfo.getDevice();
        if (this.mOriginalUser == null) {
            LogUtil.CLog.d("Skipping teardown because original user is null");
            return;
        }
        this.switchBackToOriginalUser(device);
        if (!this.mReuseTestUser) {
            device.removeUser(this.mCreatedUserId);
        }
    }

    private void switchBackToOriginalUser(ITestDevice device) throws DeviceNotAvailableException {
        LogUtil.CLog.d("switchBackToOriginalUser(): switching current user from %d to user %d ", this.mCreatedUserId, this.mOriginalUser);
        if (!device.switchUser(this.mOriginalUser)) {
            LogUtil.CLog.e("Failed to switch back to original user '%s'", this.mOriginalUser);
        }
    }
}

