/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.DeviceBuildDescriptor;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;

@OptionClass(alias="device-build-injector")
public class DeviceBuildInfoInjector
extends BaseTargetPreparer {
    @Option(name="override-device-build-branch", description="the device buid branch to inject.")
    private String mOverrideDeviceBuildBranch = null;
    @Option(name="override-device-build-id", description="the device buid id to inject.")
    private String mOverrideDeviceBuildId = null;
    @Option(name="override-device-build-alias", description="the device buid alias to inject.")
    private String mOverrideDeviceBuildAlias = null;
    @Option(name="override-device-build-flavor", description="the device build flavor to inject.")
    private String mOverrideDeviceBuildFlavor = null;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        LogUtil.CLog.e("changing build info: %s, hash: %d", buildInfo.toString(), buildInfo.hashCode());
        ITestDevice device = testInfo.getDevice();
        if (this.mOverrideDeviceBuildId != null) {
            buildInfo.addBuildAttribute("device_build_id", this.mOverrideDeviceBuildId);
        } else {
            buildInfo.addBuildAttribute("device_build_id", device.getBuildId());
        }
        if (this.mOverrideDeviceBuildAlias != null) {
            buildInfo.addBuildAttribute("device_build_alias", this.mOverrideDeviceBuildAlias);
        } else {
            buildInfo.addBuildAttribute("device_build_alias", device.getBuildAlias());
        }
        if (this.mOverrideDeviceBuildBranch != null) {
            buildInfo.addBuildAttribute("device_build_branch", this.mOverrideDeviceBuildBranch);
        }
        if (this.mOverrideDeviceBuildFlavor != null) {
            buildInfo.addBuildAttribute("device_build_flavor", this.mOverrideDeviceBuildFlavor);
        } else {
            String buildFlavor = String.format("%s-%s", device.getProperty("ro.product.name"), device.getProperty("ro.build.type"));
            buildInfo.addBuildAttribute("device_build_flavor", buildFlavor);
        }
        buildInfo.addBuildAttribute("device_description", DeviceBuildDescriptor.generateDeviceDesc(device));
        buildInfo.addBuildAttribute("device_product", DeviceBuildDescriptor.generateDeviceProduct(device));
    }
}

