/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.DeviceFailedToBootError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.RunUtil;

@OptionClass(alias="device-cleaner")
public class DeviceCleaner
extends BaseTargetPreparer {
    private static final int MAX_SCREEN_OFF_RETRY = 5;
    private static final int SCREEN_OFF_RETRY_DELAY_MS = 2000;
    @Option(name="cleanup-action", description="Type of action to perform as a post test cleanup; options are: NONE, REBOOT or FORMAT; defaults to NONE")
    private CleanupAction mCleanupAction = CleanupAction.NONE;
    @Deprecated
    @Option(name="screen-off", description="After cleanup action, if screen should be turned off; defaults to false; [deprecated] use --post-cleanup SCREEN_OFF instead")
    private boolean mScreenOff = false;
    @Option(name="post-cleanup", description="Type of action to perform after the cleanup action;this will override the deprecated screen-off action if specified")
    private PostCleanupAction mPostCleanupAction = PostCleanupAction.NONE;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (e instanceof DeviceNotAvailableException) {
            LogUtil.CLog.w("Skipping device clean up due to device unavailable.");
            return;
        }
        if (e instanceof DeviceFailedToBootError) {
            LogUtil.CLog.w("Skipping device clean up due to boot failure.");
            return;
        }
        this.clean(testInfo.getDevice());
    }

    protected void clean(ITestDevice device) throws DeviceNotAvailableException {
        if (TestDeviceState.ONLINE.equals((Object)device.getDeviceState())) {
            switch (this.mCleanupAction) {
                case NONE: {
                    break;
                }
                case REBOOT: {
                    device.reboot();
                    break;
                }
                case FORMAT: {
                    device.rebootIntoBootloader();
                    device.executeLongFastbootCommand("-w");
                    device.executeFastbootCommand("reboot");
                    device.waitForDeviceAvailable();
                }
            }
            if (this.mScreenOff && this.mPostCleanupAction == PostCleanupAction.NONE) {
                this.mPostCleanupAction = PostCleanupAction.SCREEN_OFF;
            }
            switch (this.mPostCleanupAction) {
                case NONE: {
                    break;
                }
                case SCREEN_OFF: {
                    this.turnScreenOff(device);
                    break;
                }
                case SCREEN_OFF_AND_STOP: {
                    this.turnScreenOff(device);
                    device.executeShellCommand("stop");
                }
            }
        }
    }

    private void turnScreenOff(ITestDevice device) throws DeviceNotAvailableException {
        String output = device.executeShellCommand("dumpsys power | grep -e mScreenOn -e mInteractive");
        int retries = 1;
        while (output.contains("mScreenOn=true") || output.contains("mInteractive=true")) {
            device.executeShellCommand("input keyevent 26");
            RunUtil.getDefault().sleep(2000 * retries);
            output = device.executeShellCommand("dumpsys power | grep -e mScreenOn -e mInteractive");
            if (++retries <= 5) continue;
            LogUtil.CLog.w(String.format("screen still on after %d retries", retries));
            break;
        }
    }

    public static enum CleanupAction {
        NONE,
        REBOOT,
        FORMAT;

    }

    public static enum PostCleanupAction {
        NONE,
        SCREEN_OFF,
        SCREEN_OFF_AND_STOP;

    }
}

