/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.NullDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.retry.BaseRetryDecision;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.DeviceFailedToBootError;
import com.android.tradefed.targetprep.FastbootDeviceFlasher;
import com.android.tradefed.targetprep.FlashingMethod;
import com.android.tradefed.targetprep.IDeviceFlasher;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.image.DeviceImageTracker;
import com.android.tradefed.util.image.IncrementalImageUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public abstract class DeviceFlashPreparer
extends BaseTargetPreparer
implements IConfigurationReceiver {
    private static final int BOOT_POLL_TIME_MS = 5000;
    private static final long SNAPSHOT_CANCEL_TIMEOUT = 20000L;
    @Option(name="device-boot-time", description="max time to wait for device to boot.", isTimeVal=true)
    private long mDeviceBootTime = 300000L;
    @Option(name="userdata-flash", description="specify handling of userdata partition.")
    private IDeviceFlasher.UserDataFlashOption mUserDataFlashOption = IDeviceFlasher.UserDataFlashOption.FLASH;
    @Option(name="force-system-flash", description="specify if system should always be flashed even if already running desired build.")
    private boolean mForceSystemFlash = false;
    @Deprecated
    @Option(name="skip-post-flash-flavor-check", description="specify if system flavor should not be checked after flash")
    private boolean mSkipPostFlashFlavorCheck = false;
    @Option(name="skip-post-flash-build-id-check", description="specify if build ID should not be checked after flash")
    private boolean mSkipPostFlashBuildIdCheck = false;
    @Option(name="wipe-skip-list", description="list of /data subdirectories to NOT wipe when doing UserDataFlashOption.TESTS_ZIP")
    private Collection<String> mDataWipeSkipList = new ArrayList<String>();
    @Deprecated
    @Option(name="concurrent-flasher-limit", description="No-op, do not use. Left for backwards compatibility.")
    private Integer mConcurrentFlasherLimit = null;
    @Option(name="skip-post-flashing-setup", description="whether or not to skip post-flashing setup steps")
    private boolean mSkipPostFlashingSetup = false;
    @Option(name="wipe-timeout", description="the timeout for the command of wiping user data.", isTimeVal=true)
    private long mWipeTimeout = 240000L;
    @Option(name="fastboot-flash-option", description="additional options to pass with fastboot flash/update command.")
    private Collection<String> mFastbootFlashOptions = new ArrayList<String>();
    @Option(name="flash-ramdisk", description="flashes ramdisk (usually on boot partition) in addition to regular system image")
    private boolean mShouldFlashRamdisk = false;
    @Option(name="ramdisk-partition", description="the partition (such as boot, vendor_boot) that ramdisk image should be flashed to")
    private String mRamdiskPartition = "boot";
    @Option(name="cancel-ota-snapshot", description="In case an OTA snapshot is in progress, cancel it.")
    private boolean mCancelSnapshot = false;
    @Option(name="incremental-flashing", description="Leverage the incremental flashing feature for device update.")
    private boolean mUseIncrementalFlashing = false;
    @Option(name="force-disable-incremental-flashing", description="Ignore HostOptions and disable the feature if true.")
    private boolean mForceDisableIncrementalFlashing = false;
    @Option(name="create-snapshot-binary", description="Override the create_snapshot binary for incremental flashing.")
    private File mCreateSnapshotBinary = null;
    private IncrementalImageUtil mIncrementalImageUtil;
    private IConfiguration mConfig;

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfig = configuration;
    }

    void setDeviceBootTime(long bootTime) {
        this.mDeviceBootTime = bootTime;
    }

    protected long getDeviceBootWaitTime() {
        return this.mDeviceBootTime;
    }

    int getDeviceBootPollTimeMs() {
        return 5000;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    protected IHostOptions getHostOptions() {
        return GlobalConfiguration.getInstance().getHostOptions();
    }

    public void setUserDataFlashOption(IDeviceFlasher.UserDataFlashOption flashOption) {
        this.mUserDataFlashOption = flashOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, DeviceNotAvailableException, BuildError {
        boolean useIncrementalFlashing;
        if (testInfo.getDevice().getIDevice() instanceof NullDevice) {
            LogUtil.CLog.i("Skipping device flashing, this is a null-device.");
            return;
        }
        ITestDevice device = testInfo.getDevice();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        LogUtil.CLog.i("Performing setup on %s", device.getSerialNumber());
        if (!(buildInfo instanceof IDeviceBuildInfo)) {
            throw new IllegalArgumentException("Provided buildInfo is not a IDeviceBuildInfo");
        }
        IDeviceBuildInfo deviceBuild = (IDeviceBuildInfo)buildInfo;
        if (this.mShouldFlashRamdisk && deviceBuild.getRamdiskFile() == null) {
            throw new HarnessRuntimeException("ramdisk flashing enabled but no ramdisk file was found in build info", InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
        }
        if (TestDeviceState.ONLINE.equals((Object)testInfo.getDevice().getDeviceState())) {
            buildInfo.addBuildAttribute("original_build_fingerprint", device.getProperty("ro.product.build.fingerprint"));
        }
        long queueTime = -1L;
        long flashingTime = -1L;
        long start = -1L;
        if (this.getHostOptions().isIncrementalFlashingEnabled()) {
            this.mUseIncrementalFlashing = true;
        }
        if (this.getHostOptions().isOptOutOfIncrementalFlashing()) {
            this.mUseIncrementalFlashing = false;
        }
        if (this.mForceDisableIncrementalFlashing) {
            this.mUseIncrementalFlashing = false;
        }
        if (useIncrementalFlashing = this.mUseIncrementalFlashing) {
            boolean isIsolated = false;
            if (this.mConfig.getRetryDecision() instanceof BaseRetryDecision) {
                isIsolated = CurrentInvocation.IsolationGrade.FULLY_ISOLATED.equals((Object)((BaseRetryDecision)this.mConfig.getRetryDecision()).getIsolationGrade());
            }
            this.mIncrementalImageUtil = IncrementalImageUtil.initialize(device, deviceBuild, this.mCreateSnapshotBinary, isIsolated);
            if (this.mIncrementalImageUtil == null) {
                useIncrementalFlashing = false;
            } else if (TestDeviceState.ONLINE.equals((Object)device.getDeviceState())) {
                String verityOutput = device.executeAdbCommand("enable-verity");
                LogUtil.CLog.d("%s", verityOutput);
            }
        }
        try {
            this.checkDeviceProductType(device, deviceBuild);
            device.setRecoveryMode(ITestDevice.RecoveryMode.ONLINE);
            IDeviceFlasher flasher = this.createFlasher(device);
            flasher.setWipeTimeout(this.mWipeTimeout);
            try {
                CommandResult res;
                flasher.overrideDeviceOptions(device);
                flasher.setUserDataFlashOption(this.mUserDataFlashOption);
                flasher.setForceSystemFlash(this.mForceSystemFlash);
                flasher.setDataWipeSkipList(this.mDataWipeSkipList);
                flasher.setShouldFlashRamdisk(this.mShouldFlashRamdisk);
                if (this.mShouldFlashRamdisk) {
                    flasher.setRamdiskPartition(this.mRamdiskPartition);
                }
                if (flasher instanceof FastbootDeviceFlasher) {
                    ((FastbootDeviceFlasher)flasher).setFlashOptions(this.mFastbootFlashOptions);
                    ((FastbootDeviceFlasher)flasher).setIncrementalFlashing(this.mIncrementalImageUtil);
                }
                start = System.currentTimeMillis();
                flasher.preFlashOperations(device, deviceBuild);
                if (this.mCancelSnapshot && TestDeviceState.FASTBOOT.equals((Object)device.getDeviceState()) && !CommandStatus.SUCCESS.equals((Object)(res = device.executeFastbootCommand(20000L, "snapshot-update", "cancel")).getStatus())) {
                    LogUtil.CLog.w("Failed to cancel snapshot: %s.\nstdout:%s\nstderr:%s", new Object[]{res.getStatus(), res.getStdout(), res.getStderr()});
                }
                try (CloseableTraceScope ignored = new CloseableTraceScope("wait_for_flashing_permit");){
                    this.getHostOptions().takePermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
                    queueTime = System.currentTimeMillis() - start;
                    LogUtil.CLog.v("Flashing permit obtained after %ds", TimeUnit.MILLISECONDS.toSeconds(queueTime));
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.FLASHING_PERMIT_LATENCY, queueTime);
                }
                this.getRunUtil().allowInterrupt(false);
                start = System.currentTimeMillis();
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.FLASHING_METHOD, FlashingMethod.FASTBOOT_UNCATEGORIZED.toString());
                flasher.flash(device, deviceBuild);
            }
            catch (DeviceNotAvailableException | TargetSetupError | RuntimeException e) {
                DeviceImageTracker.getDefaultCache().invalidateTracking(device.getSerialNumber());
                throw e;
            }
            finally {
                flashingTime = System.currentTimeMillis() - start;
                this.getHostOptions().returnPermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
                flasher.postFlashOperations(device, deviceBuild);
                CommandStatus status = flasher.getSystemFlashingStatus();
                if (status == null) {
                    LogUtil.CLog.i("Skipped reporting metrics because system partitions were not flashed.");
                } else {
                    if (this.mIncrementalImageUtil != null) {
                        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.INCREMENTAL_FLASHING_TIME, flashingTime);
                    }
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.FLASHING_TIME, flashingTime);
                    this.reportFlashMetrics(buildInfo.getBuildBranch(), buildInfo.getBuildFlavor(), buildInfo.getBuildId(), device.getSerialNumber(), queueTime, flashingTime, status);
                }
            }
            device.clearLogcat();
            if (this.mSkipPostFlashingSetup) {
                return;
            }
            this.getRunUtil().allowInterrupt(true);
            device.waitForDeviceOnline();
            if (device.enableAdbRoot()) {
                device.setDate(null);
            }
            this.getRunUtil().allowInterrupt(false);
            this.checkBuild(device, deviceBuild);
            this.getRunUtil().allowInterrupt(true);
            try {
                boolean available = device.waitForDeviceAvailableInRecoverPath(this.mDeviceBootTime);
                if (!available) {
                    DeviceImageTracker.getDefaultCache().invalidateTracking(device.getSerialNumber());
                    throw new DeviceFailedToBootError(String.format("Device %s did not become available after flashing %s", device.getSerialNumber(), deviceBuild.getDeviceBuildId()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.ERROR_AFTER_FLASHING);
                }
            }
            catch (DeviceNotAvailableException e) {
                DeviceImageTracker.getDefaultCache().invalidateTracking(device.getSerialNumber());
                throw new DeviceFailedToBootError(String.format("Device %s did not become available after flashing %s", device.getSerialNumber(), deviceBuild.getDeviceBuildId()), device.getDeviceDescriptor(), e, DeviceErrorIdentifier.ERROR_AFTER_FLASHING);
            }
            device.postBootSetup();
            if (!this.getHostOptions().isOptOutOfIncrementalFlashing() && this.mUseIncrementalFlashing && !useIncrementalFlashing) {
                DeviceImageTracker.getDefaultCache().trackUpdatedDeviceImage(device.getSerialNumber(), deviceBuild.getDeviceImageFile(), deviceBuild.getBootloaderImageFile(), deviceBuild.getBasebandImageFile(), deviceBuild.getBuildId(), deviceBuild.getBuildBranch(), deviceBuild.getBuildFlavor());
            }
        }
        finally {
            device.setRecoveryMode(ITestDevice.RecoveryMode.AVAILABLE);
            this.getRunUtil().allowInterrupt(true);
        }
    }

    protected void checkDeviceProductType(ITestDevice device, IDeviceBuildInfo deviceBuild) throws BuildError, DeviceNotAvailableException {
    }

    private void checkBuild(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException {
        if (!this.mSkipPostFlashBuildIdCheck) {
            this.checkBuildAttribute(deviceBuild.getDeviceBuildId(), device.getBuildId(), device.getSerialNumber());
        }
    }

    private void checkBuildAttribute(String expectedBuildAttr, String actualBuildAttr, String serial) throws DeviceNotAvailableException {
        if (expectedBuildAttr == null || actualBuildAttr == null || !expectedBuildAttr.equals(actualBuildAttr)) {
            throw new DeviceNotAvailableException(String.format("Unexpected build after flashing. Expected %s, actual %s", expectedBuildAttr, actualBuildAttr), serial, (ErrorIdentifier)DeviceErrorIdentifier.ERROR_AFTER_FLASHING);
        }
    }

    protected abstract IDeviceFlasher createFlasher(ITestDevice var1) throws DeviceNotAvailableException;

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (testInfo.getDevice().getIDevice() instanceof NullDevice) {
            LogUtil.CLog.i("Skipping device flashing tearDown, this is a null-device.");
            return;
        }
        if (this.mIncrementalImageUtil != null) {
            LogUtil.CLog.d("Teardown related to incremental update.");
            this.mIncrementalImageUtil.teardownDevice();
            this.mIncrementalImageUtil = null;
        }
    }

    protected void reportFlashMetrics(String branch, String buildFlavor, String buildId, String serial, long queueTime, long flashingTime, CommandStatus flashingStatus) {
    }

    void setShouldFlashRamdisk(boolean shouldFlashRamdisk) {
        this.mShouldFlashRamdisk = shouldFlashRamdisk;
    }

    protected void setSkipPostFlashBuildIdCheck(boolean skipPostFlashBuildIdCheck) {
        this.mSkipPostFlashBuildIdCheck = skipPostFlashBuildIdCheck;
    }

    protected void setUseIncrementalFlashing(boolean incrementalFlashing) {
        this.mUseIncrementalFlashing = incrementalFlashing;
    }
}

