/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.DeviceUpdateTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.ZipUtil2;
import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class DeviceImageZipFlashingTargetPreparer
extends DeviceUpdateTargetPreparer {
    private static final String ANDROID_SERIAL_ENV = "ANDROID_SERIAL";
    @Option(name="device-image-zip", description="the device image zip file to be flashed")
    private File mDeviceImageZip = null;
    @Option(name="flashing-timeout", description="timeout for flashing the device images", isTimeVal=true)
    private long mFlashingTimeout = 600000L;
    @Option(name="flashing-script", description="the name of the flashing script bundled within the device image zip file")
    private String mFlashingScript = "flash-all.sh";

    @Override
    protected File getDeviceUpdateImage() {
        return this.mDeviceImageZip;
    }

    @Override
    protected void preUpdateActions(File deviceUpdateImage, ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
    }

    @Override
    protected void postUpdateActions(File deviceUpdateImage, ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void performDeviceUpdate(File deviceUpdateImage, ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        extractedImage = null;
        try {
            extractedImage = DeviceImageZipFlashingTargetPreparer.extractZip(device, this.getDeviceUpdateImage());
            flashingScript = new File(extractedImage, this.mFlashingScript);
            if (!flashingScript.exists()) {
                throw new TargetSetupError(String.format("Flashing script \"%s\" not found inside the device image zip", new Object[]{this.mFlashingScript}), device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
            }
            runUtil = new RunUtil();
            runUtil.setEnvVariable("ANDROID_SERIAL", device.getSerialNumber());
            runUtil.setWorkingDir(extractedImage);
            LogUtil.CLog.i("Starting flashing on %s", new Object[]{device.getSerialNumber()});
            result = runUtil.runTimedCmd(this.mFlashingTimeout, new String[]{"bash", "-x", flashingScript.getAbsolutePath()});
            status = result.getStatus();
            sb = new StringBuilder();
            sb.append(String.format("Flashing command finished with status: %s\n", new Object[]{status.toString()}));
            sb.append(String.format("Flashing command stdout:\n%s\n", new Object[]{result.getStdout()}));
            sb.append(String.format("Flashing command stderr:\n%s\n", new Object[]{result.getStderr()}));
            if (!CommandStatus.SUCCESS.equals((Object)status)) {
                LogUtil.CLog.w(sb.toString());
            } else {
                LogUtil.CLog.v(sb.toString());
            }
            message = String.format("Flashing script failed (status: %s), check host logs above for details", new Object[]{status.toString()});
            switch (1.$SwitchMap$com$android$tradefed$util$CommandStatus[status.ordinal()]) {
                case 1: {
                    ** break;
                }
                case 2: 
                case 3: 
                case 4: {
                    throw new TargetSetupError(message, device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.ERROR_AFTER_FLASHING);
                }
                default: {
                    throw new IllegalStateException("Failsafe: not expected");
lbl32:
                    // 1 sources

                }
            }
        }
        catch (Throwable var10_10) {
            FileUtil.recursiveDelete(extractedImage);
            throw var10_10;
        }
        FileUtil.recursiveDelete(extractedImage);
    }

    private static File extractZip(ITestDevice device, File zip) throws TargetSetupError {
        File outputDir;
        ZipFile zFile = null;
        try {
            zFile = new ZipFile(zip);
            File fastbootTmpDir = GlobalConfiguration.getInstance().getHostOptions().getFastbootTmpDir();
            outputDir = FileUtil.createTempDir(DeviceImageZipFlashingTargetPreparer.class.getSimpleName() + "-tmp-files", fastbootTmpDir);
            ZipUtil2.extractZip(zFile, outputDir);
        }
        catch (IOException | IllegalStateException exception) {
            try {
                throw new TargetSetupError(exception.getMessage(), (Throwable)exception, device.getDeviceDescriptor());
            }
            catch (Throwable throwable) {
                ZipUtil2.closeZip(zFile);
                throw throwable;
            }
        }
        ZipUtil2.closeZip(zFile);
        return outputDir;
    }
}

