/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.dependencies.ExternalDependency;
import com.android.tradefed.dependencies.IExternalDependency;
import com.android.tradefed.dependencies.connectivity.BluetoothDependency;
import com.android.tradefed.dependencies.connectivity.EthernetDependency;
import com.android.tradefed.dependencies.connectivity.NetworkDependency;
import com.android.tradefed.dependencies.connectivity.TelephonyDependency;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.LocalAndroidVirtualDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.TestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.cloud.NestedRemoteDevice;
import com.android.tradefed.device.cloud.RemoteAndroidVirtualDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.DeviceFailedToBootError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.BinaryState;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.executor.ParallelDeviceExecutor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="device-setup")
public class DeviceSetup
extends BaseTargetPreparer
implements IExternalDependency {
    @Option(name="airplane-mode", description="Turn airplane mode on or off")
    protected BinaryState mAirplaneMode = BinaryState.IGNORE;
    @Option(name="data", description="Turn mobile data on or off")
    protected BinaryState mData = BinaryState.IGNORE;
    @Option(name="cell", description="Turn cellular radio on or off")
    protected BinaryState mCell = BinaryState.IGNORE;
    @Option(name="cell-auto-setting", description="Turn wear cellular mediator on or off")
    protected BinaryState mCellAutoSetting = BinaryState.IGNORE;
    @Option(name="wifi", description="Turn wifi on or off")
    protected BinaryState mWifi = BinaryState.IGNORE;
    @Option(name="skip-wifi-connection", description="Whether or not to completely skip connecting to wifi.")
    private boolean mSkipWifi = false;
    @Option(name="wifi-network", description="The SSID of the network to connect to. Will only attempt to connect to a network if set")
    protected String mWifiSsid = null;
    @Option(name="wifi-psk", description="The passphrase used to connect to a secured network")
    protected String mWifiPsk = null;
    @Option(name="wifi-ssid-to-psk", description="A map of wifi SSIDs to passwords.")
    protected Map<String, String> mWifiSsidToPsk = new LinkedHashMap<String, String>();
    @Option(name="wifi-watchdog", description="Turn wifi watchdog on or off")
    protected BinaryState mWifiWatchdog = BinaryState.IGNORE;
    @Option(name="disable-cw-wifi-mediator", description="Turn wifi mediator on or off")
    protected BinaryState mDisableCwWifiMediator = BinaryState.IGNORE;
    @Option(name="wifi-scan-always-enabled", description="Turn wifi scan always enabled on or off")
    protected BinaryState mWifiScanAlwaysEnabled = BinaryState.IGNORE;
    @Option(name="ethernet", description="Turn ethernet on or off")
    protected BinaryState mEthernet = BinaryState.IGNORE;
    @Option(name="bluetooth", description="Turn bluetooth on or off")
    protected BinaryState mBluetooth = BinaryState.IGNORE;
    @Option(name="nfc", description="Turn nfc on or off")
    protected BinaryState mNfc = BinaryState.IGNORE;
    @Option(name="screen-adaptive-brightness", description="Turn screen adaptive brightness on or off")
    protected BinaryState mScreenAdaptiveBrightness = BinaryState.IGNORE;
    @Option(name="screen-brightness", description="Set the screen brightness. This is uncalibrated from product to product")
    protected Integer mScreenBrightness = null;
    @Option(name="screen-always-on", description="Turn 'screen always on' on or off. If ON, then screen-timeout-secs must be unset. Will only work when the device is plugged in")
    protected BinaryState mScreenAlwaysOn = BinaryState.ON;
    @Option(name="screen-timeout-secs", description="Set the screen timeout in seconds. If set, then screen-always-on must be OFF or DEFAULT")
    protected Long mScreenTimeoutSecs = null;
    @Option(name="screen-ambient-mode", description="Turn screen ambient mode on or off")
    protected BinaryState mScreenAmbientMode = BinaryState.IGNORE;
    @Option(name="wake-gesture", description="Turn wake gesture on or off")
    protected BinaryState mWakeGesture = BinaryState.IGNORE;
    @Option(name="screen-saver", description="Turn screen saver on or off")
    protected BinaryState mScreenSaver = BinaryState.IGNORE;
    @Option(name="notification-led", description="Turn the notification led on or off")
    protected BinaryState mNotificationLed = BinaryState.IGNORE;
    @Option(name="install-non-market-apps", description="Allow or prevent non-market app to initiate an apk install request")
    protected BinaryState mInstallNonMarketApps = BinaryState.IGNORE;
    @Option(name="trigger-media-mounted", description="Trigger a MEDIA_MOUNTED broadcast")
    protected boolean mTriggerMediaMounted = false;
    @Option(name="location-gps", description="Turn the GPS location on or off")
    protected BinaryState mLocationGps = BinaryState.IGNORE;
    @Option(name="location-network", description="Turn the network location on or off")
    protected BinaryState mLocationNetwork = BinaryState.IGNORE;
    @Option(name="auto-rotate", description="Turn auto rotate on or off")
    protected BinaryState mAutoRotate = BinaryState.IGNORE;
    @Option(name="battery-saver-mode", description="Turn battery saver mode manually on or off. If OFF but battery is less battery-saver-trigger, the device will still go into battery saver mode")
    protected BinaryState mBatterySaver = BinaryState.IGNORE;
    @Option(name="battery-saver-trigger", description="Set the battery saver trigger level. Should be [1-99] to enable, or 0 to disable automatic battery saver mode")
    protected Integer mBatterySaverTrigger = null;
    @Option(name="enable-full-battery-stats-history", description="Enable full history for batterystats. This option is only applicable for L+")
    protected boolean mEnableFullBatteryStatsHistory = false;
    @Option(name="disable-doze", description="Disable device from going into doze mode. This option is only applicable for M+")
    protected boolean mDisableDoze = false;
    @Option(name="auto-update-time", description="Turn auto update time on or off")
    protected BinaryState mAutoUpdateTime = BinaryState.IGNORE;
    @Option(name="auto-update-timezone", description="Turn auto update timezone on or off")
    protected BinaryState mAutoUpdateTimezone = BinaryState.IGNORE;
    @Option(name="set-timezone", description="Set timezone property by TZ name (http://en.wikipedia.org/wiki/List_of_tz_database_time_zones)")
    protected String mTimezone = null;
    @Option(name="sync-timezone-with-host", description="Turn on or off that make the time zone of device sync with host")
    protected BinaryState mSyncTimezoneWithHost = BinaryState.IGNORE;
    @Option(name="disable-dialing", description="Disable dialing")
    protected boolean mDisableDialing = true;
    @Option(name="default-sim-data", description="Set the default sim card slot for data. Leave unset for single SIM devices")
    protected Integer mDefaultSimData = null;
    @Option(name="default-sim-voice", description="Set the default sim card slot for voice calls. Leave unset for single SIM devices")
    protected Integer mDefaultSimVoice = null;
    @Option(name="default-sim-sms", description="Set the default sim card slot for SMS. Leave unset for single SIM devices")
    protected Integer mDefaultSimSms = null;
    private static final boolean DEFAULT_DISABLE_AUDIO = true;
    @Option(name="disable-audio", description="Disable the audio")
    protected boolean mDisableAudio = true;
    @Option(name="force-skip-system-props", description="Force setup to not modify any device system properties. All other system property options will be ignored")
    protected boolean mForceSkipSystemProps = false;
    @Option(name="force-skip-settings", description="Force setup to not modify any device settings. All other setting options will be ignored.")
    protected boolean mForceSkipSettings = false;
    @Option(name="force-skip-run-commands", description="Force setup to not run any additional commands. All other commands will be ignored.")
    protected boolean mForceSkipRunCommands = false;
    @Option(name="set-test-harness", description="Set the read-only test harness flag on boot")
    protected boolean mSetTestHarness = true;
    @Option(name="hide-error-dialogs", description="Turn on or off the error dialogs.")
    protected BinaryState mHideErrorDialogs = BinaryState.ON;
    @Option(name="disable-dalvik-verifier", description="Disable the dalvik verifier on device. Allows package-private framework tests to run.")
    protected boolean mDisableDalvikVerifier = false;
    @Option(name="set-property", description="Set the specified property on boot. Option may be repeated but only the last value for a given key will be set.")
    protected Map<String, String> mSetProps = new HashMap<String, String>();
    @Option(name="restore-properties", description="Restore previous /data/local.prop on tear down, restoring any properties DeviceSetup changed by modifying /data/local.prop.")
    protected boolean mRestoreProperties = false;
    protected File mPreviousProperties;
    @Option(name="set-system-setting", description="Change a system (non-secure) setting. Option may be repeated and all key/value pairs will be set in order.")
    protected MultiMap<String, String> mSystemSettings = new MultiMap();
    @Option(name="set-secure-setting", description="Change a secure setting. Option may be repeated and all key/value pairs will be set in order.")
    protected MultiMap<String, String> mSecureSettings = new MultiMap();
    @Option(name="set-global-setting", description="Change a global setting. Option may be repeated and all key/value pairs will be set in order.")
    protected MultiMap<String, String> mGlobalSettings = new MultiMap();
    @Option(name="restore-settings", description="Restore settings modified by this preparer on tear down.")
    protected boolean mRestoreSettings = false;
    @Option(name="optimized-non-persistent-setup", description="Feature to evaluate a faster non-persistent props setup.")
    private boolean mOptimizeNonPersistentSetup = true;
    @Option(name="dismiss-setup-wizard", description="Attempt to dismiss the setup wizard if present.")
    private boolean mDismissSetupWizard = true;
    private Map<String, String> mPreviousSystemSettings = new HashMap<String, String>();
    private Map<String, String> mPreviousSecureSettings = new HashMap<String, String>();
    private Map<String, String> mPreviousGlobalSettings = new HashMap<String, String>();
    protected List<String> mRunCommandBeforeSettings = new ArrayList<String>();
    @Option(name="run-command", description="Run an adb shell command. Option may be repeated")
    protected List<String> mRunCommandAfterSettings = new ArrayList<String>();
    @Option(name="disconnect-wifi-after-test", description="Disconnect from wifi network after test completes.")
    private boolean mDisconnectWifiAfterTest = true;
    private static final long DEFAULT_MIN_EXTERNAL_STORAGE_KB = 500L;
    @Option(name="min-external-storage-kb", description="The minimum amount of free space in KB that must be present on device's external storage.")
    protected long mMinExternalStorageKb = 500L;
    @Option(name="local-data-path", description="Optional local file path of test data to sync to device's external storage. Use --remote-data-path to set remote location.")
    protected File mLocalDataFile = null;
    @Option(name="remote-data-path", description="Optional file path on device's external storage to sync test data. Must be used with --local-data-path.")
    protected String mRemoteDataPath = null;
    @Option(name="optimized-property-setting", description="If a property is already set to the desired value, don't reboot the device")
    protected boolean mOptimizedPropertySetting = true;
    @Option(name="min-external-store-space", description="deprecated, use option min-external-storage-kb. The minimum amount of free space in KB that must be present on device's external storage.")
    @Deprecated
    private long mDeprecatedMinExternalStoreSpace = 500L;
    @Option(name="audio-silent", description="deprecated, use option disable-audio. set ro.audio.silent on boot.")
    @Deprecated
    private boolean mDeprecatedSetAudioSilent = true;
    @Option(name="setprop", description="deprecated, use option set-property. set the specified property on boot. Format: --setprop key=value. May be repeated.")
    @Deprecated
    private Collection<String> mDeprecatedSetProps = new ArrayList<String>();
    @Option(name="skip-virtual-device-teardown", description="Whether or not to skip the teardown if it's a virtual device.")
    private boolean mSkipVirtualDeviceTeardown = true;
    @Option(name="disable-device-config-sync", description="Disable syncing device config with remote configuration server.")
    private boolean mDisableDeviceConfigSync = false;
    @Option(name="disable-ramdump", description="Will set the flag to disable ramdump on the device.")
    private boolean mDisableRamdump = false;
    @Option(name="parallelize-core-setup")
    private boolean mParallelCoreSetup = false;
    private static final String PERSIST_PREFIX = "persist.";
    private static final String MEMTAG_BOOTCTL = "arm64.memtag.bootctl";
    private static final List<String> PROPERTIES_NEEDING_REBOOT = List.of("arm64.memtag.bootctl", "persist.debug.dalvik.vm.jdwp.enabled");

    public ITestDevice getDevice(TestInformation testInfo) {
        return testInfo.getDevice();
    }

    @Override
    public void setUp(TestInformation testInfo) throws DeviceNotAvailableException, BuildError, TargetSetupError {
        ITestDevice device = this.getDevice(testInfo);
        LogUtil.CLog.i("Performing setup on %s", device.getSerialNumber());
        if (device.getOptions().isEnableAdbRoot() && !device.enableAdbRoot()) {
            throw new TargetSetupError(String.format("Failed to enable adb root on %s", device.getSerialNumber()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        this.processDeprecatedOptions(device);
        this.processOptions(device);
        this.changeSystemProps(device);
        this.runCommands(device, this.mRunCommandBeforeSettings);
        ArrayList callableTasks = new ArrayList();
        callableTasks.add(() -> {
            this.handleScreenAlwaysOnSetting(device);
            return true;
        });
        callableTasks.add(() -> {
            this.changeSettings(device);
            return true;
        });
        callableTasks.add(() -> {
            this.connectWifi(device);
            return true;
        });
        callableTasks.add(() -> {
            this.syncTestData(device);
            return true;
        });
        callableTasks.add(() -> {
            this.checkExternalStoreSpace(device);
            return true;
        });
        if (this.mDismissSetupWizard) {
            callableTasks.add(() -> {
                this.dismissSetupWiward(device);
                return true;
            });
        }
        if (this.mParallelCoreSetup) {
            List<Throwable> errors;
            Iterator<Throwable> iterator2;
            ParallelDeviceExecutor executor = new ParallelDeviceExecutor(callableTasks.size());
            executor.invokeAll(callableTasks, 5L, TimeUnit.MINUTES);
            if (executor.hasErrors() && (iterator2 = (errors = executor.getErrors()).iterator()).hasNext()) {
                Throwable error = iterator2.next();
                if (error instanceof TargetSetupError) {
                    throw (TargetSetupError)error;
                }
                if (error instanceof BuildError) {
                    throw (BuildError)error;
                }
                if (error instanceof DeviceNotAvailableException) {
                    throw (DeviceNotAvailableException)error;
                }
                throw new RuntimeException(error);
            }
        } else {
            this.handleScreenAlwaysOnSetting(device);
            this.changeSettings(device);
            this.connectWifi(device);
            this.syncTestData(device);
            this.checkExternalStoreSpace(device);
            if (this.mDismissSetupWizard) {
                this.dismissSetupWiward(device);
            }
        }
        this.runCommands(device, this.mRunCommandAfterSettings);
        device.clearErrorDialogs();
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        boolean wifiSet;
        ITestDevice device = testInfo.getDevice();
        if (device.getIDevice() instanceof StubDevice) {
            return;
        }
        if (device instanceof RemoteAndroidVirtualDevice && this.mSkipVirtualDeviceTeardown) {
            LogUtil.CLog.d("Skipping teardown on virtual device that will be deleted.");
            return;
        }
        if (e instanceof DeviceFailedToBootError) {
            LogUtil.CLog.d("boot failure: skipping teardown");
            return;
        }
        if (e instanceof DeviceNotAvailableException) {
            LogUtil.CLog.d("device not available: skipping teardown");
            return;
        }
        if (!TestDeviceState.ONLINE.equals((Object)device.getDeviceState())) {
            LogUtil.CLog.d("device offline: skipping teardown");
            return;
        }
        LogUtil.CLog.i("Performing teardown on %s", device.getSerialNumber());
        boolean bl = wifiSet = this.mWifiSsid != null || !this.mWifiSsidToPsk.isEmpty();
        if (this.mDisconnectWifiAfterTest && wifiSet && device.isWifiEnabled()) {
            boolean result = device.disconnectFromWifi();
            if (result) {
                LogUtil.CLog.i("Successfully disconnected from wifi network on %s", device.getSerialNumber());
            } else {
                LogUtil.CLog.w("Failed to disconnect from wifi network on %s", device.getSerialNumber());
            }
        }
        if (this.mRestoreProperties) {
            if (this.mPreviousProperties != null) {
                device.pushFile(this.mPreviousProperties, "/data/local.prop");
            } else {
                device.deleteFile("/data/local.prop");
            }
            device.reboot();
        }
        if (this.mRestoreSettings) {
            for (Map.Entry<String, String> entry : this.mPreviousSystemSettings.entrySet()) {
                device.setSetting("system", entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this.mPreviousGlobalSettings.entrySet()) {
                device.setSetting("global", entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this.mPreviousSecureSettings.entrySet()) {
                device.setSetting("secure", entry.getKey(), entry.getValue());
            }
        }
    }

    public void processDeprecatedOptions(ITestDevice device) throws TargetSetupError {
        if (this.mDeprecatedMinExternalStoreSpace != 500L) {
            if (this.mMinExternalStorageKb != 500L) {
                throw new TargetSetupError("Deprecated option min-external-store-space conflicts with option min-external-storage-kb", device.getDeviceDescriptor());
            }
            this.mMinExternalStorageKb = this.mDeprecatedMinExternalStoreSpace;
        }
        if (!this.mDeprecatedSetAudioSilent) {
            if (!this.mDisableAudio) {
                throw new TargetSetupError("Deprecated option audio-silent conflicts with option disable-audio", device.getDeviceDescriptor());
            }
            this.mDisableAudio = this.mDeprecatedSetAudioSilent;
        }
        if (!this.mDeprecatedSetProps.isEmpty()) {
            if (!this.mSetProps.isEmpty()) {
                throw new TargetSetupError("Deprecated option setprop conflicts with option set-property ", device.getDeviceDescriptor());
            }
            for (String prop : this.mDeprecatedSetProps) {
                String[] parts = prop.split("=", 2);
                String key = parts[0].trim();
                String value = parts.length == 2 ? parts[1].trim() : "";
                this.mSetProps.put(key, value);
            }
        }
    }

    public void processOptions(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        DeviceSetup.setSettingForBinaryState(this.mData, this.mGlobalSettings, "mobile_data", "1", "0");
        DeviceSetup.setCommandForBinaryState(this.mData, this.mRunCommandAfterSettings, "svc data enable", "svc data disable");
        DeviceSetup.setSettingForBinaryState(this.mCell, this.mGlobalSettings, "cell_on", "1", "0");
        DeviceSetup.setSettingForBinaryState(this.mCellAutoSetting, this.mGlobalSettings, "clockwork_cell_auto_setting", "1", "0");
        DeviceSetup.setSettingForBinaryState(this.mWifi, this.mGlobalSettings, "wifi_on", "1", "0");
        DeviceSetup.setCommandForBinaryState(this.mWifi, this.mRunCommandAfterSettings, "svc wifi enable", "svc wifi disable");
        DeviceSetup.setSettingForBinaryState(this.mWifiWatchdog, this.mGlobalSettings, "wifi_watchdog", "1", "0");
        DeviceSetup.setSettingForBinaryState(this.mDisableCwWifiMediator, this.mGlobalSettings, "cw_disable_wifimediator", "1", "0");
        DeviceSetup.setSettingForBinaryState(this.mWifiScanAlwaysEnabled, this.mGlobalSettings, "wifi_scan_always_enabled", "1", "0");
        DeviceSetup.setCommandForBinaryState(this.mEthernet, this.mRunCommandAfterSettings, "ifconfig eth0 up", "ifconfig eth0 down");
        DeviceSetup.setCommandForBinaryState(this.mBluetooth, this.mRunCommandAfterSettings, "cmd bluetooth_manager enable && cmd bluetooth_manager wait-for-state:STATE_ON", "cmd bluetooth_manager disable && cmd bluetooth_manager wait-for-state:STATE_OFF");
        DeviceSetup.setCommandForBinaryState(this.mNfc, this.mRunCommandAfterSettings, "svc nfc enable", "svc nfc disable");
        if (this.mScreenBrightness != null && BinaryState.ON.equals((Object)this.mScreenAdaptiveBrightness)) {
            throw new TargetSetupError("Option screen-brightness cannot be set when screen-adaptive-brightness is set to ON", device.getDeviceDescriptor());
        }
        DeviceSetup.setSettingForBinaryState(this.mScreenAdaptiveBrightness, this.mSystemSettings, "screen_brightness_mode", "1", "0");
        if (this.mScreenBrightness != null) {
            this.mSystemSettings.put("screen_brightness", Integer.toString(this.mScreenBrightness));
        }
        if (this.mScreenTimeoutSecs != null) {
            this.mSystemSettings.put("screen_off_timeout", Long.toString(this.mScreenTimeoutSecs * 1000L));
        }
        DeviceSetup.setSettingForBinaryState(this.mScreenAmbientMode, this.mSecureSettings, "doze_enabled", "1", "0");
        DeviceSetup.setSettingForBinaryState(this.mWakeGesture, this.mSecureSettings, "wake_gesture_enabled", "1", "0");
        DeviceSetup.setSettingForBinaryState(this.mScreenSaver, this.mSecureSettings, "screensaver_enabled", "1", "0");
        DeviceSetup.setSettingForBinaryState(this.mNotificationLed, this.mSystemSettings, "notification_light_pulse", "1", "0");
        DeviceSetup.setSettingForBinaryState(this.mInstallNonMarketApps, this.mSecureSettings, "install_non_market_apps", "1", "0");
        if (this.mTriggerMediaMounted) {
            this.mRunCommandAfterSettings.add("am broadcast -a android.intent.action.MEDIA_MOUNTED -d file://${EXTERNAL_STORAGE} --receiver-include-background");
        }
        DeviceSetup.setSettingForBinaryState(this.mLocationGps, this.mSecureSettings, "location_providers_allowed", "+gps", "-gps");
        DeviceSetup.setSettingForBinaryState(this.mLocationNetwork, this.mSecureSettings, "location_providers_allowed", "+network", "-network");
        DeviceSetup.setSettingForBinaryState(this.mAutoRotate, this.mSystemSettings, "accelerometer_rotation", "1", "0");
        if (device.getApiLevel() < 22) {
            DeviceSetup.setCommandForBinaryState(this.mBatterySaver, this.mRunCommandBeforeSettings, "dumpsys battery set usb 0", null);
        } else {
            DeviceSetup.setCommandForBinaryState(this.mBatterySaver, this.mRunCommandBeforeSettings, "dumpsys battery unplug", null);
        }
        DeviceSetup.setSettingForBinaryState(this.mBatterySaver, this.mGlobalSettings, "low_power", "1", "0");
        if (this.mBatterySaverTrigger != null) {
            this.mGlobalSettings.put("low_power_trigger_level", Integer.toString(this.mBatterySaverTrigger));
        }
        if (this.mEnableFullBatteryStatsHistory) {
            this.mRunCommandAfterSettings.add("dumpsys batterystats --enable full-history");
        }
        if (this.mDisableDoze) {
            this.mRunCommandAfterSettings.add("dumpsys deviceidle disable");
        }
        DeviceSetup.setSettingForBinaryState(this.mAutoUpdateTime, this.mGlobalSettings, "auto_time", "1", "0");
        DeviceSetup.setSettingForBinaryState(this.mAutoUpdateTimezone, this.mGlobalSettings, "auto_timezone", "1", "0");
        if (BinaryState.ON.equals((Object)this.mSyncTimezoneWithHost)) {
            if (this.mTimezone != null) {
                throw new TargetSetupError("Option set-timezone cannot be set when sync-timezone-with-host is set to ON", device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
            }
            this.mTimezone = TimeZone.getDefault().getID();
        }
        DeviceSetup.setSettingForBinaryState(this.mHideErrorDialogs, this.mGlobalSettings, "hide_error_dialogs", "1", "0");
        if (this.mTimezone != null) {
            LogUtil.CLog.i("The actual timezone we set here is  %s", this.mTimezone);
            this.mSetProps.put("persist.sys.timezone", this.mTimezone);
        }
        if (this.mDisableDialing) {
            this.mSetProps.put("ro.telephony.disable-call", "true");
        }
        if (this.mDefaultSimData != null) {
            this.mGlobalSettings.put("multi_sim_data_call", Integer.toString(this.mDefaultSimData));
        }
        if (this.mDefaultSimVoice != null) {
            this.mGlobalSettings.put("multi_sim_voice_call", Integer.toString(this.mDefaultSimVoice));
        }
        if (this.mDefaultSimSms != null) {
            this.mGlobalSettings.put("multi_sim_sms", Integer.toString(this.mDefaultSimSms));
        }
        if (this.mDisableAudio) {
            this.mSetProps.put("ro.audio.silent", "1");
        }
        if (this.mSetTestHarness) {
            this.mSetProps.put("ro.monkey", "1");
            this.mSetProps.put("ro.test_harness", "1");
            this.mSetProps.put("persist.sys.test_harness", "1");
        }
        if (this.mDisableDalvikVerifier) {
            this.mSetProps.put("dalvik.vm.dexopt-flags", "v=n");
        }
        if (this.mDisableDeviceConfigSync) {
            this.mRunCommandBeforeSettings.add("device_config set_sync_disabled_for_tests persistent");
        }
    }

    private void changeSystemProps(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        if (this.mForceSkipSystemProps) {
            LogUtil.CLog.d("Skipping system props due to force-skip-system-props");
            return;
        }
        if (this.mSetProps.size() > 0 && !device.getOptions().isEnableAdbRoot()) {
            throw new TargetSetupError(String.format("Cannot set system props %s on %s without adb root. Setting 'force-skip-system-props' or 'enable-root' to avoid error", this.mSetProps.toString(), device.getSerialNumber()), device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        boolean needsReboot = false;
        HashMap<String, String> nonpersistentProps = new HashMap<String, String>();
        for (Map.Entry<String, String> prop : this.mSetProps.entrySet()) {
            boolean isPersistProperty;
            boolean bl = isPersistProperty = prop.getKey().startsWith(PERSIST_PREFIX) || prop.getKey().equals(MEMTAG_BOOTCTL);
            if (isPersistProperty || this.mOptimizeNonPersistentSetup) {
                device.setProperty(prop.getKey(), prop.getValue());
            }
            if (!isPersistProperty) {
                nonpersistentProps.put(prop.getKey(), prop.getValue());
            }
            if (!PROPERTIES_NEEDING_REBOOT.contains(prop.getKey())) continue;
            needsReboot = true;
        }
        boolean shouldSetProps = true;
        if (!this.mOptimizeNonPersistentSetup && this.mOptimizedPropertySetting && !nonpersistentProps.isEmpty()) {
            boolean allPropsAlreadySet = true;
            for (Map.Entry entry : nonpersistentProps.entrySet()) {
                if (((String)entry.getValue()).equals(device.getProperty((String)entry.getKey()))) continue;
                allPropsAlreadySet = false;
                break;
            }
            if (allPropsAlreadySet) {
                shouldSetProps = false;
                LogUtil.CLog.i("All properties appear to already be set to desired values, skipping set stage");
            }
        }
        if (!nonpersistentProps.isEmpty() && shouldSetProps) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : nonpersistentProps.entrySet()) {
                sb.append(String.format("%s=%s\n", entry.getKey(), entry.getValue()));
            }
            if (this.mRestoreProperties) {
                this.mPreviousProperties = device.pullFile("/data/local.prop");
            }
            LogUtil.CLog.d("Pushing the following properties to /data/local.prop:\n%s", sb.toString());
            boolean result = device.pushString(sb.toString(), "/data/local.prop");
            if (!result) {
                throw new TargetSetupError(String.format("Failed to push /data/local.prop to %s", device.getSerialNumber()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.FAIL_PUSH_FILE);
            }
            device.executeShellCommand("chmod 644 /data/local.prop");
            if (this.mDisableRamdump) {
                device.rebootIntoBootloader();
                LogUtil.CLog.i("Disabling ramdump.");
                CommandResult commandResult = device.executeFastbootCommand("oem", "ramdump", "disable");
                if (!CommandStatus.SUCCESS.equals((Object)commandResult.getStatus())) {
                    LogUtil.CLog.w("Failed to run ramdump disable: status: %s\nstdout: %s\nstderr: %s", new Object[]{commandResult.getStatus(), commandResult.getStdout(), commandResult.getStderr()});
                }
            }
            if (!this.mOptimizeNonPersistentSetup) {
                needsReboot = true;
            }
        }
        if (needsReboot) {
            LogUtil.CLog.i("Rebooting %s due to system property change", device.getSerialNumber());
            device.reboot();
        }
        String deviceType = device.getClass().getTypeName();
        for (Map.Entry<String, String> entry : this.mSetProps.entrySet()) {
            String entry2;
            String expected = entry.getValue();
            String actual = device.getProperty(entry.getKey());
            if (expected != null && !expected.equals(actual) || expected == null && actual != null) {
                entry2 = String.format("%s-%s(%s:%s)", deviceType, entry.getKey(), expected, actual);
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.NONPERSISTENT_DEVICE_PROPERTIES, entry2);
                continue;
            }
            entry2 = String.format("%s-%s(%s)", deviceType, entry.getKey(), actual);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.PERSISTENT_DEVICE_PROPERTIES, entry2);
        }
    }

    private void handleScreenAlwaysOnSetting(ITestDevice device) throws DeviceNotAvailableException {
        String cmd = "svc power stayon %s";
        switch (this.mScreenAlwaysOn) {
            case ON: {
                LogUtil.CLog.d("Setting screen always on to true");
                device.executeShellCommand(String.format(cmd, "true"));
                device.executeShellCommand("input keyevent 82");
                if (!(device instanceof TestDevice) || device.hasFeature("android.hardware.type.watch")) break;
                device.executeShellCommand("input keyevent 3");
                break;
            }
            case OFF: {
                LogUtil.CLog.d("Setting screen always on to false");
                device.executeShellCommand(String.format(cmd, "false"));
                break;
            }
        }
    }

    public void changeSettings(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        String previousSetting;
        if (this.mForceSkipSettings) {
            LogUtil.CLog.d("Skipping settings due to force-skip-setttings");
            return;
        }
        if (this.mSystemSettings.isEmpty() && this.mSecureSettings.isEmpty() && this.mGlobalSettings.isEmpty() && BinaryState.IGNORE.equals((Object)this.mAirplaneMode)) {
            LogUtil.CLog.d("No settings to change");
            return;
        }
        if (device.getApiLevel() < 22) {
            throw new TargetSetupError(String.format("Changing setting not supported on %s, must be API 22+", device.getSerialNumber()), device.getDeviceDescriptor());
        }
        String command = "am broadcast -a android.intent.action.AIRPLANE_MODE --ez state %s";
        switch (this.mAirplaneMode) {
            case ON: {
                LogUtil.CLog.d("Changing global setting airplane_mode_on to 1");
                device.setSetting("global", "airplane_mode_on", "1");
                if (this.mForceSkipRunCommands) break;
                device.executeShellCommand(String.format(command, "true"));
                break;
            }
            case OFF: {
                LogUtil.CLog.d("Changing global setting airplane_mode_on to 0");
                device.setSetting("global", "airplane_mode_on", "0");
                if (this.mForceSkipRunCommands) break;
                device.executeShellCommand(String.format(command, "false"));
                break;
            }
        }
        for (String key : this.mSystemSettings.keySet()) {
            for (String value : this.mSystemSettings.get(key)) {
                if (this.mRestoreSettings) {
                    previousSetting = device.getSetting("system", key);
                    this.mPreviousSystemSettings.put(key, previousSetting);
                }
                LogUtil.CLog.d("Changing system setting %s to %s", key, value);
                device.setSetting("system", key, value);
            }
        }
        for (String key : this.mSecureSettings.keySet()) {
            for (String value : this.mSecureSettings.get(key)) {
                if (this.mRestoreSettings) {
                    previousSetting = device.getSetting("secure", key);
                    this.mPreviousSecureSettings.put(key, previousSetting);
                }
                LogUtil.CLog.d("Changing secure setting %s to %s", key, value);
                device.setSetting("secure", key, value);
            }
        }
        for (String key : this.mGlobalSettings.keySet()) {
            for (String value : this.mGlobalSettings.get(key)) {
                if (this.mRestoreSettings) {
                    previousSetting = device.getSetting("global", key);
                    this.mPreviousGlobalSettings.put(key, previousSetting);
                }
                LogUtil.CLog.d("Changing global setting %s to %s", key, value);
                device.setSetting("global", key, value);
            }
        }
    }

    private void runCommands(ITestDevice device, List<String> commands) throws DeviceNotAvailableException, TargetSetupError {
        if (this.mForceSkipRunCommands) {
            LogUtil.CLog.d("Skipping run commands due to force-skip-run-commands");
            return;
        }
        for (String command : commands) {
            device.executeShellCommand(command);
        }
    }

    private void connectWifi(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        if (this.mForceSkipRunCommands) {
            LogUtil.CLog.d("Skipping connect wifi due to force-skip-run-commands");
            return;
        }
        if ((this.mWifiSsid == null || this.mWifiSsid.isEmpty()) && this.mWifiSsidToPsk.isEmpty()) {
            return;
        }
        if (this.mSkipWifi) {
            LogUtil.CLog.d("Skipping wifi connection due to skip-wifi-connection");
            return;
        }
        if (this.mWifiSsid != null) {
            this.mWifiSsidToPsk.put(this.mWifiSsid, this.mWifiPsk);
        }
        if (device.connectToWifiNetwork(this.mWifiSsidToPsk)) {
            return;
        }
        if (this.mWifiSsid != null || !this.mWifiSsidToPsk.isEmpty()) {
            String network = this.mWifiSsid == null ? this.mWifiSsidToPsk.toString() : this.mWifiSsid;
            InfraErrorIdentifier errorIdentifier = InfraErrorIdentifier.WIFI_FAILED_CONNECT;
            if (device instanceof RemoteAndroidVirtualDevice || device instanceof NestedRemoteDevice || device instanceof LocalAndroidVirtualDevice) {
                errorIdentifier = InfraErrorIdentifier.VIRTUAL_WIFI_FAILED_CONNECT;
            }
            throw new TargetSetupError(String.format("Failed to connect to wifi network %s on %s", network, device.getSerialNumber()), device.getDeviceDescriptor(), (ErrorIdentifier)errorIdentifier);
        }
    }

    private void syncTestData(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        boolean result;
        if (this.mLocalDataFile == null) {
            return;
        }
        if (!this.mLocalDataFile.exists() || !this.mLocalDataFile.isDirectory()) {
            throw new TargetSetupError(String.format("local-data-path %s is not a directory", this.mLocalDataFile.getAbsolutePath()), device.getDeviceDescriptor());
        }
        String fullRemotePath = device.getIDevice().getMountPoint("EXTERNAL_STORAGE");
        if (fullRemotePath == null) {
            throw new TargetSetupError(String.format("failed to get external storage path on device %s", device.getSerialNumber()), device.getDeviceDescriptor());
        }
        if (this.mRemoteDataPath != null) {
            fullRemotePath = String.format("%s/%s", fullRemotePath, this.mRemoteDataPath);
        }
        if (!(result = device.syncFiles(this.mLocalDataFile, fullRemotePath))) {
            throw new TargetSetupError(String.format("failed to sync test data from local-data-path %s to %s on device %s", this.mLocalDataFile.getAbsolutePath(), fullRemotePath, device.getSerialNumber()), device.getDeviceDescriptor());
        }
    }

    private void checkExternalStoreSpace(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mMinExternalStorageKb <= 0L) {
            return;
        }
        if (!(device instanceof TestDevice)) {
            return;
        }
        device.waitForDeviceAvailable();
        long freeSpace = device.getExternalStoreFreeSpace();
        if (freeSpace < this.mMinExternalStorageKb) {
            throw new DeviceNotAvailableException(String.format("External store free space %dK is less than required %dK for device %s", freeSpace, this.mMinExternalStorageKb, device.getSerialNumber()), device.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
    }

    private void dismissSetupWiward(ITestDevice device) throws DeviceNotAvailableException {
        device.executeShellCommand("am start -a com.android.setupwizard.FOUR_CORNER_EXIT");
        device.executeShellCommand("am start -a com.android.setupwizard.EXIT");
    }

    public static void setSettingForBinaryState(BinaryState state, MultiMap<String, String> settingsMap, String setting, String onValue, String offValue) {
        switch (state) {
            case ON: {
                settingsMap.put(setting, onValue);
                break;
            }
            case OFF: {
                settingsMap.put(setting, offValue);
                break;
            }
        }
    }

    public static void setCommandForBinaryState(BinaryState state, List<String> commands, String onCommand, String offCommand) {
        switch (state) {
            case ON: {
                if (onCommand == null) break;
                commands.add(onCommand);
                break;
            }
            case OFF: {
                if (offCommand == null) break;
                commands.add(offCommand);
                break;
            }
        }
    }

    protected void setForceSkipSystemProps(boolean force) {
        this.mForceSkipSystemProps = force;
    }

    public boolean isForceSkipSystemProps() {
        return this.mForceSkipSystemProps;
    }

    protected void setAirplaneMode(BinaryState airplaneMode) {
        this.mAirplaneMode = airplaneMode;
    }

    @VisibleForTesting
    protected void setData(BinaryState data) {
        this.mData = data;
    }

    @VisibleForTesting
    protected void setCell(BinaryState cell) {
        this.mCell = cell;
    }

    @VisibleForTesting
    protected void setCellAutoSetting(BinaryState cellAutoSetting) {
        this.mCellAutoSetting = cellAutoSetting;
    }

    protected void setWifi(BinaryState wifi) {
        this.mWifi = wifi;
    }

    protected void setWifiNetwork(String wifiNetwork) {
        this.mWifiSsid = wifiNetwork;
    }

    @VisibleForTesting
    protected void setWifiPsk(String wifiPsk) {
        this.mWifiPsk = wifiPsk;
    }

    @VisibleForTesting
    protected void setWifiSsidToPsk(Map<String, String> wifiSssidToPsk) {
        this.mWifiSsidToPsk = wifiSssidToPsk;
    }

    protected void setWifiWatchdog(BinaryState wifiWatchdog) {
        this.mWifiWatchdog = wifiWatchdog;
    }

    @VisibleForTesting
    protected void setDisableCwWifiMediator(BinaryState disableCwWifiMediator) {
        this.mDisableCwWifiMediator = disableCwWifiMediator;
    }

    protected void setWifiScanAlwaysEnabled(BinaryState wifiScanAlwaysEnabled) {
        this.mWifiScanAlwaysEnabled = wifiScanAlwaysEnabled;
    }

    protected void setEthernet(BinaryState ethernet) {
        this.mEthernet = ethernet;
    }

    protected void setBluetooth(BinaryState bluetooth) {
        this.mBluetooth = bluetooth;
    }

    protected void setNfc(BinaryState nfc) {
        this.mNfc = nfc;
    }

    protected void setScreenAdaptiveBrightness(BinaryState screenAdaptiveBrightness) {
        this.mScreenAdaptiveBrightness = screenAdaptiveBrightness;
    }

    protected void setScreenBrightness(Integer screenBrightness) {
        this.mScreenBrightness = screenBrightness;
    }

    protected void setScreenAlwaysOn(BinaryState screenAlwaysOn) {
        this.mScreenAlwaysOn = screenAlwaysOn;
    }

    protected void setScreenTimeoutSecs(Long screenTimeoutSecs) {
        this.mScreenTimeoutSecs = screenTimeoutSecs;
    }

    protected void setScreenAmbientMode(BinaryState screenAmbientMode) {
        this.mScreenAmbientMode = screenAmbientMode;
    }

    protected void setWakeGesture(BinaryState wakeGesture) {
        this.mWakeGesture = wakeGesture;
    }

    protected void setScreenSaver(BinaryState screenSaver) {
        this.mScreenSaver = screenSaver;
    }

    protected void setNotificationLed(BinaryState notificationLed) {
        this.mNotificationLed = notificationLed;
    }

    protected void setInstallNonMarketApps(BinaryState installNonMarketApps) {
        this.mInstallNonMarketApps = installNonMarketApps;
    }

    protected void setTriggerMediaMounted(boolean triggerMediaMounted) {
        this.mTriggerMediaMounted = triggerMediaMounted;
    }

    protected void setLocationGps(BinaryState locationGps) {
        this.mLocationGps = locationGps;
    }

    protected void setLocationNetwork(BinaryState locationNetwork) {
        this.mLocationNetwork = locationNetwork;
    }

    protected void setAutoRotate(BinaryState autoRotate) {
        this.mAutoRotate = autoRotate;
    }

    protected void setBatterySaver(BinaryState batterySaver) {
        this.mBatterySaver = batterySaver;
    }

    protected void setBatterySaverTrigger(Integer batterySaverTrigger) {
        this.mBatterySaverTrigger = batterySaverTrigger;
    }

    protected void setEnableFullBatteryStatsHistory(boolean enableFullBatteryStatsHistory) {
        this.mEnableFullBatteryStatsHistory = enableFullBatteryStatsHistory;
    }

    protected void setDisableDoze(boolean disableDoze) {
        this.mDisableDoze = disableDoze;
    }

    protected void setAutoUpdateTime(BinaryState autoUpdateTime) {
        this.mAutoUpdateTime = autoUpdateTime;
    }

    protected void setAutoUpdateTimezone(BinaryState autoUpdateTimezone) {
        this.mAutoUpdateTimezone = autoUpdateTimezone;
    }

    protected void setTimezone(String timezone) {
        this.mTimezone = timezone;
    }

    protected void setDisableDialing(boolean disableDialing) {
        this.mDisableDialing = disableDialing;
    }

    protected void setDefaultSimData(Integer defaultSimData) {
        this.mDefaultSimData = defaultSimData;
    }

    protected void setDefaultSimVoice(Integer defaultSimVoice) {
        this.mDefaultSimVoice = defaultSimVoice;
    }

    protected void setDefaultSimSms(Integer defaultSimSms) {
        this.mDefaultSimSms = defaultSimSms;
    }

    protected void setDisableAudio(boolean disable) {
        this.mDisableAudio = disable;
    }

    protected void setTestHarness(boolean setTestHarness) {
        this.mSetTestHarness = setTestHarness;
    }

    protected void setDisableDalvikVerifier(boolean disableDalvikVerifier) {
        this.mDisableDalvikVerifier = disableDalvikVerifier;
    }

    protected void setLocalDataPath(File path) {
        this.mLocalDataFile = path;
    }

    protected void setMinExternalStorageKb(long storageKb) {
        this.mMinExternalStorageKb = storageKb;
    }

    protected void setProperty(String key, String value) {
        this.mSetProps.put(key, value);
    }

    public void setGlobalSetting(String key, String value) {
        this.mGlobalSettings.put(key, value);
    }

    public void setSecureSetting(String key, String value) {
        this.mSecureSettings.put(key, value);
    }

    public void setSystemSetting(String key, String value) {
        this.mSystemSettings.put(key, value);
    }

    protected void setRestoreProperties(boolean restoreProperties) {
        this.mRestoreProperties = restoreProperties;
    }

    protected void setRestoreSettings(boolean restoreSettings) {
        this.mRestoreSettings = restoreSettings;
    }

    @Deprecated
    protected void setDeprecatedMinExternalStoreSpace(long storeSpace) {
        this.mDeprecatedMinExternalStoreSpace = storeSpace;
    }

    @Deprecated
    protected void setDeprecatedAudioSilent(boolean silent) {
        this.mDeprecatedSetAudioSilent = silent;
    }

    @Deprecated
    protected void setDeprecatedSetProp(String prop) {
        this.mDeprecatedSetProps.add(prop);
    }

    @Override
    public Set<ExternalDependency> getDependencies() {
        LinkedHashSet<ExternalDependency> externalDependencies = new LinkedHashSet<ExternalDependency>();
        if (BinaryState.ON.equals((Object)this.mData)) {
            externalDependencies.add(new TelephonyDependency());
        }
        if (!(this.mSkipWifi || Strings.isNullOrEmpty(this.mWifiSsid) && this.mWifiSsidToPsk.isEmpty())) {
            externalDependencies.add(new NetworkDependency());
        }
        if (BinaryState.ON.equals((Object)this.mEthernet)) {
            externalDependencies.add(new EthernetDependency());
        }
        if (BinaryState.ON.equals((Object)this.mBluetooth)) {
            externalDependencies.add(new BluetoothDependency());
        }
        if (BinaryState.ON.equals((Object)this.mLocationNetwork)) {
            externalDependencies.add(new NetworkDependency());
        }
        return externalDependencies;
    }
}

