/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;

@OptionClass(alias="fill-storage")
public class DeviceStorageFiller
extends BaseTargetPreparer {
    @Option(name="partition", description="Partition to check storage")
    private String mPartition = "/data";
    @Option(name="file-name", description="Name of file to use to fill up storage, relative to partition")
    private String mFileName = "bigfile";
    @Option(name="free-bytes", description="Number of bytes that should be left free on the device.")
    private long mFreeBytesRequested = 0x1900000000L;

    private String getFullFileName() {
        return String.format("%s/%s", this.mPartition, this.mFileName);
    }

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        long freeSpace = device.getPartitionFreeSpace(this.mPartition) * 1024L;
        if (freeSpace > this.mFreeBytesRequested) {
            String fileName = this.getFullFileName();
            long bytesToWrite = freeSpace - this.mFreeBytesRequested;
            device.executeShellCommand(String.format("fallocate -l %d %s", bytesToWrite, fileName));
            LogUtil.CLog.i("Wrote %d bytes to %s", bytesToWrite, fileName);
        } else {
            LogUtil.CLog.i("Not enough free space (%d bytes requested free, %d bytes actually free)", this.mFreeBytesRequested, freeSpace);
        }
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        String fileName = this.getFullFileName();
        ITestDevice device = testInfo.getDevice();
        device.executeShellCommand(String.format("rm -f %s", fileName));
    }
}

