/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import java.io.File;

@OptionClass(alias="write-file")
public class DeviceStringPusher
extends BaseTargetPreparer {
    @Option(name="file-path", description="Path of file to write")
    private String mFileName;
    @Option(name="file-content", description="Contents to write to file")
    private String mFileContent;
    private File mOldContents;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        if (device.doesFileExist(this.mFileName)) {
            this.mOldContents = device.pullFile(this.mFileName);
        }
        if (!device.pushString(this.mFileContent, this.mFileName)) {
            throw new TargetSetupError("Failed to push string to file", device.getDeviceDescriptor());
        }
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        if (this.mOldContents == null) {
            device.deleteFile(this.mFileName);
        } else {
            device.pushFile(this.mOldContents, this.mFileName);
        }
    }
}

