/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.DeviceBuildInfoBootStrapper;
import com.android.tradefed.targetprep.DeviceFailedToBootError;
import com.android.tradefed.targetprep.TargetSetupError;
import java.io.File;
import java.util.concurrent.TimeUnit;

public abstract class DeviceUpdateTargetPreparer
extends DeviceBuildInfoBootStrapper {
    @Option(name="device-boot-time", description="max time to wait for device to boot.", isTimeVal=true)
    private long mDeviceBootTime = 300000L;
    @Option(name="bootstrap-build-info", description="whether build info should bebootstrapped based on device attributes after flashing")
    private boolean mBootStrapBuildInfo = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        boolean rootEnabled;
        ITestDevice device = testInfo.getDevice();
        File deviceUpdateImage = this.getDeviceUpdateImage();
        if (deviceUpdateImage == null) {
            LogUtil.CLog.i("No device image zip file provided, assuming no-op; skipping ...");
            return;
        }
        if (!deviceUpdateImage.exists()) {
            throw new TargetSetupError("Device image file not found: " + deviceUpdateImage.getAbsolutePath(), device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
        }
        this.preUpdateActions(deviceUpdateImage, device);
        long start = System.currentTimeMillis();
        IHostOptions hostOptions = GlobalConfiguration.getInstance().getHostOptions();
        hostOptions.takePermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
        LogUtil.CLog.v("Flashing permit obtained after %ds", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
        try {
            this.performDeviceUpdate(deviceUpdateImage, device);
        }
        catch (Throwable throwable) {
            LogUtil.CLog.v("Flashing finished after %ds", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
            hostOptions.returnPermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
            throw throwable;
        }
        LogUtil.CLog.v("Flashing finished after %ds", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
        hostOptions.returnPermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
        this.postUpdateActions(deviceUpdateImage, device);
        LogUtil.CLog.i("Flashing completed successfully on %s, waiting for device to boot up.", device.getSerialNumber());
        device.waitForDeviceOnline();
        if (device.getOptions().isEnableAdbRoot() && (rootEnabled = device.enableAdbRoot())) {
            device.setDate(null);
        }
        try {
            device.setRecoveryMode(ITestDevice.RecoveryMode.AVAILABLE);
            device.waitForDeviceAvailable(this.mDeviceBootTime);
        }
        catch (DeviceUnresponsiveException e) {
            throw new DeviceFailedToBootError(String.format("Device %s did not become available after flashing %s", device.getSerialNumber(), deviceUpdateImage.getAbsolutePath()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.ERROR_AFTER_FLASHING);
        }
        LogUtil.CLog.i("Device update completed on %s", device.getDeviceDescriptor());
        if (this.mBootStrapBuildInfo) {
            super.setUp(testInfo);
        }
    }

    protected abstract File getDeviceUpdateImage();

    protected abstract void preUpdateActions(File var1, ITestDevice var2) throws DeviceNotAvailableException, TargetSetupError;

    protected abstract void performDeviceUpdate(File var1, ITestDevice var2) throws DeviceNotAvailableException, TargetSetupError;

    protected abstract void postUpdateActions(File var1, ITestDevice var2) throws DeviceNotAvailableException, TargetSetupError;
}

