/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ILabPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.SparseImageUtil;
import com.android.tradefed.util.StreamUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

@OptionClass(alias="dynamic-system-update")
public class DynamicSystemPreparer
extends BaseTargetPreparer
implements ILabPreparer {
    static final int DSU_MAX_WAIT_SEC = 600;
    private static final int ANDROID_API_R = 30;
    private static final String SYSTEM_IMAGE_NAME = "system.img";
    private static final String SYSTEM_EXT_IMAGE_NAME = "system_ext.img";
    private static final String PRODUCT_IMAGE_NAME = "product.img";
    private static final String[] IMAGE_NAME_PREFIXES = new String[]{"", "IMAGES"};
    private static final long COPY_STREAM_SIZE = 0x1000000L;
    private static final String DEST_PATH = "/sdcard/system.raw.gz";
    private static final String DEST_ZIP_PATH = "/sdcard/system.zip";
    private static final String DSU_COMMAND_TEMPLATE_Q = "am start-activity -n com.android.dynsystem/com.android.dynsystem.VerificationActivity -a android.os.image.action.START_INSTALL -d file://%s --el KEY_USERDATA_SIZE %d --el KEY_SYSTEM_SIZE %d --ez KEY_ENABLE_WHEN_COMPLETED true";
    private static final String DSU_COMMAND_TEMPLATE_R = "am start-activity -n com.android.dynsystem/com.android.dynsystem.VerificationActivity -a android.os.image.action.START_INSTALL -d file://%s --el KEY_USERDATA_SIZE %d --ez KEY_ENABLE_WHEN_COMPLETED true";
    @Option(name="system-image-zip-name", description="The name of the zip file containing system.img.")
    private String mSystemImageZipName = "system-img.zip";
    @Option(name="user-data-size-in-gb", description="Number of GB to be allocated for DSU user-data.")
    private long mUserDataSizeInGb = 16L;
    @Option(name="image-conversion-timeout", description="The timeout for decompressing, unsparsing, and compressing the images.", isTimeVal=true)
    private long mImageConversionTimeoutMs = 1200000L;
    @Option(name="compress-images", description="Whether to compress the images pushed to the device.")
    private boolean mCompressImages = false;

    private boolean isDSURunning(ITestDevice device) throws DeviceNotAvailableException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        device.executeShellCommand("gsi_tool status", receiver);
        return receiver.getOutput().contains("running");
    }

    private SparseImageUtil.SparseInputStream getUnsparsedImageStream(File imageZipFile, String imageName) throws IOException {
        InputStream is = null;
        try {
            long imageSize = 0L;
            if (imageZipFile.isDirectory()) {
                File localImageFile = null;
                for (String prefix : IMAGE_NAME_PREFIXES) {
                    localImageFile = imageZipFile.toPath().resolve(prefix).resolve(imageName).toFile();
                    if (localImageFile.isFile()) break;
                    localImageFile = null;
                }
                if (localImageFile == null) {
                    return null;
                }
                imageSize = localImageFile.length();
                is = new FileInputStream(localImageFile);
            } else {
                final ZipFile zipFile = new ZipFile(imageZipFile);
                try {
                    String prefix;
                    ZipEntry entry = null;
                    String[] stringArray = IMAGE_NAME_PREFIXES;
                    int n = stringArray.length;
                    for (int i = 0; i < n && (entry = zipFile.getEntry(((prefix = stringArray[i]).isEmpty() ? "" : prefix + "/") + imageName)) == null; ++i) {
                    }
                    if (entry == null) {
                        StreamUtil.close(zipFile);
                        return null;
                    }
                    imageSize = entry.getSize();
                    is = new FilterInputStream(zipFile.getInputStream(entry)){

                        @Override
                        public void close() throws IOException {
                            StreamUtil.close(this.in);
                            StreamUtil.close(zipFile);
                        }
                    };
                }
                catch (IOException | RuntimeException e) {
                    StreamUtil.close(zipFile);
                    throw e;
                }
            }
            return new SparseImageUtil.SparseInputStream(new BufferedInputStream(is), imageSize);
        }
        catch (IOException | RuntimeException e) {
            StreamUtil.close(is);
            throw e;
        }
    }

    @VisibleForTesting
    boolean hasTimedOut(long deadline) {
        return System.currentTimeMillis() >= deadline;
    }

    private void copyStreamsWithDeadline(InputStream inStream, OutputStream outStream, long size, long deadline) throws IOException {
        long copySize;
        for (long totalCopiedSize = 0L; totalCopiedSize < size; totalCopiedSize += copySize) {
            if (this.hasTimedOut(deadline)) {
                throw new IOException("Cannot copy streams within timeout.");
            }
            copySize = Math.min(0x1000000L, size - totalCopiedSize);
            StreamUtil.copyStreams(inStream, outStream, 0L, copySize);
        }
    }

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        long imageConversionDeadline = System.currentTimeMillis() + this.mImageConversionTimeoutMs;
        File systemImageZipFile = buildInfo.getFile(this.mSystemImageZipName);
        if (systemImageZipFile == null) {
            throw new BuildError("Cannot find " + this.mSystemImageZipName + " in build info.", device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
        }
        ArrayList<File> tempFiles = new ArrayList<File>();
        try {
            String command;
            String dsuPushDest;
            File dsuPushSrc;
            block60: {
                long userdataSize = this.mUserDataSizeInGb << 30;
                try (SparseImageUtil.SparseInputStream systemImageStream = this.getUnsparsedImageStream(systemImageZipFile, SYSTEM_IMAGE_NAME);){
                    DeflaterOutputStream out;
                    BufferedOutputStream boStream;
                    if (systemImageStream == null) {
                        throw new BuildError(String.format("Cannot find %s in %s.", SYSTEM_IMAGE_NAME, this.mSystemImageZipName), device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
                    }
                    if (device.getApiLevel() < 30) {
                        File systemImageGZ = FileUtil.createTempFile("system", ".raw.gz");
                        tempFiles.add(systemImageGZ);
                        try (FileOutputStream foStream = new FileOutputStream(systemImageGZ);){
                            boStream = new BufferedOutputStream(foStream);
                            try {
                                out = new GZIPOutputStream(boStream);
                                try {
                                    this.copyStreamsWithDeadline(systemImageStream, out, systemImageStream.size(), imageConversionDeadline);
                                }
                                finally {
                                    out.close();
                                }
                            }
                            finally {
                                boStream.close();
                            }
                        }
                        dsuPushSrc = systemImageGZ;
                        dsuPushDest = DEST_PATH;
                        long systemImageSize = systemImageStream.size();
                        command = String.format(DSU_COMMAND_TEMPLATE_Q, dsuPushDest, userdataSize, systemImageSize);
                        break block60;
                    }
                    File dsuImageZip = FileUtil.createTempFile("system", ".zip");
                    tempFiles.add(dsuImageZip);
                    try (FileOutputStream foStream = new FileOutputStream(dsuImageZip);){
                        boStream = new BufferedOutputStream(foStream);
                        try {
                            out = new ZipOutputStream(boStream);
                            try {
                                if (!this.mCompressImages) {
                                    ((ZipOutputStream)out).setLevel(0);
                                }
                                ((ZipOutputStream)out).putNextEntry(new ZipEntry(SYSTEM_IMAGE_NAME));
                                this.copyStreamsWithDeadline(systemImageStream, out, systemImageStream.size(), imageConversionDeadline);
                                ((ZipOutputStream)out).closeEntry();
                                for (String imageName : Arrays.asList(SYSTEM_EXT_IMAGE_NAME, PRODUCT_IMAGE_NAME)) {
                                    SparseImageUtil.SparseInputStream sis = this.getUnsparsedImageStream(systemImageZipFile, imageName);
                                    try {
                                        if (sis == null) continue;
                                        ((ZipOutputStream)out).putNextEntry(new ZipEntry(imageName));
                                        this.copyStreamsWithDeadline(sis, out, sis.size(), imageConversionDeadline);
                                        ((ZipOutputStream)out).closeEntry();
                                    }
                                    finally {
                                        if (sis == null) continue;
                                        sis.close();
                                    }
                                }
                            }
                            finally {
                                ((ZipOutputStream)out).close();
                            }
                        }
                        finally {
                            boStream.close();
                        }
                    }
                    dsuPushSrc = dsuImageZip;
                    dsuPushDest = DEST_ZIP_PATH;
                    command = String.format(DSU_COMMAND_TEMPLATE_R, dsuPushDest, userdataSize);
                }
            }
            LogUtil.CLog.i("Pushing %s to %s", dsuPushSrc.getAbsolutePath(), dsuPushDest);
            if (!device.pushFile(dsuPushSrc, dsuPushDest, true)) {
                throw new TargetSetupError(String.format("Failed to push %s to %s", dsuPushSrc.getAbsolutePath(), dsuPushDest), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.FAIL_PUSH_FILE);
            }
            device.setProperty("persist.sys.fflag.override.settings_dynamic_system", "true");
            device.executeShellCommand(command);
            if (!device.waitForDeviceNotAvailable(600000L)) {
                throw new TargetSetupError("Timed out waiting for DSU installation to complete and reboot", device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            try {
                device.waitForDeviceAvailable();
            }
            catch (DeviceNotAvailableException e) {
                throw new TargetSetupError("Timed out booting into DSU", (Throwable)e, device.getDeviceDescriptor());
            }
            if (!this.isDSURunning(device)) {
                throw new TargetSetupError("Failed to boot into DSU", device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            CommandResult result = device.executeShellV2Command("gsi_tool enable");
            if (CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                return;
            }
            try {
                throw new TargetSetupError("fail on gsi_tool enable", device.getDeviceDescriptor());
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
                throw new TargetSetupError("Fail to create image archive.", (Throwable)e, device.getDeviceDescriptor(), InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
            }
        }
        finally {
            for (File tempFile : tempFiles) {
                FileUtil.deleteFile(tempFile);
            }
        }
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (e instanceof DeviceNotAvailableException) {
            LogUtil.CLog.e("skip tearDown on DeviceNotAvailableException");
            return;
        }
        ITestDevice device = testInfo.getDevice();
        device.executeShellV2Command("gsi_tool disable", 2L, TimeUnit.MINUTES, 0);
        device.executeShellV2Command("gsi_tool enable -s", 2L, TimeUnit.MINUTES, 0);
        device.executeShellV2Command("gsi_tool disable", 2L, TimeUnit.MINUTES, 0);
        device.reboot();
    }
}

