/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.DefaultTestsZipInstaller;
import com.android.tradefed.targetprep.FlashingMethod;
import com.android.tradefed.targetprep.FlashingResourcesParser;
import com.android.tradefed.targetprep.IDeviceFlasher;
import com.android.tradefed.targetprep.IFlashingResourcesParser;
import com.android.tradefed.targetprep.IFlashingResourcesRetriever;
import com.android.tradefed.targetprep.ITestsZipInstaller;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.FuseUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.ZipUtil2;
import com.android.tradefed.util.image.DeviceImageTracker;
import com.android.tradefed.util.image.IncrementalImageUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class FastbootDeviceFlasher
implements IDeviceFlasher {
    public static final String BASEBAND_IMAGE_NAME = "radio";
    private static final String FASTBOOT_VERSION = "fastboot_version";
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private static final int RETRY_SLEEP = 2000;
    private static final String SLOT_PROP = "ro.boot.slot_suffix";
    private static final String SLOT_VAR = "current-slot";
    private static final String SKIP_REBOOT_PARAM = "--skip-reboot";
    private static final ImmutableSet<String> DISK_SPACE_ERRORS = ImmutableSet.of("No space left on device", "failed to create temporary file");
    private long mWipeTimeout = 240000L;
    private IDeviceFlasher.UserDataFlashOption mUserDataFlashOption = IDeviceFlasher.UserDataFlashOption.FLASH;
    private IFlashingResourcesRetriever mResourceRetriever;
    private ITestsZipInstaller mTestsZipInstaller = null;
    private Collection<String> mFlashOptions = new ArrayList<String>();
    private Collection<String> mDataWipeSkipList = null;
    private boolean mForceSystemFlash;
    private CommandStatus mFbCmdStatus;
    private CommandStatus mSystemFlashStatus;
    private boolean mShouldFlashRamdisk = false;
    private String mRamdiskPartition = "root";
    private String mSystemBuildId = null;
    private String mSystemBuildFlavor = null;
    private IncrementalImageUtil mIncrementalFlashing = null;

    @VisibleForTesting
    protected FuseUtil getFuseUtil() {
        return new FuseUtil();
    }

    @Override
    public void setFlashingResourcesRetriever(IFlashingResourcesRetriever retriever) {
        this.mResourceRetriever = retriever;
    }

    protected IFlashingResourcesRetriever getFlashingResourcesRetriever() {
        return this.mResourceRetriever;
    }

    @Override
    public void setUserDataFlashOption(IDeviceFlasher.UserDataFlashOption flashOption) {
        this.mUserDataFlashOption = flashOption;
    }

    @Override
    public IDeviceFlasher.UserDataFlashOption getUserDataFlashOption() {
        return this.mUserDataFlashOption;
    }

    void setTestsZipInstaller(ITestsZipInstaller testsZipInstaller) {
        this.mTestsZipInstaller = testsZipInstaller;
    }

    ITestsZipInstaller getTestsZipInstaller() {
        if (this.mTestsZipInstaller == null) {
            if (this.mDataWipeSkipList == null) {
                this.mDataWipeSkipList = new ArrayList<String>();
            }
            if (this.mDataWipeSkipList.isEmpty()) {
                this.mDataWipeSkipList.add("media");
            }
            this.mTestsZipInstaller = new DefaultTestsZipInstaller(this.mDataWipeSkipList);
        }
        return this.mTestsZipInstaller;
    }

    public void setFlashOptions(Collection<String> flashOptions) {
        this.mFlashOptions = flashOptions.stream().map(String::trim).collect(Collectors.toList());
    }

    public void setIncrementalFlashing(IncrementalImageUtil incrementalUtil) {
        this.mIncrementalFlashing = incrementalUtil;
    }

    @Override
    public void preFlashOperations(ITestDevice device, IDeviceBuildInfo deviceBuild) throws TargetSetupError, DeviceNotAvailableException {
        String fastbootVersion;
        boolean initialStateFastbootD;
        boolean bl = initialStateFastbootD = this.supportsFlashingInFastbootD() && TestDeviceState.FASTBOOTD.equals((Object)device.getDeviceState());
        if (initialStateFastbootD) {
            LogUtil.CLog.i("Using flashing from fastbootd");
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.FLASHING_FROM_FASTBOOTD, 1L);
        }
        LogUtil.CLog.i("Flashing device %s with build %s", device.getSerialNumber(), deviceBuild.getDeviceBuildId());
        if (TestDeviceState.ONLINE.equals((Object)device.getDeviceState())) {
            this.setSystemBuildInfo(device.getBuildId(), device.getBuildFlavor());
        }
        if (!initialStateFastbootD) {
            device.rebootIntoBootloader();
        }
        this.downloadFlashingResources(device, deviceBuild);
        this.preFlashSetup(device, deviceBuild);
        if (device instanceof IManagedTestDevice && (fastbootVersion = ((IManagedTestDevice)device).getFastbootVersion()) != null) {
            deviceBuild.addBuildAttribute(FASTBOOT_VERSION, fastbootVersion);
        }
    }

    @Override
    public void flash(ITestDevice device, IDeviceBuildInfo deviceBuild) throws TargetSetupError, DeviceNotAvailableException {
        this.handleUserDataFlashing(device, deviceBuild);
        this.checkAndFlashBootloader(device, deviceBuild);
        this.checkAndFlashBaseband(device, deviceBuild);
        this.flashExtraImages(device, deviceBuild);
        this.checkAndFlashSystem(device, this.mSystemBuildId, this.mSystemBuildFlavor, deviceBuild);
    }

    private String[] buildFastbootCommand(String action, boolean skipReboot, String ... args) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        if ("flash".equals(action) || "update".equals(action) || "flashall".equals(action)) {
            if (skipReboot) {
                cmdArgs.add(SKIP_REBOOT_PARAM);
            }
            cmdArgs.addAll(this.mFlashOptions);
        }
        cmdArgs.add(action);
        cmdArgs.addAll(Arrays.asList(args));
        return cmdArgs.toArray(new String[cmdArgs.size()]);
    }

    protected void preFlashSetup(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
    }

    protected void handleUserDataFlashing(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        if (IDeviceFlasher.UserDataFlashOption.FORCE_WIPE.equals((Object)this.mUserDataFlashOption) || IDeviceFlasher.UserDataFlashOption.WIPE.equals((Object)this.mUserDataFlashOption)) {
            CommandResult result = device.executeFastbootCommand(this.mWipeTimeout, "-w");
            this.handleFastbootResult(device, result, "-w");
        } else {
            this.flashUserData(device, deviceBuild);
            this.wipeCache(device);
        }
    }

    protected void flashPartition(ITestDevice device, File imgFile, String partition) throws DeviceNotAvailableException, TargetSetupError {
        LogUtil.CLog.d("fastboot flash %s %s [size=%d]", partition, imgFile.getAbsolutePath(), imgFile.length());
        this.executeLongFastbootCmd(device, this.buildFastbootCommand("flash", this.mShouldFlashRamdisk, partition, imgFile.getAbsolutePath()));
    }

    protected void wipePartition(ITestDevice device, String partition) throws DeviceNotAvailableException, TargetSetupError {
        String wipeMethod = device.getUseFastbootErase() ? "erase" : "format";
        LogUtil.CLog.d("fastboot %s %s", wipeMethod, partition);
        CommandResult result = device.fastbootWipePartition(partition);
        this.handleFastbootResult(device, result, wipeMethod, partition);
    }

    protected boolean hasPartition(ITestDevice device, String partition) throws DeviceNotAvailableException {
        String partitionType = String.format("partition-type:%s", partition);
        CommandResult result = device.executeFastbootCommand("getvar", partitionType);
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus()) || result.getStderr().contains("FAILED")) {
            return false;
        }
        Pattern regex = Pattern.compile(String.format("^%s:\\s*\\S+$", partitionType), 8);
        return regex.matcher(result.getStderr()).find();
    }

    protected void downloadFlashingResources(ITestDevice device, IDeviceBuildInfo localBuild) throws TargetSetupError, DeviceNotAvailableException {
        String basebandVersion;
        IFlashingResourcesParser resourceParser = this.createFlashingResourcesParser(localBuild, device.getDeviceDescriptor());
        if (resourceParser.getRequiredBoards() == null) {
            throw new TargetSetupError(String.format("Build %s is missing required board info.", localBuild.getDeviceBuildId()), device.getDeviceDescriptor());
        }
        String deviceProductType = device.getProductType();
        if (deviceProductType == null) {
            throw new DeviceNotAvailableException(String.format("Could not determine product type for device %s", device.getSerialNumber()), device.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        this.verifyRequiredBoards(device, resourceParser, deviceProductType);
        String bootloaderVersion = resourceParser.getRequiredBootloaderVersion();
        if (bootloaderVersion != null && localBuild.getBootloaderImageFile() == null) {
            localBuild.setBootloaderImageFile(this.getFlashingResourcesRetriever().retrieveFile(this.getBootloaderFilePrefix(device), bootloaderVersion), bootloaderVersion);
        }
        if ((basebandVersion = resourceParser.getRequiredBasebandVersion()) != null && localBuild.getBasebandImageFile() == null) {
            localBuild.setBasebandImage(this.getFlashingResourcesRetriever().retrieveFile(BASEBAND_IMAGE_NAME, basebandVersion), basebandVersion);
        }
        this.downloadExtraImageFiles(resourceParser, this.getFlashingResourcesRetriever(), localBuild);
    }

    protected void verifyRequiredBoards(ITestDevice device, IFlashingResourcesParser resourceParser, String deviceProductType) throws TargetSetupError {
        if (!FastbootDeviceFlasher.containsIgnoreCase(resourceParser.getRequiredBoards(), deviceProductType)) {
            throw new TargetSetupError(String.format("Device %s is %s. Expected %s", device.getSerialNumber(), deviceProductType, resourceParser.getRequiredBoards()), device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.UNEXPECTED_DEVICE_CONFIGURED);
        }
    }

    private static boolean containsIgnoreCase(Collection<String> stringList, String anotherString) {
        for (String aString : stringList) {
            if (aString == null || !aString.equalsIgnoreCase(anotherString)) continue;
            return true;
        }
        return false;
    }

    protected void downloadExtraImageFiles(IFlashingResourcesParser resourceParser, IFlashingResourcesRetriever retriever, IDeviceBuildInfo localBuild) throws TargetSetupError {
    }

    protected IFlashingResourcesParser createFlashingResourcesParser(IDeviceBuildInfo localBuild, DeviceDescriptor descriptor) throws TargetSetupError {
        try {
            return new FlashingResourcesParser(localBuild.getDeviceImageFile());
        }
        catch (TargetSetupError e) {
            throw new TargetSetupError(e.getMessage(), (Throwable)e, descriptor);
        }
    }

    protected boolean checkAndFlashBootloader(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        String currentBootloaderVersion = this.getImageVersion(device, "bootloader");
        if (deviceBuild.getBootloaderVersion() != null && !deviceBuild.getBootloaderVersion().equals(currentBootloaderVersion)) {
            LogUtil.CLog.i("Flashing bootloader %s", deviceBuild.getBootloaderVersion());
            this.flashBootloader(device, deviceBuild.getBootloaderImageFile());
            if (this.mIncrementalFlashing != null) {
                this.mIncrementalFlashing.notifyBootloaderNeedsRevert();
            }
            return true;
        }
        LogUtil.CLog.i("Bootloader is already version %s, skipping flashing", currentBootloaderVersion);
        return false;
    }

    protected void flashBootloader(ITestDevice device, File bootloaderImageFile) throws DeviceNotAvailableException, TargetSetupError {
        this.executeFastbootCmd(device, this.buildFastbootCommand("flash", this.mShouldFlashRamdisk, this.getBootPartitionName(), bootloaderImageFile.getAbsolutePath()));
        device.rebootIntoBootloader();
    }

    protected String getBootPartitionName() {
        return "bootloader";
    }

    protected String getBootloaderFilePrefix(ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        return this.getBootPartitionName();
    }

    protected void checkAndFlashBaseband(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        if (this.checkShouldFlashBaseband(device, deviceBuild)) {
            LogUtil.CLog.i("Flashing baseband %s", deviceBuild.getBasebandVersion());
            this.flashBaseband(device, deviceBuild.getBasebandImageFile());
            if (this.mIncrementalFlashing != null) {
                this.mIncrementalFlashing.notifyBasebadNeedsRevert();
            }
        }
    }

    protected boolean checkShouldFlashBaseband(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        boolean shouldFlash;
        String currentBasebandVersion = this.getImageVersion(device, "baseband");
        boolean bl = shouldFlash = deviceBuild.getBasebandVersion() != null && !deviceBuild.getBasebandVersion().equals(currentBasebandVersion);
        if (!shouldFlash) {
            LogUtil.CLog.i("Baseband is already version %s, skipping flashing", currentBasebandVersion);
        }
        return shouldFlash;
    }

    protected void flashBaseband(ITestDevice device, File basebandImageFile) throws DeviceNotAvailableException, TargetSetupError {
        this.flashPartition(device, basebandImageFile, BASEBAND_IMAGE_NAME);
        device.rebootIntoBootloader();
    }

    protected void wipeCache(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        if (!this.mUserDataFlashOption.equals((Object)IDeviceFlasher.UserDataFlashOption.RETAIN)) {
            LogUtil.CLog.i("Wiping cache on %s", device.getSerialNumber());
            String partition = "cache";
            if (this.hasPartition(device, partition)) {
                this.wipePartition(device, partition);
            }
        } else {
            LogUtil.CLog.d("Skipping cache wipe on %s", device.getSerialNumber());
        }
    }

    protected void flashUserData(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        switch (this.mUserDataFlashOption) {
            case FLASH: {
                LogUtil.CLog.i("Flashing %s with userdata %s", device.getSerialNumber(), deviceBuild.getUserDataImageFile().getAbsolutePath());
                this.flashPartition(device, deviceBuild.getUserDataImageFile(), "userdata");
                break;
            }
            case FLASH_IMG_ZIP: {
                this.flashUserDataFromDeviceImageFile(device, deviceBuild);
                break;
            }
            case FORCE_WIPE: 
            case WIPE: {
                LogUtil.CLog.i("Wiping userdata %s", device.getSerialNumber());
                this.wipePartition(device, "userdata");
                break;
            }
            case TESTS_ZIP: {
                device.rebootUntilOnline();
                if (device.isEncryptionSupported() && device.isDeviceEncrypted()) {
                    device.unlockDevice();
                }
                this.getTestsZipInstaller().pushTestsZipOntoData(device, deviceBuild);
                device.rebootIntoBootloader();
                break;
            }
            case WIPE_RM: {
                device.rebootUntilOnline();
                this.getTestsZipInstaller().deleteData(device);
                device.rebootIntoBootloader();
                break;
            }
            default: {
                LogUtil.CLog.d("Skipping userdata flash for %s", device.getSerialNumber());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flashUserDataFromDeviceImageFile(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        File userdataImg = null;
        try {
            try (ZipFile zip = new ZipFile(deviceBuild.getDeviceImageFile());){
                userdataImg = ZipUtil2.extractFileFromZip(zip, "userdata.img");
            }
            catch (IOException ioe) {
                throw new TargetSetupError("failed to extract userdata.img from image file", (Throwable)ioe, device.getDeviceDescriptor());
            }
            LogUtil.CLog.i("Flashing %s with userdata %s", device.getSerialNumber(), userdataImg);
            this.flashPartition(device, userdataImg, "userdata");
        }
        catch (Throwable throwable) {
            FileUtil.deleteFile(userdataImg);
            throw throwable;
        }
        FileUtil.deleteFile(userdataImg);
    }

    protected void flashExtraImages(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
    }

    protected boolean checkAndFlashSystem(ITestDevice device, String systemBuildId, String systemBuildFlavor, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        if (this.shouldFlashSystem(systemBuildId, systemBuildFlavor, deviceBuild)) {
            LogUtil.CLog.i("Flashing system %s", deviceBuild.getDeviceBuildId());
            this.flashSystem(device, deviceBuild);
            return true;
        }
        LogUtil.CLog.i("System is already version %s and build flavor %s, skipping flashing", systemBuildId, systemBuildFlavor);
        if (this.mShouldFlashRamdisk) {
            this.flashRamdiskIfNeeded(device, deviceBuild);
            LogUtil.CLog.i("Flashed ramdisk anyways per flasher settings.");
        }
        device.rebootUntilOnline();
        return false;
    }

    boolean shouldFlashSystem(String systemBuildId, String systemBuildFlavor, IDeviceBuildInfo deviceBuild) {
        if (this.mForceSystemFlash) {
            return true;
        }
        if (systemBuildFlavor == null || systemBuildId == null) {
            return true;
        }
        return !systemBuildId.equals(deviceBuild.getDeviceBuildId()) || !systemBuildFlavor.equalsIgnoreCase(deviceBuild.getBuildFlavor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flashSystem(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        LogUtil.CLog.i("Flashing device %s with image %s", device.getSerialNumber(), deviceBuild.getDeviceImageFile().getAbsolutePath());
        try (CloseableTraceScope ignored = new CloseableTraceScope("flash_system");){
            boolean shouldFlash;
            block15: {
                shouldFlash = true;
                if (this.mIncrementalFlashing != null) {
                    try {
                        this.mIncrementalFlashing.updateDevice();
                        shouldFlash = false;
                    }
                    catch (TargetSetupError e) {
                        LogUtil.CLog.e(e);
                        DeviceImageTracker.getDefaultCache().invalidateTracking(device.getSerialNumber());
                        if (!TestDeviceState.ONLINE.equals((Object)device.getDeviceState())) break block15;
                        device.rebootIntoBootloader();
                    }
                }
            }
            if (shouldFlash) {
                if (this.getHostOptions().shouldFlashWithFuseZip() && this.getFuseUtil().canMountZip()) {
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.FLASHING_METHOD, FlashingMethod.FASTBOOT_FLASH_ALL_FUSE_ZIP.toString());
                    this.flashWithFuseZip(device, deviceBuild);
                } else {
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.FLASHING_METHOD, FlashingMethod.FASTBOOT_UPDATE.toString());
                    this.flashWithUpdateCommand(device, deviceBuild);
                }
            }
            this.flashRamdiskIfNeeded(device, deviceBuild);
            this.mSystemFlashStatus = this.mFbCmdStatus;
        }
        finally {
            if (this.mSystemFlashStatus == null) {
                this.mSystemFlashStatus = CommandStatus.EXCEPTION;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void flashWithFuseZip(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        File mountPoint;
        block8: {
            FuseUtil fuseUtil = this.getFuseUtil();
            mountPoint = null;
            try {
                mountPoint = FileUtil.createTempDir("FlashAllMountPoint");
                fuseUtil.mountZip(deviceBuild.getDeviceImageFile().getAbsoluteFile(), mountPoint);
                HashMap<String, String> systemVarMap = new HashMap<String, String>();
                systemVarMap.put("ANDROID_PRODUCT_OUT", mountPoint.getAbsolutePath());
                String[] fastbootArgs = this.buildFastbootCommand("flashall", this.mShouldFlashRamdisk, new String[0]);
                this.executeLongFastbootCmd(device, systemVarMap, fastbootArgs);
                if (mountPoint == null) break block8;
                fuseUtil.unmountZip(mountPoint);
            }
            catch (DeviceNotAvailableException e) {
                try {
                    throw new DeviceNotAvailableException("Device became unavailable during fastboot 'flashall'. Please verify that the image you are flashing can boot properly.", (Throwable)e, device.getSerialNumber());
                    catch (IOException e2) {
                        throw new TargetSetupError(String.format("Unable to create a temp dir for fuse zip to mount on, error: %s", e2.getMessage()), (ErrorIdentifier)InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
                    }
                }
                catch (Throwable throwable) {
                    if (mountPoint != null) {
                        fuseUtil.unmountZip(mountPoint);
                        FileUtil.recursiveDelete(mountPoint);
                    }
                    if (mountPoint.exists()) {
                        throw new HarnessRuntimeException(String.format("Failed to delete mount point %s, unmount operation might failed.", mountPoint), InfraErrorIdentifier.LAB_HOST_FILESYSTEM_ERROR);
                    }
                    throw throwable;
                }
            }
            FileUtil.recursiveDelete(mountPoint);
        }
        if (mountPoint.exists()) {
            throw new HarnessRuntimeException(String.format("Failed to delete mount point %s, unmount operation might failed.", mountPoint), InfraErrorIdentifier.LAB_HOST_FILESYSTEM_ERROR);
        }
    }

    private void flashWithUpdateCommand(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        try {
            this.executeLongFastbootCmd(device, this.buildFastbootCommand("update", this.mShouldFlashRamdisk, deviceBuild.getDeviceImageFile().getAbsolutePath()));
        }
        catch (DeviceNotAvailableException e) {
            throw new DeviceNotAvailableException("Device became unavailable during fastboot 'update'. Please verify that the image you are flashing can boot properly.", (Throwable)e, device.getSerialNumber());
        }
    }

    protected String getImageVersion(ITestDevice device, String imageName) throws DeviceNotAvailableException, TargetSetupError {
        int attempts = 0;
        String versionQuery = String.format("version-%s", imageName);
        String patternString = String.format("%s:\\s(.*)\\s", versionQuery);
        Pattern versionOutputPattern = Pattern.compile(patternString);
        while (attempts < 3) {
            String queryOutput = this.executeFastbootCmd(device, "getvar", versionQuery);
            Matcher matcher = versionOutputPattern.matcher(queryOutput);
            if (matcher.find()) {
                return matcher.group(1);
            }
            LogUtil.CLog.w("Could not find version for '%s'. Output '%s', retrying.", imageName, queryOutput);
            this.getRunUtil().sleep(2000 * (++attempts - 1) + new Random(System.currentTimeMillis()).nextInt(2000));
        }
        throw new TargetSetupError(String.format("Could not find version for '%s' after %d retry attempts", imageName, attempts), device.getDeviceDescriptor());
    }

    protected String getCurrentSlot(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        Matcher matcher;
        if (device.getDeviceState().equals((Object)TestDeviceState.FASTBOOT)) {
            String queryOutput = this.executeFastbootCmd(device, "getvar", SLOT_VAR);
            Pattern outputPattern = Pattern.compile(String.format("^%s: _?([ab])", SLOT_VAR));
            matcher = outputPattern.matcher(queryOutput);
        } else {
            String queryOutput = device.executeShellCommand(String.format("getprop %s", SLOT_PROP));
            Pattern outputPattern = Pattern.compile(String.format("^\\[%s\\]: \\[_?([ab])\\]", SLOT_PROP));
            matcher = outputPattern.matcher(queryOutput);
        }
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    protected String executeFastbootCmd(ITestDevice device, String ... cmdArgs) throws DeviceNotAvailableException, TargetSetupError {
        LogUtil.CLog.v("Executing short fastboot command %s", Arrays.toString(cmdArgs));
        CommandResult result = device.executeFastbootCommand(cmdArgs);
        return this.handleFastbootResult(device, result, cmdArgs);
    }

    protected String executeLongFastbootCmd(ITestDevice device, String ... cmdArgs) throws DeviceNotAvailableException, TargetSetupError {
        return this.executeLongFastbootCmd(device, new HashMap<String, String>(), cmdArgs);
    }

    protected String executeLongFastbootCmd(ITestDevice device, Map<String, String> envVarMap, String ... cmdArgs) throws DeviceNotAvailableException, TargetSetupError {
        CommandResult result = device.executeLongFastbootCommand(envVarMap, cmdArgs);
        return this.handleFastbootResult(device, result, cmdArgs);
    }

    @VisibleForTesting
    String handleFastbootResult(ITestDevice device, CommandResult result, String ... cmdArgs) throws TargetSetupError {
        LogUtil.CLog.v("fastboot stdout: " + result.getStdout());
        LogUtil.CLog.v("fastboot stderr: " + result.getStderr());
        this.mFbCmdStatus = result.getStatus();
        Enum errorIdentifier = null;
        boolean diskErrorIdentified = false;
        for (String diskError : DISK_SPACE_ERRORS) {
            if (!result.getStderr().contains(diskError)) continue;
            errorIdentifier = InfraErrorIdentifier.NO_DISK_SPACE;
            this.mFbCmdStatus = CommandStatus.FAILED;
            diskErrorIdentified = true;
            break;
        }
        if (!diskErrorIdentified && result.getStderr().contains("FAILED")) {
            this.mFbCmdStatus = CommandStatus.FAILED;
        }
        if (this.mFbCmdStatus != CommandStatus.SUCCESS) {
            if (errorIdentifier == null) {
                errorIdentifier = DeviceErrorIdentifier.ERROR_AFTER_FLASHING;
            }
            throw new TargetSetupError(String.format("fastboot command %s failed in device %s. stdout: %s, stderr: %s", cmdArgs[0], device.getSerialNumber(), result.getStdout(), result.getStderr()), device.getDeviceDescriptor(), (ErrorIdentifier)((Object)errorIdentifier));
        }
        if (result.getStderr().length() > 0) {
            return result.getStderr();
        }
        return result.getStdout();
    }

    @Override
    public void overrideDeviceOptions(ITestDevice device) {
    }

    @Override
    public void setForceSystemFlash(boolean forceSystemFlash) {
        this.mForceSystemFlash = forceSystemFlash;
    }

    @Override
    public void setDataWipeSkipList(Collection<String> dataWipeSkipList) {
        if (dataWipeSkipList == null) {
            dataWipeSkipList = new ArrayList<String>();
        }
        if (dataWipeSkipList.isEmpty()) {
            dataWipeSkipList.add("media");
        }
        this.mDataWipeSkipList = dataWipeSkipList;
    }

    @Override
    public void setWipeTimeout(long timeout) {
        this.mWipeTimeout = timeout;
    }

    @Override
    public CommandStatus getSystemFlashingStatus() {
        return this.mSystemFlashStatus;
    }

    @Override
    public void setShouldFlashRamdisk(boolean shouldFlashRamdisk) {
        this.mShouldFlashRamdisk = shouldFlashRamdisk;
    }

    @Override
    public void setRamdiskPartition(String ramdiskPartition) {
        this.mRamdiskPartition = ramdiskPartition;
    }

    @Override
    public boolean shouldFlashRamdisk() {
        return this.mShouldFlashRamdisk;
    }

    protected void flashRamdiskIfNeeded(ITestDevice device, IDeviceBuildInfo deviceBuild) throws TargetSetupError, DeviceNotAvailableException {
        if (this.mShouldFlashRamdisk) {
            device.rebootIntoBootloader();
            this.executeLongFastbootCmd(device, "flash", this.mRamdiskPartition, deviceBuild.getRamdiskFile().getAbsolutePath());
            device.reboot();
        }
    }

    protected void setSystemBuildInfo(String systemBuildId, String systemBuildFlavor) {
        this.mSystemBuildId = systemBuildId;
        this.mSystemBuildFlavor = systemBuildFlavor;
    }

    @VisibleForTesting
    IHostOptions getHostOptions() {
        return GlobalConfiguration.getInstance().getHostOptions();
    }
}

