/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.DeviceFlashPreparer;
import com.android.tradefed.targetprep.FastbootDeviceFlasher;
import com.android.tradefed.targetprep.IDeviceFlasher;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.BuildInfoUtil;
import java.io.File;

public class FastbootUpdateBootstrapPreparer
extends DeviceFlashPreparer {
    @Option(name="bootloader-image", description="bootloader image file to be used for update")
    private File mBootloaderImage = null;
    @Option(name="baseband-image", description="radio image file to be used for update")
    private File mBasebandImage = null;
    @Option(name="device-image", description="device image file to be used for update")
    private File mDeviceImage = null;
    @Option(name="bootstrap-build-info", description="whether build info should bebootstrapped based on device attributes after flashing")
    private boolean mBootStrapBuildInfo = true;
    @Option(name="override-device-build-id", description="the device buid id to inject.")
    private String mOverrideDeviceBuildId = null;
    @Option(name="override-device-build-alias", description="the device buid alias to inject.")
    private String mOverrideDeviceBuildAlias = null;
    @Option(name="override-device-build-flavor", description="the device build flavor to inject.")
    private String mOverrideDeviceBuildFlavor = null;
    @Option(name="override-device-build-branch", description="the device build branch to inject.")
    private String mOverrideDeviceBuildBranch = null;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        if (!(buildInfo instanceof IDeviceBuildInfo)) {
            throw new IllegalArgumentException("Provided build info must be a IDeviceBuildInfo");
        }
        this.setUserDataFlashOption(IDeviceFlasher.UserDataFlashOption.WIPE);
        IDeviceBuildInfo deviceBuildInfo = (IDeviceBuildInfo)buildInfo;
        deviceBuildInfo.setBootloaderImageFile(this.mBootloaderImage, "0");
        deviceBuildInfo.setBasebandImage(this.mBasebandImage, "0");
        deviceBuildInfo.setDeviceImageFile(this.mDeviceImage, "0");
        this.setSkipPostFlashBuildIdCheck(true);
        super.setUp(testInfo);
        if (this.mBootStrapBuildInfo) {
            BuildInfoUtil.bootstrapDeviceBuildAttributes(buildInfo, device, this.mOverrideDeviceBuildId, this.mOverrideDeviceBuildFlavor, this.mOverrideDeviceBuildBranch, this.mOverrideDeviceBuildAlias);
        }
    }

    @Override
    protected IDeviceFlasher createFlasher(ITestDevice device) throws DeviceNotAvailableException {
        return new FastbootDeviceFlasher();
    }
}

