/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@OptionClass(alias="feature-flags")
public class FeatureFlagTargetPreparer
extends BaseTargetPreparer {
    private static final Pattern FLAG_PATTERN = Pattern.compile("^(?<namespace>[^\\s/=]+)/(?<name>[^\\s/=]+)=(?<value>.*)$");
    @Option(name="flag-file", description="File containing flag values to apply. Can be repeated.")
    private List<File> mFlagFiles = new ArrayList<File>();
    @Option(name="flag-value", description="Additional flag values to apply. Can be repeated.")
    private List<String> mFlagValues = new ArrayList<String>();
    @Option(name="reboot-between-flag-files", description="Enables reboots after each input file. Used for reversibility testing.")
    private boolean mRebootBetweenFlagFiles = false;
    private final Map<String, Map<String, String>> mFlagsToRestore = new HashMap<String, Map<String, String>>();

    @Override
    public void setUp(TestInformation testInformation) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInformation.getDevice();
        if (this.mFlagFiles.isEmpty() && this.mFlagValues.isEmpty()) {
            LogUtil.CLog.i("No flag-file or flag-value option provided, skipping");
            return;
        }
        ArrayList<Map<String, Map<String, String>>> flagBundles = new ArrayList<Map<String, Map<String, String>>>();
        for (File flagFile : this.mFlagFiles) {
            if (flagFile == null || !flagFile.isFile()) {
                throw new TargetSetupError(String.format("Flag file '%s' not found", flagFile), device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
            }
            flagBundles.add(this.parseFlags(device, flagFile));
        }
        if (!this.mFlagValues.isEmpty()) {
            flagBundles.add(this.parseFlags(device, this.mFlagValues, true));
        }
        Map<String, Map<String, String>> initialFlags = null;
        boolean flagsUpdated = false;
        for (Map map : flagBundles) {
            Map<String, Map<String, String>> currentFlags = this.listFlags(device);
            if (initialFlags == null) {
                initialFlags = currentFlags;
            }
            for (String namespace : map.keySet()) {
                Map currentValues = currentFlags.getOrDefault(namespace, Map.of());
                Map targetValues = (Map)map.get(namespace);
                targetValues.entrySet().removeAll(currentValues.entrySet());
                this.updateFlagsToRestore(namespace, initialFlags.getOrDefault(namespace, Map.of()), targetValues);
            }
            if (map.values().stream().allMatch(Map::isEmpty)) continue;
            this.updateFlags(device, map);
            flagsUpdated = true;
            if (!this.mRebootBetweenFlagFiles) continue;
            device.reboot();
        }
        if (!this.mRebootBetweenFlagFiles && flagsUpdated) {
            device.reboot();
        }
    }

    @Override
    public void tearDown(TestInformation testInformation, Throwable e) throws DeviceNotAvailableException {
        if (e instanceof DeviceNotAvailableException || this.mFlagsToRestore.isEmpty() || this.mFlagsToRestore.values().stream().allMatch(Map::isEmpty)) {
            return;
        }
        try {
            ITestDevice device = testInformation.getDevice();
            this.updateFlags(device, this.mFlagsToRestore);
            device.reboot();
        }
        catch (TargetSetupError tse) {
            LogUtil.CLog.e("Failed to restore flags: %s", tse);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<String, Map<String, String>> listFlags(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        String values2 = this.runCommand(device, "device_config list");
        try (ByteArrayInputStream stream = new ByteArrayInputStream(values2.getBytes());){
            Map<String, Map<String, String>> map;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                map = this.parseFlags(device, reader.lines().collect(Collectors.toList()), false);
            }
            return map;
        }
        catch (IOException ioe) {
            throw new TargetSetupError("Failed to parse device flags", (Throwable)ioe, device.getDeviceDescriptor(), DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<String, Map<String, String>> parseFlags(ITestDevice device, File flagFile) throws TargetSetupError {
        try (FileInputStream stream = new FileInputStream(flagFile);){
            Map<String, Map<String, String>> map;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                map = this.parseFlags(device, reader.lines().collect(Collectors.toList()), false);
            }
            return map;
        }
        catch (IOException ioe) {
            throw new TargetSetupError("Failed to parse flag file", (Throwable)ioe, device.getDeviceDescriptor(), InfraErrorIdentifier.LAB_HOST_FILESYSTEM_ERROR);
        }
    }

    private Map<String, Map<String, String>> parseFlags(ITestDevice device, List<String> lines, boolean throwIfInvalid) throws TargetSetupError {
        HashMap<String, Map<String, String>> flags = new HashMap<String, Map<String, String>>();
        for (String line : lines) {
            Matcher match = FLAG_PATTERN.matcher(line);
            if (!match.matches()) {
                if (throwIfInvalid) {
                    throw new TargetSetupError(String.format("Failed to parse flag data: %s", line), device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                }
                LogUtil.CLog.w("Skipping invalid flag data: %s", line);
                continue;
            }
            String namespace = match.group("namespace");
            String name = match.group("name");
            String value = match.group("value");
            flags.computeIfAbsent(namespace, ns -> new HashMap()).put(name, value);
        }
        return flags;
    }

    private void updateFlagsToRestore(String namespace, Map<String, String> initialValues, Map<String, String> updatedValues) {
        for (String name : updatedValues.keySet()) {
            String initialValue = initialValues.get(name);
            String updatedValue = updatedValues.get(name);
            if (Objects.equals(updatedValue, initialValue)) {
                this.mFlagsToRestore.getOrDefault(namespace, Map.of()).remove(name);
                continue;
            }
            this.mFlagsToRestore.computeIfAbsent(namespace, ns -> new HashMap()).put(name, initialValue);
        }
    }

    private void updateFlags(ITestDevice device, Map<String, Map<String, String>> flags) throws DeviceNotAvailableException, TargetSetupError {
        for (String namespace : flags.keySet()) {
            for (Map.Entry<String, String> entry : flags.get(namespace).entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                this.updateFlag(device, namespace, name, value);
            }
        }
    }

    private void updateFlag(ITestDevice device, String namespace, String name, String value) throws DeviceNotAvailableException, TargetSetupError {
        if (Strings.isNullOrEmpty(value)) {
            this.runCommand(device, String.format("device_config delete '%s' '%s'", namespace, name));
        } else {
            this.runCommand(device, String.format("device_config put '%s' '%s' '%s'", namespace, name, value));
        }
    }

    private String runCommand(ITestDevice device, String command) throws DeviceNotAvailableException, TargetSetupError {
        CommandResult result = device.executeShellV2Command(command);
        if (result.getStatus() != CommandStatus.SUCCESS) {
            throw new TargetSetupError(String.format("Command %s failed, stdout = [%s], stderr = [%s]", command, result.getStdout(), result.getStderr()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        return result.getStdout();
    }
}

