/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.DeviceFailedToBootError;
import com.android.tradefed.targetprep.ILabPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.TarUtil;
import com.android.tradefed.util.ZipUtil2;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.io.PatternFilenameFilter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

@OptionClass(alias="gki-device-flash-preparer")
public class GkiDeviceFlashPreparer
extends BaseTargetPreparer
implements ILabPreparer {
    private static final String AVBTOOL = "bin/avbtool";
    private static final String MKBOOTIMG = "bin/mkbootimg";
    private static final String BUILD_IMAGE = "bin/build_image";
    private static final String MKE2FS = "bin/mke2fs";
    private static final String MKUSERIMG_MKE2FS = "bin/mkuserimg_mke2fs";
    private static final String E2FSDROID = "bin/e2fsdroid";
    private static final String OTATOOLS_ZIP = "otatools.zip";
    private static final String KERNEL_IMAGE = "Image.gz";
    private static final int STATE_STABLIZATION_WAIT_TIME = 60000;
    @Option(name="device-boot-time", description="max time to wait for device to boot. Set as 5 minutes by default", isTimeVal=true)
    private long mDeviceBootTime = 300000L;
    @Option(name="gki-boot-image-name", description="The file name in BuildInfo that provides GKI boot image.")
    private String mGkiBootImageName = "gki_boot.img";
    @Option(name="ramdisk-image-name", description="The file name in BuildInfo that provides ramdisk image.")
    private String mRamdiskImageName = "ramdisk.img";
    @Option(name="vendor-boot-image-name", description="The file name in BuildInfo that provides vendor boot image.")
    private String mVendorBootImageName = "vendor_boot.img";
    @Option(name="dtbo-image-name", description="The file name in BuildInfo that provides dtbo image.")
    private String mDtboImageName = "dtbo.img";
    @Option(name="vendor-dlkm-image-name", description="The file name in BuildInfo that provides vendor_dlkm image.")
    private String mVendorDlkmImageName = "vendor_dlkm.img";
    @Option(name="system-dlkm-image-name", description="The file name in BuildInfo that provides system_dlkm image.")
    private String mSystemDlkmImageName = "system_dlkm.img";
    @Option(name="system-dlkm-archive-name", description="The file name in BuildInfo that provides system_dlkm_staging_archive.tar.gz.")
    private String mSystemDlkmArchiveName = "system_dlkm_staging_archive.tar.gz";
    @Option(name="boot-image-file-name", description="The boot image file name to search for if gki-boot-image-name in BuildInfo is a zip file or directory, for example boot-5.4-gz.img.")
    private String mBootImageFileName = "boot(.*).img";
    @Option(name="vendor-boot-image-file-name", description="The vendor boot image file name to search for if vendor-boot-image-name in BuildInfo is a zip file or directory, for example vendor_boot.img.")
    private String mVendorBootImageFileName = "vendor_boot.img";
    @Option(name="dtbo-image-file-name", description="The dtbo image file name to search for if dtbo-image-name in BuildInfo is a zip file or directory, for example dtbo.img.")
    private String mDtboImageFileName = "dtbo.img";
    @Option(name="vendor-dlkm-image-file-name", description="The vendor_dlkm image file name to search for if vendor-dlkm-image-name in BuildInfo is a zip file or directory, for example vendor_dlkm.img.")
    private String mVendorDlkmImageFileName = "vendor_dlkm.img";
    @Option(name="system-dlkm-image-file-name", description="The system_dlkm image file name to search for if system-dlkm-image-name in BuildInfo is a zip file or directory, for example system_dlkm.img.")
    private String mSystemDlkmImageFileName = "system_dlkm.img";
    @Option(name="post-reboot-device-into-user-space", description="whether to boot the device in user space after flash.")
    private boolean mPostRebootDeviceIntoUserSpace = true;
    @Option(name="wipe-device-after-gki-flash", description="Whether to wipe device after GKI boot image flash.")
    private boolean mShouldWipeDevice = true;
    @Option(name="oem-disable-verity", description="Whether to run oem disable-verity.")
    private boolean mShouldDisableOemVerity = false;
    @Option(name="boot-header-version", description="The version of the boot.img header. Set to 3 by default.")
    private int mBootHeaderVersion = 3;
    @Option(name="add-hash-footer", description="Add hash footer to GKI boot image. More info at https://android.googlesource.com/platform/external/avb/+/master/README.md")
    private boolean mAddHashFooter = false;
    private File mBootImg = null;
    private File mSystemDlkmImg = null;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        File tmpDir = null;
        try {
            tmpDir = FileUtil.createTempDir("gki_preparer");
            this.validateGkiBootImg(device, buildInfo, tmpDir);
            if (this.mAddHashFooter) {
                this.addHashFooter(device, buildInfo, tmpDir);
            }
            this.buildGkiSystemDlkmImg(device, buildInfo, tmpDir);
            this.flashGki(device, buildInfo, tmpDir);
        }
        catch (IOException ioe) {
            throw new TargetSetupError(ioe.getMessage(), (Throwable)ioe, device.getDeviceDescriptor());
        }
        finally {
            FileUtil.recursiveDelete(tmpDir);
        }
        if (!this.mPostRebootDeviceIntoUserSpace) {
            return;
        }
        this.getRunUtil().sleep(60000L);
        device.rebootUntilOnline();
        if (device.enableAdbRoot()) {
            device.setDate(null);
        }
        try {
            device.setRecoveryMode(ITestDevice.RecoveryMode.AVAILABLE);
            device.waitForDeviceAvailable(this.mDeviceBootTime);
        }
        catch (DeviceUnresponsiveException e) {
            throw new DeviceFailedToBootError(String.format("Device %s did not become available after flashing GKI. Exception: %s", device.getSerialNumber(), e), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.ERROR_AFTER_FLASHING);
        }
        device.postBootSetup();
        LogUtil.CLog.i("Device update completed on %s", device.getDeviceDescriptor());
    }

    @VisibleForTesting
    protected IHostOptions getHostOptions() {
        return GlobalConfiguration.getInstance().getHostOptions();
    }

    @VisibleForTesting
    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flashGki(ITestDevice device, IBuildInfo buildInfo, File tmpDir) throws TargetSetupError, DeviceNotAvailableException {
        device.rebootIntoBootloader();
        if (this.mShouldDisableOemVerity) {
            this.executeFastbootCmd(device, "oem disable-verity");
        }
        long start = System.currentTimeMillis();
        this.getHostOptions().takePermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
        LogUtil.CLog.v("Flashing permit obtained after %ds", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
        this.getRunUtil().allowInterrupt(false);
        try {
            if (buildInfo.getFile(this.mVendorBootImageName) != null) {
                File vendorBootImg = this.getRequestedFile(device, this.mVendorBootImageFileName, buildInfo.getFile(this.mVendorBootImageName), tmpDir);
                this.executeFastbootCmd(device, "flash", "vendor_boot", vendorBootImg.getAbsolutePath());
            }
            if (buildInfo.getFile(this.mDtboImageName) != null) {
                File dtboImg = this.getRequestedFile(device, this.mDtboImageFileName, buildInfo.getFile(this.mDtboImageName), tmpDir);
                this.executeFastbootCmd(device, "flash", "dtbo", dtboImg.getAbsolutePath());
            }
            this.executeFastbootCmd(device, "flash", "boot", this.mBootImg.getAbsolutePath());
            if (buildInfo.getFile(this.mVendorDlkmImageName) != null) {
                File vendorDlkmImg = this.getRequestedFile(device, this.mVendorDlkmImageFileName, buildInfo.getFile(this.mVendorDlkmImageName), tmpDir);
                device.rebootIntoFastbootd();
                this.executeFastbootCmd(device, "flash", "vendor_dlkm", vendorDlkmImg.getAbsolutePath());
            }
            if (buildInfo.getFile(this.mSystemDlkmImageName) != null) {
                File systemDlkmImg = this.getRequestedFile(device, this.mSystemDlkmImageFileName, buildInfo.getFile(this.mSystemDlkmImageName), tmpDir);
                device.rebootIntoFastbootd();
                this.executeFastbootCmd(device, "flash", "system_dlkm", systemDlkmImg.getAbsolutePath());
            }
            if (this.mShouldWipeDevice) {
                this.executeFastbootCmd(device, "-w");
            }
            this.getHostOptions().returnPermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
            this.getRunUtil().allowInterrupt(true);
        }
        catch (Throwable throwable) {
            this.getHostOptions().returnPermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
            this.getRunUtil().allowInterrupt(true);
            LogUtil.CLog.v("Flashing permit returned after %ds", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
            throw throwable;
        }
        LogUtil.CLog.v("Flashing permit returned after %ds", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
    }

    public void validateGkiBootImg(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError {
        throw new TargetSetupError("Obsoleted. Please use validateGkiBootImg(ITestDevice, IBuildInfo, File)", device.getDeviceDescriptor());
    }

    @VisibleForTesting
    protected void validateGkiBootImg(ITestDevice device, IBuildInfo buildInfo, File tmpDir) throws TargetSetupError {
        if (buildInfo.getFile(this.mGkiBootImageName) != null && this.mBootImageFileName != null) {
            this.mBootImg = this.getRequestedFile(device, this.mBootImageFileName, buildInfo.getFile(this.mGkiBootImageName), tmpDir);
            return;
        }
        if (buildInfo.getFile(KERNEL_IMAGE) == null) {
            throw new TargetSetupError("Image.gz is not provided. Can not generate GKI boot.img.", device.getDeviceDescriptor());
        }
        if (buildInfo.getFile(this.mRamdiskImageName) == null) {
            throw new TargetSetupError(this.mRamdiskImageName + " is not provided. Can not generate GKI boot.img.", device.getDeviceDescriptor());
        }
        if (buildInfo.getFile(OTATOOLS_ZIP) == null) {
            throw new TargetSetupError("otatools.zip is not provided. Can not generate GKI boot.img.", device.getDeviceDescriptor());
        }
        try {
            File mkbootimg = this.getRequestedFile(device, MKBOOTIMG, buildInfo.getFile(OTATOOLS_ZIP), tmpDir);
            mkbootimg.setExecutable(true, false);
            this.mBootImg = FileUtil.createTempFile("boot", ".img", tmpDir);
            String cmd = String.format("%s --kernel %s --header_version %d --base 0x00000000 --pagesize 4096 --ramdisk %s -o %s", mkbootimg.getAbsolutePath(), buildInfo.getFile(KERNEL_IMAGE), this.mBootHeaderVersion, buildInfo.getFile(this.mRamdiskImageName), this.mBootImg.getAbsolutePath());
            this.executeHostCommand(device, cmd);
            LogUtil.CLog.i("The GKI boot.img is of size %d", this.mBootImg.length());
            if (this.mBootImg.length() == 0L) {
                throw new TargetSetupError("The mkbootimg tool didn't generate a valid boot.img.", device.getDeviceDescriptor());
            }
            buildInfo.setFile(this.mGkiBootImageName, this.mBootImg, "0");
        }
        catch (IOException e) {
            throw new TargetSetupError("Fail to generate GKI boot.img.", (Throwable)e, device.getDeviceDescriptor());
        }
    }

    @VisibleForTesting
    protected File extractSystemDlkmTarGzip(File systemDlkmArchive) throws IOException {
        return TarUtil.extractTarGzipToTemp(systemDlkmArchive, "system_dlkm_staging");
    }

    @VisibleForTesting
    protected void flattenSystemDlkm(ITestDevice device, File systemDlkmStagingDir) throws IOException, TargetSetupError {
        File[] depmodFiles;
        File[] files;
        File systemStagingLibModulesDir = new File(systemDlkmStagingDir, "lib/modules");
        Path libModulesPath = systemStagingLibModulesDir.toPath();
        File[] libModulesVersionFiles = systemStagingLibModulesDir.listFiles();
        File libModulesVersionDir = null;
        if (libModulesVersionFiles.length == 1) {
            libModulesVersionDir = libModulesVersionFiles[0];
            for (File file2 : libModulesVersionDir.listFiles()) {
                if (!file2.isFile()) continue;
                File hardLink = new File(systemStagingLibModulesDir, file2.getName());
                try {
                    FileUtil.hardlinkFile(file2, hardLink, true);
                }
                catch (IOException e) {
                    throw new TargetSetupError(String.format("Failed to create hardlink of %s to %s", file2.toString(), hardLink.toString()), device.getDeviceDescriptor());
                }
            }
        }
        Path libModulesKernel = new File(libModulesVersionDir != null ? libModulesVersionDir : systemStagingLibModulesDir, "kernel").toPath();
        try (Stream<Path> allPaths = Files.walk(libModulesKernel, new FileVisitOption[0]);){
            Path[] modulePaths;
            for (Path path2 : modulePaths = (Path[])allPaths.filter(path -> path.toString().endsWith(".ko")).toArray(Path[]::new)) {
                File hardLink = new File(systemStagingLibModulesDir, path2.toFile().getName());
                try {
                    FileUtil.hardlinkFile(path2.toFile(), hardLink, true);
                }
                catch (IOException e) {
                    throw new TargetSetupError(String.format("Failed to create a hardlink of %s to %s", path2.toString(), hardLink.toString()), device.getDeviceDescriptor());
                }
            }
        }
        catch (NoSuchFileException e) {
            LogUtil.CLog.i("Didn't find a kernel directory under lib/modules");
        }
        if (libModulesVersionDir != null) {
            FileUtil.recursiveDelete(libModulesVersionDir);
        } else if (libModulesKernel != null) {
            FileUtil.recursiveDelete(libModulesKernel.toFile());
        }
        for (File f : files = libModulesPath.toFile().listFiles(new PatternFilenameFilter("modules\\..*\\.bin"))) {
            Files.deleteIfExists(f.toPath());
        }
        Files.deleteIfExists(libModulesPath.resolve("modules.order"));
        for (File f : depmodFiles = libModulesPath.toFile().listFiles(new PatternFilenameFilter("modules\\..*"))) {
            String contents = FileUtil.readStringFromFile(f);
            contents = Pattern.compile("kernel[^: \n\t]*/([^: \n\t]+\\.ko)").matcher(contents).replaceAll("$1");
            FileUtil.writeToFile(contents, f);
        }
    }

    @VisibleForTesting
    protected void buildGkiSystemDlkmImg(ITestDevice device, IBuildInfo buildInfo, File tmpDir) throws TargetSetupError {
        File systemDlkmStagingDir = null;
        if (buildInfo.getFile(this.mSystemDlkmArchiveName) == null) {
            return;
        }
        File systemDlkmArchive = this.getRequestedFile(device, this.mSystemDlkmArchiveName, buildInfo.getFile(this.mSystemDlkmArchiveName), tmpDir);
        if (systemDlkmArchive == null) {
            throw new TargetSetupError(this.mSystemDlkmArchiveName + " is not provided. Can not generate GKI system_dlkm.img.", device.getDeviceDescriptor());
        }
        if (buildInfo.getFile(OTATOOLS_ZIP) == null) {
            throw new TargetSetupError("otatools.zip is not provided. Can not generate GKI system_dlkm.img.", device.getDeviceDescriptor());
        }
        File build_image = this.getRequestedFile(device, BUILD_IMAGE, buildInfo.getFile(OTATOOLS_ZIP), tmpDir);
        File mkuserimg_mke2fs = this.getRequestedFile(device, MKUSERIMG_MKE2FS, buildInfo.getFile(OTATOOLS_ZIP), tmpDir);
        File mke2fs = this.getRequestedFile(device, MKE2FS, buildInfo.getFile(OTATOOLS_ZIP), tmpDir);
        File e2fsdroid = this.getRequestedFile(device, E2FSDROID, buildInfo.getFile(OTATOOLS_ZIP), tmpDir);
        build_image.setExecutable(true, false);
        mkuserimg_mke2fs.setExecutable(true, false);
        mke2fs.setExecutable(true, false);
        e2fsdroid.setExecutable(true, false);
        try {
            systemDlkmStagingDir = this.extractSystemDlkmTarGzip(systemDlkmArchive);
            this.flattenSystemDlkm(device, systemDlkmStagingDir);
            File systemDlkmPropsFile = new File(tmpDir, "system_dlkm.props");
            File systemDlkmFileContexts = new File(tmpDir, "system_dlkm_file_contexts");
            PrintWriter systemDlkmFileContextsWriter = new PrintWriter(new FileWriter(systemDlkmFileContexts));
            systemDlkmFileContextsWriter.println("/system_dlkm(/.*)? u:object_r:system_dlkm_file:s0");
            systemDlkmFileContextsWriter.close();
            PrintWriter systemDlkmPropsPrintWriter = new PrintWriter(new FileWriter(systemDlkmPropsFile));
            systemDlkmPropsPrintWriter.println("fs_type=ext4");
            systemDlkmPropsPrintWriter.println("use_dynamic_partition_size=true");
            systemDlkmPropsPrintWriter.println("ext_mkuserimg=mkuserimg_mke2fs");
            systemDlkmPropsPrintWriter.println("ext4_share_dup_blocks=true");
            systemDlkmPropsPrintWriter.println("extfs_rsv_pct=0");
            systemDlkmPropsPrintWriter.println("journal_size=0");
            systemDlkmPropsPrintWriter.println("mount_point=system_dlkm");
            systemDlkmPropsPrintWriter.println(String.format("selinux_fc=%s", systemDlkmFileContexts.getAbsolutePath()));
            systemDlkmPropsPrintWriter.close();
            this.mSystemDlkmImg = new File(tmpDir, "system_dlkm.img");
            String buildImageCmd = String.format("%s %s %s %s /dev/null", build_image.getAbsolutePath(), systemDlkmStagingDir.getAbsolutePath(), systemDlkmPropsFile.getAbsolutePath(), this.mSystemDlkmImg.getAbsolutePath());
            this.executeHostCommand(device, buildImageCmd);
            LogUtil.CLog.i("The GKI system_dlkm.img is of size %d", this.mSystemDlkmImg.length());
            if (this.mSystemDlkmImg.length() == 0L) {
                throw new TargetSetupError("The build_image tool didn't generate a valid system_dlkm.img. (size=0)", device.getDeviceDescriptor());
            }
            buildInfo.setFile(this.mSystemDlkmImageName, this.mSystemDlkmImg, "0");
        }
        catch (IOException e) {
            throw new TargetSetupError("Failed to generate GKI system_dlkm.img.", (Throwable)e, device.getDeviceDescriptor());
        }
        finally {
            FileUtil.recursiveDelete(systemDlkmStagingDir);
        }
        File avbtool = this.getRequestedFile(device, AVBTOOL, buildInfo.getFile(OTATOOLS_ZIP), tmpDir);
        avbtool.setExecutable(true, false);
        String cmd = String.format("%s add_hashtree_footer --do_not_generate_fec --image %s --partition_name system_dlkm", avbtool.getAbsolutePath(), this.mSystemDlkmImg.getAbsolutePath());
        this.executeHostCommand(device, cmd);
    }

    @VisibleForTesting
    protected void addHashFooter(ITestDevice device, IBuildInfo buildInfo, File tmpDir) throws TargetSetupError, DeviceNotAvailableException {
        if (this.mBootImg == null) {
            throw new TargetSetupError(this.mGkiBootImageName + " is not provided. Can not add hash footer to it.", device.getDeviceDescriptor());
        }
        if (buildInfo.getFile(OTATOOLS_ZIP) == null) {
            throw new TargetSetupError("otatools.zip is not provided. Can not add hash footer to GKI boot.img.", device.getDeviceDescriptor());
        }
        File avbtool = this.getRequestedFile(device, AVBTOOL, buildInfo.getFile(OTATOOLS_ZIP), tmpDir);
        avbtool.setExecutable(true, false);
        String android_version = device.getProperty("ro.build.version.release");
        if (Strings.isNullOrEmpty(android_version)) {
            throw new TargetSetupError("Can not get android version from property ro.build.version.release.", device.getDeviceDescriptor());
        }
        String security_path_version = device.getProperty("ro.build.version.security_patch");
        if (Strings.isNullOrEmpty(security_path_version)) {
            throw new TargetSetupError("Can not get security path version from property ro.build.version.security_patch.", device.getDeviceDescriptor());
        }
        String command = String.format("du -b %s", this.mBootImg.getAbsolutePath());
        CommandResult cmdResult = this.executeHostCommand(device, command);
        String partition_size = cmdResult.getStdout().split("\\s+")[0];
        LogUtil.CLog.i("Boot image partition size: %s", partition_size);
        String cmd = String.format("%s add_hash_footer --image %s --partition_size %s --partition_name boot --prop com.android.build.boot.os_version:%s --prop com.android.build.boot.security_patch:%s", avbtool.getAbsolutePath(), this.mBootImg.getAbsolutePath(), partition_size, android_version, security_path_version);
        this.executeHostCommand(device, cmd);
    }

    private CommandResult executeHostCommand(ITestDevice device, String command) throws TargetSetupError {
        CommandResult result = this.getRunUtil().runTimedCmd(300000L, command.split("\\s+"));
        switch (result.getStatus()) {
            case SUCCESS: {
                LogUtil.CLog.i("Command %s finished successfully, stdout = [%s].", command, result.getStdout().trim());
                break;
            }
            case FAILED: {
                throw new TargetSetupError(String.format("Command %s failed, stdout = [%s], stderr = [%s].", command, result.getStdout().trim(), result.getStderr().trim()), device.getDeviceDescriptor());
            }
            case TIMED_OUT: {
                throw new TargetSetupError(String.format("Command %s timed out.", command), device.getDeviceDescriptor());
            }
            case EXCEPTION: {
                throw new TargetSetupError(String.format("Exception occurred when running command %s.", command), device.getDeviceDescriptor());
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    protected File getRequestedFile(ITestDevice device, String requestedFileName, File sourceFile, File tmpDir) throws TargetSetupError {
        File requestedFile;
        block11: {
            requestedFile = null;
            String baseFileName = new File(requestedFileName).getName();
            String subdirPathName = new File(requestedFileName).getParent();
            if (sourceFile.getName().endsWith(".zip")) {
                try (ZipFile sourceZipFile = new ZipFile(sourceFile);){
                    File destDir = FileUtil.createNamedTempDir(tmpDir, FileUtil.getBaseName(sourceFile.getName()) + "_zip");
                    File subdir = null;
                    if (subdirPathName != null && !subdirPathName.isEmpty()) {
                        subdir = FileUtil.createNamedTempDir(destDir, subdirPathName);
                    }
                    requestedFile = new File(subdir != null ? subdir : destDir, baseFileName);
                    ZipUtil2.extractFileFromZip(sourceZipFile, requestedFileName, requestedFile);
                    if (requestedFile.exists()) break block11;
                    Enumeration<ZipArchiveEntry> entries = sourceZipFile.getEntries();
                    while (entries.hasMoreElements()) {
                        ZipArchiveEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !entry.getName().matches(requestedFileName)) continue;
                        requestedFile = new File(subdir != null ? subdir : destDir, entry.getName());
                        FileUtil.writeToFile(sourceZipFile.getInputStream(entry), requestedFile);
                        break block11;
                    }
                    break block11;
                }
                catch (IOException e) {
                    throw new TargetSetupError(String.format("Fail to get %s from %s", requestedFileName, sourceFile), (Throwable)e, device.getDeviceDescriptor());
                }
            }
            requestedFile = sourceFile.isDirectory() ? FileUtil.findFile(sourceFile, requestedFileName) : sourceFile;
        }
        if (requestedFile != null && requestedFile.exists()) {
            return requestedFile;
        }
        throw new TargetSetupError(String.format("Requested file with file_name %s does not exist in provided %s.", requestedFileName, sourceFile), device.getDeviceDescriptor());
    }

    private String executeFastbootCmd(ITestDevice device, String ... cmdArgs) throws DeviceNotAvailableException, TargetSetupError {
        LogUtil.CLog.i("Execute fastboot command %s on %s", Arrays.toString(cmdArgs), device.getSerialNumber());
        CommandResult result = device.executeLongFastbootCommand(cmdArgs);
        LogUtil.CLog.v("fastboot stdout: " + result.getStdout());
        LogUtil.CLog.v("fastboot stderr: " + result.getStderr());
        CommandStatus cmdStatus = result.getStatus();
        if (result.getStderr().contains("FAILED")) {
            cmdStatus = CommandStatus.FAILED;
        }
        if (cmdStatus != CommandStatus.SUCCESS) {
            throw new TargetSetupError(String.format("fastboot command %s failed in device %s. stdout: %s, stderr: %s", Arrays.toString(cmdArgs), device.getSerialNumber(), result.getStdout(), result.getStderr()), device.getDeviceDescriptor());
        }
        if (result.getStderr().length() > 0) {
            return result.getStderr();
        }
        return result.getStdout();
    }
}

