/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.DeviceFailedToBootError;
import com.android.tradefed.targetprep.ILabPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.ZipUtil2;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@OptionClass(alias="gsi-device-flash-preparer")
public class GsiDeviceFlashPreparer
extends BaseTargetPreparer
implements ILabPreparer {
    private static final int DYNAMIC_PARTITION_API_LEVEL = 29;
    private static final int STATE_STABLIZATION_WAIT_TIME_MLLISECS = 60000;
    @Option(name="device-boot-time", description="max time to wait for device to boot. Set as 5 minutes by default", isTimeVal=true)
    private long mDeviceBootTime = 300000L;
    @Option(name="system-image-zip-name", description="The name of the zip file containing the system image in BuildInfo.")
    private String mSystemImageZipName = "gsi_system.img";
    @Option(name="system-image-file-name", description="The system image file name to search for if provided system image is in a zip file or directory.")
    private String mSystemImageFileName = "system.img";
    @Option(name="vbmeta-image-zip-name", description="The name of the zip file containing the system image in BuildInfo.")
    private String mVbmetaImageZipName = "gsi_vbmeta.img";
    @Option(name="vbmeta-image-file-name", description="The vbmeta image file name to search for if provided vbmeta image is in a zip file or directory.")
    private String mVbmetaImageFileName = "vbmeta.img";
    @Option(name="boot-image-zip-name", description="The name of the zip file containing the boot image in BuildInfo.")
    private String mBootImageZipName = "gki_boot.img";
    @Option(name="boot-image-file-name", description="The boot image file name to search for if boot image is is in a zip file or directory, for example boot-5.4.img. The first filematch the provided name string will be used.")
    private String mBootImageFileName = "boot(.*).img";
    @Option(name="erase-product-partition", description="Whether to erase product partion before flashing GSI.")
    private boolean mShouldEraseProductPartition = true;
    @Option(name="post-reboot-device-into-user-space", description="whether to boot the device in user space after flash.")
    private boolean mPostRebootDeviceIntoUserSpace = true;
    private File mSystemImg = null;
    private File mVbmetaImg = null;
    private File mBootImg = null;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        File tmpDir = null;
        try {
            tmpDir = FileUtil.createTempDir("gsi_preparer");
            this.validateGsiImg(device, buildInfo, tmpDir);
            this.flashGsi(device, buildInfo);
        }
        catch (IOException ioe) {
            throw new TargetSetupError(ioe.getMessage(), (Throwable)ioe, device.getDeviceDescriptor());
        }
        finally {
            FileUtil.recursiveDelete(tmpDir);
        }
        if (!this.mPostRebootDeviceIntoUserSpace) {
            return;
        }
        this.getRunUtil().sleep(60000L);
        device.rebootUntilOnline();
        if (device.enableAdbRoot()) {
            device.setDate(null);
        }
        try {
            device.setRecoveryMode(ITestDevice.RecoveryMode.AVAILABLE);
            device.waitForDeviceAvailable(this.mDeviceBootTime);
        }
        catch (DeviceUnresponsiveException e) {
            throw new DeviceFailedToBootError(String.format("Device %s did not become available after flashing GSI. Exception: %s", device.getSerialNumber(), e), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.ERROR_AFTER_FLASHING);
        }
        device.postBootSetup();
        LogUtil.CLog.i("Device update completed on %s", device.getDeviceDescriptor());
    }

    @VisibleForTesting
    protected IHostOptions getHostOptions() {
        return GlobalConfiguration.getInstance().getHostOptions();
    }

    @VisibleForTesting
    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flashGsi(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException {
        device.waitForDeviceOnline();
        boolean shouldUseFastbootd = true;
        if (device.getApiLevel() < 29) {
            shouldUseFastbootd = false;
        }
        device.rebootIntoBootloader();
        long start = System.currentTimeMillis();
        this.getHostOptions().takePermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
        LogUtil.CLog.v("Flashing permit obtained after %ds", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
        this.getRunUtil().allowInterrupt(false);
        try {
            this.executeFastbootCmd(device, "-w");
            if (this.mVbmetaImg != null) {
                this.executeFastbootCmd(device, "--disable-verification", "flash", "vbmeta", this.mVbmetaImg.getAbsolutePath());
            }
            if (this.mSystemImg != null) {
                String currSlot = this.getCurrentSlot(device);
                currSlot = currSlot == null ? "" : "_" + currSlot;
                if (shouldUseFastbootd) {
                    device.rebootIntoFastbootd();
                    if (this.mShouldEraseProductPartition) {
                        device.executeLongFastbootCommand("delete-logical-partition", "product" + currSlot);
                    }
                }
                this.executeFastbootCmd(device, "erase", "system" + currSlot);
                this.executeFastbootCmd(device, "flash", "system", this.mSystemImg.getAbsolutePath());
            }
            if (this.mBootImg != null) {
                device.rebootIntoBootloader();
                this.executeFastbootCmd(device, "flash", "boot", this.mBootImg.getAbsolutePath());
            }
            this.getHostOptions().returnPermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
            this.getRunUtil().allowInterrupt(true);
        }
        catch (Throwable throwable) {
            this.getHostOptions().returnPermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
            this.getRunUtil().allowInterrupt(true);
            LogUtil.CLog.v("Flashing permit returned after %ds", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
            throw throwable;
        }
        LogUtil.CLog.v("Flashing permit returned after %ds", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
    }

    private void validateGsiImg(ITestDevice device, IBuildInfo buildInfo, File tmpDir) throws TargetSetupError {
        if (buildInfo.getFile(this.mSystemImageZipName) == null) {
            throw new TargetSetupError(String.format("BuildInfo doesn't contain file key %s.", this.mSystemImageZipName), device.getDeviceDescriptor());
        }
        this.mSystemImg = this.getRequestedFile(device, this.mSystemImageFileName, buildInfo.getFile(this.mSystemImageZipName), tmpDir);
        if (buildInfo.getFile(this.mVbmetaImageZipName) != null) {
            this.mVbmetaImg = this.getRequestedFile(device, this.mVbmetaImageFileName, buildInfo.getFile(this.mVbmetaImageZipName), tmpDir);
        }
        if (buildInfo.getFile(this.mBootImageZipName) != null && this.mBootImageFileName != null) {
            this.mBootImg = this.getRequestedFile(device, this.mBootImageFileName, buildInfo.getFile(this.mBootImageZipName), tmpDir);
        }
    }

    private String getCurrentSlot(ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        String queryOutput = this.executeFastbootCmd(device, "getvar", "current-slot");
        Pattern outputPattern = Pattern.compile("^current-slot: _?([ab])");
        Matcher matcher = outputPattern.matcher(queryOutput);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private File getRequestedFile(ITestDevice device, String requestedFileName, File sourceFile, File tmpDir) throws TargetSetupError {
        File requestedFile = null;
        if (sourceFile.getName().endsWith(".zip")) {
            try {
                File destDir = FileUtil.createTempDir(FileUtil.getBaseName(sourceFile.getName()), tmpDir);
                ZipUtil2.extractZip(sourceFile, destDir);
                requestedFile = FileUtil.findFile(destDir, requestedFileName);
            }
            catch (IOException e) {
                throw new TargetSetupError(String.format("Fail to get %s from %s", requestedFileName, sourceFile), (Throwable)e, device.getDeviceDescriptor());
            }
        } else {
            requestedFile = sourceFile.isDirectory() ? FileUtil.findFile(sourceFile, requestedFileName) : sourceFile;
        }
        if (requestedFile == null || !requestedFile.exists()) {
            throw new TargetSetupError(String.format("Requested file with file_name %s does not exist in provided %s.", requestedFileName, sourceFile), device.getDeviceDescriptor());
        }
        return requestedFile;
    }

    private String executeFastbootCmd(ITestDevice device, String ... cmdArgs) throws DeviceNotAvailableException, TargetSetupError {
        LogUtil.CLog.i("Execute fastboot command %s on %s", Arrays.toString(cmdArgs), device.getSerialNumber());
        CommandResult result = device.executeLongFastbootCommand(cmdArgs);
        LogUtil.CLog.v("fastboot stdout: " + result.getStdout());
        LogUtil.CLog.v("fastboot stderr: " + result.getStderr());
        CommandStatus cmdStatus = result.getStatus();
        if (result.getStderr().contains("FAILED")) {
            cmdStatus = CommandStatus.FAILED;
        }
        if (cmdStatus != CommandStatus.SUCCESS) {
            throw new TargetSetupError(String.format("fastboot command %s failed in device %s. stdout: %s, stderr: %s", Arrays.toString(cmdArgs), device.getSerialNumber(), result.getStdout(), result.getStderr()), device.getDeviceDescriptor());
        }
        if (!result.getStderr().isEmpty()) {
            return result.getStderr();
        }
        return result.getStdout();
    }
}

