/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.suite.SuiteApkInstaller;
import com.android.tradefed.util.AaptParser;
import com.android.tradefed.util.BundletoolUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@OptionClass(alias="mainline-module-installer")
public class InstallApexModuleTargetPreparer
extends SuiteApkInstaller {
    private static final String APEX_DATA_DIR = "/data/apex/active/";
    private static final String STAGING_DATA_DIR = "/data/app-staging/";
    private static final String SESSION_DATA_DIR = "/data/apex/sessions/";
    private static final String MODULE_PUSH_REMOTE_PATH = "/data/local/tmp/";
    private static final String TRAIN_WITH_APEX_INSTALL_OPTION = "install-multi-package";
    private static final String ENABLE_ROLLBACK_INSTALL_OPTION = "--enable-rollback";
    private static final String STAGED_INSTALL_OPTION = "--staged";
    private static final String ACTIVATED_APEX_SOURCEDIR_PREFIX = "data";
    private static final int R_SDK_INT = 30;
    private static final Pattern PACKAGE_REGEX = Pattern.compile("package:(.*)");
    private static final String MODULE_VERSION_PROP_SUFFIX = "_version_used";
    protected static final String APEX_SUFFIX = ".apex";
    protected static final String APK_SUFFIX = ".apk";
    protected static final String SPLIT_APKS_SUFFIX = ".apks";
    protected static final String PARENT_SESSION_CREATION_CMD = "pm install-create --multi-package";
    protected static final String CHILD_SESSION_CREATION_CMD = "pm install-create";
    protected static final String APEX_OPTION = "--apex";
    protected static final String APK_ZIP_OPTION = "--apks-zip";
    private static final ImmutableList<String> PACKAGES_WITH_INVALID_DUMP_INFO = ImmutableList.of("com.google.mainline.primary.libs");
    private static final String STAGED_READY_TIMEOUT_OPTION = "--staged-ready-timeout";
    private static final String TIMEOUT_MILLIS_OPTION = "--timeout-millis=";
    private List<ITestDevice.ApexInfo> mTestApexInfoList = new ArrayList<ITestDevice.ApexInfo>();
    private List<String> mApexModulesToUninstall = new ArrayList<String>();
    private List<String> mApkModulesToUninstall = new ArrayList<String>();
    private Set<String> mMainlineModuleInfos = new HashSet<String>();
    private Set<String> mApkToInstall = new LinkedHashSet<String>();
    private List<String> mApkInstalled = new ArrayList<String>();
    private List<String> mSplitsInstallArgs = new ArrayList<String>();
    private BundletoolUtil mBundletoolUtil;
    private String mDeviceSpecFilePath = "";
    private boolean mOptimizeMainlineTest = false;
    @Option(name="bundletool-file-name", description="The file name of the bundletool jar.")
    private String mBundletoolFilename;
    @Option(name="train-path", description="The absolute path of the train folder.")
    protected File mTrainFolderPath;
    @Option(name="apex-staging-wait-time", description="The time in ms to wait for apex staged session ready.", isTimeVal=true)
    private long mApexStagingWaitTime = 0L;
    @Option(name="apex-rollback-wait-time", description="The time in ms to wait for apex rollback success.", isTimeVal=true)
    private long mApexRollbackWaitTime = 60000L;
    @Option(name="extra-booting-wait-time", description="The extra time in ms to wait for device ready.", isTimeVal=true)
    private long mExtraBootingWaitTime = 0L;
    @Option(name="ignore-if-module-not-preloaded", description="Skip installing the module(s) when the module(s) that are not preloaded on device. Otherwise an exception will be thrown.")
    private boolean mIgnoreIfNotPreloaded = false;
    @Option(name="skip-apex-teardown", description="Skip teardown if all files to be installed are apex files. Currently, this option is only used for Test Mapping use case.")
    private boolean mSkipApexTearDown = false;
    @Option(name="enable-rollback", description="Add the '--enable-rollback' flag when installing modules.")
    private boolean mEnableRollback = true;
    @Option(name="apks-zip-file-name", description="Install modules from apk zip file. Accepts a single file.")
    private String mApksZipFileName = null;
    @Option(name="staged-ready-timeout-ms", description="Time option in millis to wait for session stage. It will be passed to --staged-ready-timeout for adb install-multi-package and --timeout-millis for bundletool install-apks.")
    private long mStagedReadyTimeoutMs = 0L;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        List<File> moduleFileNames;
        this.setTestInformation(testInfo);
        ITestDevice device = testInfo.getDevice();
        if (this.mTrainFolderPath != null) {
            this.addApksToTestFiles();
        }
        if ((moduleFileNames = this.getTestsFileName()).isEmpty() && Strings.isNullOrEmpty(this.mApksZipFileName)) {
            LogUtil.CLog.i("No apk/apex module file to install. Skipping.");
            return;
        }
        if (!this.mSkipApexTearDown) {
            this.cleanUpStagedAndActiveSession(device);
        } else {
            this.mOptimizeMainlineTest = true;
        }
        Set<ITestDevice.ApexInfo> activatedApexes = device.getActiveApexes();
        LogUtil.CLog.i("Activated apex packages list before module/train installation:");
        for (ITestDevice.ApexInfo apexInfo : activatedApexes) {
            LogUtil.CLog.i("Activated apex: %s", apexInfo.toString());
        }
        if (!Strings.isNullOrEmpty(this.mApksZipFileName)) {
            LogUtil.CLog.i("Installing modules using apks zip %s", this.mApksZipFileName);
            this.installModulesFromZipUsingBundletool(testInfo, this.mApksZipFileName);
            this.activateStagedInstall(device);
            LogUtil.CLog.i("Required modules are installed from zip");
            return;
        }
        List<File> testAppFiles = this.getModulesToInstall(testInfo);
        if (testAppFiles.isEmpty()) {
            LogUtil.CLog.i("No modules are preloaded on the device, so no modules will be installed.");
            return;
        }
        if (this.mOptimizeMainlineTest) {
            LogUtil.CLog.i("Optimizing modules that are already activated in the previous test.");
            testAppFiles = this.optimizeModuleInstallation(activatedApexes, testAppFiles, device);
            if (testAppFiles.isEmpty()) {
                if (!this.mApexModulesToUninstall.isEmpty() || !this.mApkModulesToUninstall.isEmpty()) {
                    this.activateStagedInstall(device);
                }
                LogUtil.CLog.i("All required modules are installed");
                return;
            }
        }
        if (!this.mOptimizeMainlineTest && !this.containsApks(testAppFiles)) {
            for (File f : testAppFiles) {
                ITestDevice.ApexInfo apexInfo = this.retrieveApexInfo(f, testInfo.getDevice().getDeviceDescriptor());
                testInfo.getBuildInfo().addBuildAttribute(apexInfo.name + MODULE_VERSION_PROP_SUFFIX, String.valueOf(apexInfo.versionCode));
            }
        }
        if (this.containsApks(testAppFiles)) {
            this.installUsingBundleTool(testInfo, testAppFiles);
        } else {
            Map<File, String> map = this.resolveApkFiles(testInfo, testAppFiles);
            LogUtil.CLog.i("Staging install for " + map);
            this.installer(testInfo, map);
        }
        this.activateStagedInstall(device);
        if (!this.mTestApexInfoList.isEmpty()) {
            this.checkApexActivation(device);
        }
        LogUtil.CLog.i("Train activation succeed.");
    }

    private void activateStagedInstall(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mApexStagingWaitTime > 0L && device.getApiLevel() == 29) {
            RunUtil.getDefault().sleep(this.mApexStagingWaitTime);
        }
        device.reboot();
        if (this.mExtraBootingWaitTime > 0L) {
            RunUtil.getDefault().sleep(this.mExtraBootingWaitTime);
            device.waitForDeviceAvailable();
            device.postBootSetup();
        }
    }

    protected void checkApexActivation(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        Set<ITestDevice.ApexInfo> activatedApexes = device.getActiveApexes();
        if (activatedApexes.isEmpty()) {
            throw new TargetSetupError(String.format("Failed to retrieve activated apex on device %s. Empty set returned.", device.getSerialNumber()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        LogUtil.CLog.i("Activated apex packages list after module/train installation:");
        for (ITestDevice.ApexInfo info : activatedApexes) {
            LogUtil.CLog.i("Activated apex: %s", info.toString());
        }
        List<ITestDevice.ApexInfo> failToActivateApex = this.getModulesFailToActivate(activatedApexes);
        if (!failToActivateApex.isEmpty()) {
            throw new TargetSetupError(String.format("Failed to activate %s on device %s.", this.listApexInfo(failToActivateApex).toString(), device.getSerialNumber()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.FAIL_ACTIVATE_APEX);
        }
        LogUtil.CLog.i("Train activation succeed.");
    }

    private List<File> optimizeModuleInstallation(Set<ITestDevice.ApexInfo> activatedApex, List<File> testFiles, ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        Set<String> apexInData = this.getApexInData(activatedApex);
        Set<String> apkModuleInData = this.getApkModuleInData(activatedApex, device);
        this.mApexModulesToUninstall.addAll(this.getModulesToUninstall(apexInData, testFiles, device));
        this.mApkModulesToUninstall.addAll(this.getModulesToUninstall(apkModuleInData, testFiles, device));
        for (String m : this.mApexModulesToUninstall) {
            LogUtil.CLog.i("Uninstalling apex module: %s", m);
            this.uninstallPackage(device, m);
        }
        for (String packageName : this.mApkModulesToUninstall) {
            LogUtil.CLog.i("Uninstalling apk module: %s", packageName);
            this.uninstallPackage(device, packageName);
        }
        return testFiles;
    }

    Set<String> getModulesToUninstall(Set<String> modulesInData, List<File> testFiles, ITestDevice device) throws TargetSetupError {
        HashSet<String> unInstallModules = new HashSet<String>(modulesInData);
        ArrayList<File> filesToSkipInstall = new ArrayList<File>();
        for (File testFile : testFiles) {
            String packageName = this.parsePackageName(testFile);
            for (String moduleInData : modulesInData) {
                if (!moduleInData.equals(packageName)) continue;
                unInstallModules.remove(moduleInData);
                filesToSkipInstall.add(testFile);
            }
        }
        testFiles.removeAll(filesToSkipInstall);
        return unInstallModules;
    }

    Set<String> getApexInData(Set<ITestDevice.ApexInfo> activatedApexes) {
        HashSet<String> apexInData = new HashSet<String>();
        for (ITestDevice.ApexInfo apex : activatedApexes) {
            if (!apex.sourceDir.startsWith(APEX_DATA_DIR, 0) && !apex.sourceDir.startsWith(STAGING_DATA_DIR, 0) && !apex.sourceDir.startsWith(SESSION_DATA_DIR, 0)) continue;
            apexInData.add(apex.name);
        }
        return apexInData;
    }

    Set<String> getApkModules(Set<String> moduleInfos, Set<ITestDevice.ApexInfo> activatedApexes) {
        HashSet<String> apexModules = new HashSet<String>();
        for (ITestDevice.ApexInfo apex : activatedApexes) {
            apexModules.add(apex.name);
        }
        moduleInfos.removeAll(apexModules);
        return moduleInfos;
    }

    Set<String> getApkModuleInData(Set<ITestDevice.ApexInfo> activatedApexes, ITestDevice device) throws DeviceNotAvailableException {
        HashSet<String> apkModuleInData = new HashSet<String>();
        try {
            this.mMainlineModuleInfos = device.getMainlineModuleInfo();
        }
        catch (UnsupportedOperationException usoe) {
            LogUtil.CLog.e("Failed to query modules based on the MODULE_METADATA on the device - unsupported operation, returning an empty list of apk modules.");
            return apkModuleInData;
        }
        Set<String> apkModules = this.getApkModules(this.mMainlineModuleInfos, activatedApexes);
        for (String apkModule : apkModules) {
            String output = device.executeShellCommand(String.format("pm path %s", apkModule));
            if (output == null) continue;
            Matcher m = PACKAGE_REGEX.matcher(output);
            while (m.find()) {
                String packageName = m.group(1);
                LogUtil.CLog.i("Activates apk module: %s, path: %s", apkModule, packageName);
                if (!packageName.startsWith("/data/app/")) continue;
                apkModuleInData.add(apkModule);
            }
        }
        return apkModuleInData;
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (this.mOptimizeMainlineTest) {
            if (!this.mApkInstalled.isEmpty() && this.mMainlineModuleInfos.isEmpty()) {
                LogUtil.CLog.d("Proceeding tearDown as no MODULE METADATA existing on the device.");
            } else {
                LogUtil.CLog.d("Skipping tearDown as the installed modules may be used for the next test.");
                return;
            }
        }
        ITestDevice device = testInfo.getDevice();
        if (e instanceof DeviceNotAvailableException) {
            LogUtil.CLog.e("Device %s is not available. Teardown() skipped.", device.getSerialNumber());
            return;
        }
        if (this.mTestApexInfoList.isEmpty() && this.getApkInstalled().isEmpty()) {
            super.tearDown(testInfo, e);
        } else if (this.mTestApexInfoList.isEmpty()) {
            for (String apkPkgName : this.getApkInstalled()) {
                this.uninstallPackage(device, apkPkgName);
            }
        } else {
            Iterator<ITestDevice.ApexInfo> iterator2 = this.mTestApexInfoList.iterator();
            if (iterator2.hasNext()) {
                ITestDevice.ApexInfo apex = iterator2.next();
                String output = device.executeShellCommand(String.format("pm rollback-app %s", apex.name));
                if (!output.contains("Success")) {
                    throw new HarnessRuntimeException(String.format("Failed to rollback %s, Output: %s", apex.name, output), DeviceErrorIdentifier.APEX_ROLLBACK_FAILED);
                }
            }
            LogUtil.CLog.i("Wait for rollback fully done.");
            RunUtil.getDefault().sleep(this.mApexRollbackWaitTime);
            LogUtil.CLog.i("Clean up staged and active session for mainline test mapping.");
            this.cleanUpStagedAndActiveSession(device);
        }
    }

    private File resolveFilePath(TestInformation testInfo, String path, String notFoundMessage) throws TargetSetupError {
        File f = new File(path);
        File resolvedFile = !f.isAbsolute() ? this.getLocalPathForFilename(testInfo, path) : f;
        if (resolvedFile == null) {
            throw new TargetSetupError(String.format(notFoundMessage, new Object[0]), testInfo.getDevice().getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
        }
        return resolvedFile;
    }

    protected void initBundletoolUtil(TestInformation testInfo) throws TargetSetupError {
        if (this.mBundletoolUtil != null) {
            return;
        }
        this.mBundletoolUtil = new BundletoolUtil(this.resolveFilePath(testInfo, this.getBundletoolFileName(), String.format("Failed to find bundletool jar %s.", this.getBundletoolFileName())));
    }

    private void initDeviceSpecFilePath(ITestDevice device) throws TargetSetupError {
        if (!"".equals(this.mDeviceSpecFilePath)) {
            return;
        }
        try {
            this.mDeviceSpecFilePath = Strings.nullToEmpty(this.getBundletoolUtil().generateDeviceSpecFile(device));
        }
        catch (IOException e) {
            throw new TargetSetupError(String.format("Failed to generate device spec file on %s.", device.getSerialNumber()), (Throwable)e, device.getDeviceDescriptor());
        }
    }

    protected List<File> getSplitsForApks(TestInformation testInfo, File moduleFile) throws TargetSetupError {
        this.initBundletoolUtil(testInfo);
        this.initDeviceSpecFilePath(testInfo.getDevice());
        File splitsDir = this.getBundletoolUtil().extractSplitsFromApks(moduleFile, this.mDeviceSpecFilePath, testInfo.getDevice(), testInfo.getBuildInfo());
        if (splitsDir == null || splitsDir.listFiles() == null) {
            return null;
        }
        return Arrays.asList(splitsDir.listFiles());
    }

    public List<File> getModulesToInstall(TestInformation testInfo) throws DeviceNotAvailableException, TargetSetupError {
        ITestDevice device = testInfo.getDevice();
        HashSet<String> installedPackages = new HashSet<String>(device.getInstalledPackageNames());
        HashSet<ITestDevice.ApexInfo> installedApexes = new HashSet<ITestDevice.ApexInfo>(device.getActiveApexes());
        for (ITestDevice.ApexInfo installedApex : installedApexes) {
            installedPackages.add(installedApex.name);
        }
        HashSet<String> trainInstalledPackages = new HashSet<String>();
        List<File> moduleFileNames = this.getTestsFileName();
        ArrayList<File> moduleNamesToInstall = new ArrayList<File>();
        for (File moduleFileName : moduleFileNames) {
            File moduleFile = moduleFileName;
            if (!moduleFile.isAbsolute()) {
                moduleFile = this.getLocalPathForFilename(testInfo, moduleFileName.getName());
            }
            String modulePackageName = "";
            if (moduleFile.getName().endsWith(SPLIT_APKS_SUFFIX)) {
                List<File> splits = this.getSplitsForApks(testInfo, moduleFile);
                if (splits == null) {
                    LogUtil.CLog.w("Apks %s is not available on device %s and will not be installed.", moduleFileName, this.mDeviceSpecFilePath);
                    continue;
                }
                modulePackageName = this.parsePackageName(splits.get(0));
            } else {
                modulePackageName = this.parsePackageName(moduleFile);
            }
            if (installedPackages.contains(modulePackageName)) {
                LogUtil.CLog.i("Found preloaded module for %s.", modulePackageName);
                moduleNamesToInstall.add(moduleFile);
                if (trainInstalledPackages.contains(modulePackageName)) {
                    throw new TargetSetupError(String.format("Mainline module %s is listed for install more than once.", modulePackageName), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                }
                trainInstalledPackages.add(modulePackageName);
                continue;
            }
            if (!this.mIgnoreIfNotPreloaded) {
                LogUtil.CLog.i("The following modules are preloaded on the device %s", installedPackages);
                throw new TargetSetupError(String.format("Mainline module %s is not preloaded on the device but is in the input lists.", modulePackageName), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            LogUtil.CLog.i("The module package %s is not preloaded on the device but is included in the train.", modulePackageName);
        }
        HashSet<String> nonTrainPackages = new HashSet<String>(installedPackages);
        nonTrainPackages.removeAll(trainInstalledPackages);
        if (!nonTrainPackages.isEmpty()) {
            LogUtil.CLog.i("The following modules are preloaded on the device, but not included in the train: %s", nonTrainPackages);
        }
        return moduleNamesToInstall;
    }

    @Override
    protected void installer(TestInformation testInfo, Map<File, String> testAppFileNames) throws TargetSetupError, DeviceNotAvailableException {
        if (this.containsApex(testAppFileNames.keySet())) {
            this.mTestApexInfoList = this.collectApexInfoFromApexModules(testAppFileNames, testInfo);
        }
        this.installTrain(testInfo, new ArrayList<File>(testAppFileNames.keySet()));
    }

    protected void installTrain(TestInformation testInfo, List<File> moduleFilenames) throws TargetSetupError, DeviceNotAvailableException {
        CommandResult res;
        ITestDevice device = testInfo.getDevice();
        ArrayList<String> apkPackageNames = new ArrayList<String>();
        if (device.getApiLevel() == 29) {
            ArrayList<String> trainInstallCmd = new ArrayList<String>();
            trainInstallCmd.add(TRAIN_WITH_APEX_INSTALL_OPTION);
            trainInstallCmd.add(STAGED_INSTALL_OPTION);
            if (this.mEnableRollback) {
                trainInstallCmd.add(ENABLE_ROLLBACK_INSTALL_OPTION);
            }
            this.addStagedReadyTimeoutForAdb(trainInstallCmd);
            for (File moduleFile : moduleFilenames) {
                trainInstallCmd.add(moduleFile.getAbsolutePath());
                if (!moduleFile.getName().endsWith(APK_SUFFIX)) continue;
                String packageName = this.parsePackageName(moduleFile);
                apkPackageNames.add(packageName);
            }
            String log = device.executeAdbCommand(trainInstallCmd.toArray(new String[0]));
            if (log == null) {
                throw new TargetSetupError(((Object)trainInstallCmd).toString(), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.APK_INSTALLATION_FAILED);
            }
            if (this.mApexStagingWaitTime > 0L) {
                RunUtil.getDefault().sleep(this.mApexStagingWaitTime);
            }
            if (!log.contains("Success")) {
                throw new TargetSetupError(String.format("Failed to install %s on %s. Error log: '%s'", moduleFilenames.toString(), device.getSerialNumber(), log), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.APK_INSTALLATION_FAILED);
            }
            LogUtil.CLog.d("Train is staged successfully. Cmd: %s, Output: %s.", ((Object)trainInstallCmd).toString(), log);
            this.mApkInstalled.addAll(apkPackageNames);
            return;
        }
        for (File moduleFile : moduleFilenames) {
            if (!device.pushFile(moduleFile, MODULE_PUSH_REMOTE_PATH + moduleFile.getName())) {
                throw new TargetSetupError(String.format("Failed to push local '%s' to remote '%s'", moduleFile.getAbsolutePath(), MODULE_PUSH_REMOTE_PATH + moduleFile.getName()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.FAIL_PUSH_FILE);
            }
            LogUtil.CLog.d("%s pushed successfully to %s.", moduleFile.getName(), MODULE_PUSH_REMOTE_PATH + moduleFile.getName());
            if (!moduleFile.getName().endsWith(APK_SUFFIX)) continue;
            String packageName = this.parsePackageName(moduleFile);
            apkPackageNames.add(packageName);
        }
        String cmd = "pm install-create --multi-package --staged";
        if (this.mEnableRollback) {
            cmd = cmd + " --enable-rollback";
        }
        if ((res = device.executeShellV2Command(cmd + " | egrep -o -e '[0-9]+'")).getStatus() != CommandStatus.SUCCESS) {
            throw new TargetSetupError(String.format("Failed to create parent session. Error: %s, Stdout: %s", res.getStderr(), res.getStdout()), device.getDeviceDescriptor());
        }
        String parentSessionId = res.getStdout();
        LogUtil.CLog.d("Parent session %s created successfully. ", parentSessionId);
        for (File moduleFile : moduleFilenames) {
            String childSessionId = null;
            res = moduleFile.getName().endsWith(APEX_SUFFIX) ? (this.mEnableRollback ? device.executeShellV2Command(String.format("%s %s %s %s | egrep -o -e '[0-9]+'", CHILD_SESSION_CREATION_CMD, APEX_OPTION, STAGED_INSTALL_OPTION, ENABLE_ROLLBACK_INSTALL_OPTION)) : device.executeShellV2Command(String.format("%s %s %s | egrep -o -e '[0-9]+'", CHILD_SESSION_CREATION_CMD, APEX_OPTION, STAGED_INSTALL_OPTION))) : (this.mEnableRollback ? device.executeShellV2Command(String.format("%s %s %s | egrep -o -e '[0-9]+'", CHILD_SESSION_CREATION_CMD, STAGED_INSTALL_OPTION, ENABLE_ROLLBACK_INSTALL_OPTION)) : device.executeShellV2Command(String.format("%s %s | egrep -o -e '[0-9]+'", CHILD_SESSION_CREATION_CMD, STAGED_INSTALL_OPTION)));
            if (res.getStatus() != CommandStatus.SUCCESS) {
                throw new TargetSetupError(String.format("Failed to create child session for %s. Error: %s, Stdout: %s", moduleFile.getName(), res.getStderr(), res.getStdout()), device.getDeviceDescriptor());
            }
            childSessionId = res.getStdout();
            LogUtil.CLog.d("Child session %s created successfully for %s. ", childSessionId, moduleFile.getName());
            res = device.executeShellV2Command(String.format("pm install-write -S %d %s %s %s", moduleFile.length(), childSessionId, this.parsePackageName(moduleFile), MODULE_PUSH_REMOTE_PATH + moduleFile.getName()));
            if (res.getStatus() != CommandStatus.SUCCESS) {
                throw new TargetSetupError(String.format("Failed to write %s to session %s. Error: %s, Stdout: %s", moduleFile.getName(), childSessionId, res.getStderr(), res.getStdout()), device.getDeviceDescriptor());
            }
            LogUtil.CLog.d("Successfully wrote %s to session %s. ", moduleFile.getName(), childSessionId);
            res = device.executeShellV2Command(String.format("pm install-add-session " + parentSessionId + " " + childSessionId, new Object[0]));
            if (res.getStatus() == CommandStatus.SUCCESS) continue;
            throw new TargetSetupError(String.format("Failed to add child session %s to parent session %s. Error: %s, Stdout: %s", childSessionId, parentSessionId, res.getStderr(), res.getStdout()), device.getDeviceDescriptor());
        }
        res = device.executeShellV2Command("pm install-commit " + parentSessionId);
        if (res.getStatus() != CommandStatus.SUCCESS) {
            throw new TargetSetupError(String.format("Failed to commit %s on %s. Error: %s, Output: %s", parentSessionId, device.getSerialNumber(), res.getStderr(), res.getStdout()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.APK_INSTALLATION_FAILED);
        }
        LogUtil.CLog.d("Train is staged successfully. Stdout: %s.", res.getStdout());
        this.mApkInstalled.addAll(apkPackageNames);
    }

    protected void installUsingBundleTool(TestInformation testInfo, List<File> testAppFileNames) throws TargetSetupError, DeviceNotAvailableException {
        this.initBundletoolUtil(testInfo);
        this.initDeviceSpecFilePath(testInfo.getDevice());
        if (testAppFileNames.size() == 1) {
            this.installSingleModuleUsingBundletool(testInfo, this.mDeviceSpecFilePath, testAppFileNames.get(0));
        } else {
            this.installMultipleModuleUsingBundletool(testInfo, this.mDeviceSpecFilePath, testAppFileNames);
        }
        this.mApkInstalled.addAll(this.mApkToInstall);
    }

    private void installSingleModuleUsingBundletool(TestInformation testInfo, String deviceSpecFilePath, File apkFile) throws TargetSetupError, DeviceNotAvailableException {
        File apks = apkFile;
        List<File> splits = this.getSplitsForApks(testInfo, apks);
        ITestDevice device = testInfo.getDevice();
        if (splits == null || splits.isEmpty()) {
            throw new TargetSetupError(String.format("Extraction for %s failed. No apk/apex is extracted.", apkFile), device.getDeviceDescriptor());
        }
        if (this.containsApex(splits)) {
            LinkedHashMap<File, String> appFilesAndPackages = new LinkedHashMap<File, String>();
            appFilesAndPackages.put(splits.get(0), this.parsePackageName(splits.get(0)));
            super.installer(testInfo, appFilesAndPackages);
            this.mTestApexInfoList = this.collectApexInfoFromApexModules(appFilesAndPackages, testInfo);
        } else {
            ArrayList<String> extraArgs = new ArrayList<String>();
            this.addTimeoutMillisForBundletool(extraArgs);
            this.getBundletoolUtil().installApks(apks, device, extraArgs);
            this.mApkToInstall.add(this.parsePackageName(splits.get(0)));
        }
    }

    private void installModulesFromZipUsingBundletool(TestInformation testInfo, String zipFilePath) throws TargetSetupError, DeviceNotAvailableException {
        this.initBundletoolUtil(testInfo);
        this.initDeviceSpecFilePath(testInfo.getDevice());
        File apksZipFile = this.resolveFilePath(testInfo, zipFilePath, String.format("Failed to find apks zip file %s", this.mApksZipFileName));
        ITestDevice device = testInfo.getDevice();
        ArrayList<String> extraOptions = new ArrayList<String>();
        extraOptions.add("--update-only");
        if (this.mEnableRollback) {
            extraOptions.add(ENABLE_ROLLBACK_INSTALL_OPTION);
        }
        this.addTimeoutMillisForBundletool(extraOptions);
        device.waitForDeviceAvailable();
        this.getBundletoolUtil().installApksFromZip(apksZipFile, device, extraOptions);
    }

    private void installMultipleModuleUsingBundletool(TestInformation testInfo, String deviceSpecFilePath, List<File> testAppFileNames) throws TargetSetupError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        for (File file2 : testAppFileNames) {
            File moduleFile = !file2.isAbsolute() ? this.getLocalPathForFilename(testInfo, file2.getName()) : file2;
            if (file2.getName().endsWith(SPLIT_APKS_SUFFIX)) {
                List<File> splits = this.getSplitsForApks(testInfo, moduleFile);
                String splitsArgs = this.createInstallArgsForSplit(splits, device);
                this.mSplitsInstallArgs.add(splitsArgs);
                continue;
            }
            if (file2.getName().endsWith(APEX_SUFFIX)) {
                ITestDevice.ApexInfo apexInfo = this.retrieveApexInfo(moduleFile, device.getDeviceDescriptor());
                this.mTestApexInfoList.add(apexInfo);
            } else {
                this.mApkToInstall.add(this.parsePackageName(moduleFile));
            }
            this.mSplitsInstallArgs.add(moduleFile.getAbsolutePath());
        }
        ArrayList<String> installCmd = new ArrayList<String>();
        installCmd.add(TRAIN_WITH_APEX_INSTALL_OPTION);
        if (this.mEnableRollback) {
            installCmd.add(ENABLE_ROLLBACK_INSTALL_OPTION);
        }
        this.addStagedReadyTimeoutForAdb(installCmd);
        for (String arg : this.mSplitsInstallArgs) {
            installCmd.add(arg);
        }
        device.waitForDeviceAvailable();
        String string = device.executeAdbCommand(installCmd.toArray(new String[0]));
        if (!string.contains("Success")) {
            throw new TargetSetupError(String.format("Failed to stage train on device %s. Cmd is: %s. Error log: %s.", device.getSerialNumber(), ((Object)installCmd).toString(), string), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.FAIL_ACTIVATE_APEX);
        }
        LogUtil.CLog.d("Train is staged successfully. Output: %s.", string);
    }

    @VisibleForTesting
    protected ITestDevice.ApexInfo retrieveApexInfo(File testApexFile, DeviceDescriptor deviceDescriptor) throws TargetSetupError {
        AaptParser parser = AaptParser.parse(testApexFile);
        if (parser == null) {
            throw new TargetSetupError("apex installed but AaptParser failed", deviceDescriptor, (ErrorIdentifier)DeviceErrorIdentifier.AAPT_PARSER_FAILED);
        }
        return new ITestDevice.ApexInfo(parser.getPackageName(), Long.parseLong(parser.getVersionCode()));
    }

    protected String getModuleKeywordFromApexPackageName(String packageName) {
        String[] components = packageName.split("\\.");
        return components[components.length - 1];
    }

    private ArrayList<String> listApexInfo(List<ITestDevice.ApexInfo> list2) {
        ArrayList<String> res = new ArrayList<String>();
        for (ITestDevice.ApexInfo testApexInfo : list2) {
            res.add(testApexInfo.toString());
        }
        return res;
    }

    private boolean isApex(File file2) {
        return file2.getName().endsWith(APEX_SUFFIX);
    }

    private boolean containsApex(Collection<File> testFileNames) {
        for (File filename : testFileNames) {
            if (!filename.getName().endsWith(APEX_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    private boolean containsApks(List<File> testFileNames) {
        for (File filename : testFileNames) {
            if (!filename.getName().endsWith(SPLIT_APKS_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    private void cleanUpStagedAndActiveSession(ITestDevice device) throws DeviceNotAvailableException {
        boolean reboot = false;
        if (!this.mTestApexInfoList.isEmpty()) {
            device.deleteFile("/data/apex/active/*");
            device.deleteFile("/data/app-staging/*");
            device.deleteFile("/data/apex/sessions/*");
            reboot = true;
        } else {
            if (!device.executeShellV2Command("ls /data/apex/active/").getStdout().isEmpty()) {
                device.deleteFile("/data/apex/active/*");
                reboot = true;
            }
            if (!device.executeShellV2Command("ls /data/app-staging/").getStdout().isEmpty()) {
                device.deleteFile("/data/app-staging/*");
                reboot = true;
            }
            if (!device.executeShellV2Command("ls /data/apex/sessions/").getStdout().isEmpty()) {
                device.deleteFile("/data/apex/sessions/*");
                reboot = true;
            }
        }
        if (reboot) {
            LogUtil.CLog.i("Device Rebooting");
            device.reboot();
        }
    }

    private String createInstallArgsForSplit(List<File> splits, ITestDevice device) throws TargetSetupError {
        String splitsArgs = "";
        for (File f : splits) {
            if (f.getName().endsWith(APEX_SUFFIX)) {
                ITestDevice.ApexInfo apexInfo = this.retrieveApexInfo(f, device.getDeviceDescriptor());
                this.mTestApexInfoList.add(apexInfo);
            }
            if (f.getName().endsWith(APK_SUFFIX)) {
                this.mApkToInstall.add(this.parsePackageName(f));
            }
            if (!splitsArgs.isEmpty()) {
                splitsArgs = splitsArgs + ":" + f.getAbsolutePath();
                continue;
            }
            splitsArgs = splitsArgs + f.getAbsolutePath();
        }
        return splitsArgs;
    }

    protected List<ITestDevice.ApexInfo> collectApexInfoFromApexModules(Map<File, String> testAppFileNames, TestInformation testInfo) throws TargetSetupError {
        ArrayList<ITestDevice.ApexInfo> apexInfoList = new ArrayList<ITestDevice.ApexInfo>();
        for (File appFile : testAppFileNames.keySet()) {
            if (!this.isApex(appFile)) continue;
            ITestDevice.ApexInfo apexInfo = this.retrieveApexInfo(appFile, testInfo.getDevice().getDeviceDescriptor());
            apexInfoList.add(apexInfo);
        }
        return apexInfoList;
    }

    protected List<ITestDevice.ApexInfo> getModulesFailToActivate(Set<ITestDevice.ApexInfo> activatedApexes) throws DeviceNotAvailableException, TargetSetupError {
        ArrayList<ITestDevice.ApexInfo> failToActivateApex = new ArrayList<ITestDevice.ApexInfo>();
        HashMap<String, ITestDevice.ApexInfo> activatedApexInfo = new HashMap<String, ITestDevice.ApexInfo>();
        for (ITestDevice.ApexInfo info : activatedApexes) {
            activatedApexInfo.put(info.name, info);
        }
        for (ITestDevice.ApexInfo testApexInfo : this.mTestApexInfoList) {
            if (!activatedApexInfo.containsKey(testApexInfo.name)) {
                failToActivateApex.add(testApexInfo);
                continue;
            }
            if (PACKAGES_WITH_INVALID_DUMP_INFO.contains(testApexInfo.name)) continue;
            if (((ITestDevice.ApexInfo)activatedApexInfo.get((Object)testApexInfo.name)).versionCode != testApexInfo.versionCode) {
                failToActivateApex.add(testApexInfo);
                continue;
            }
            String sourceDir = ((ITestDevice.ApexInfo)activatedApexInfo.get((Object)testApexInfo.name)).sourceDir;
            if (!this.getDevice().checkApiLevelAgainstNextRelease(30) || sourceDir.startsWith(ACTIVATED_APEX_SOURCEDIR_PREFIX, 1)) continue;
            failToActivateApex.add(testApexInfo);
        }
        return failToActivateApex;
    }

    protected void addApksToTestFiles() {
        File[] filesUnderTrainFolder = this.mTrainFolderPath.listFiles();
        Arrays.sort(filesUnderTrainFolder, (a, b) -> a.getName().compareTo(b.getName()));
        for (File f : filesUnderTrainFolder) {
            if (!f.getName().endsWith(SPLIT_APKS_SUFFIX)) continue;
            this.getTestsFileName().add(f);
        }
    }

    @VisibleForTesting
    protected String getBundletoolFileName() {
        return this.mBundletoolFilename;
    }

    @VisibleForTesting
    protected BundletoolUtil getBundletoolUtil() {
        return this.mBundletoolUtil;
    }

    @VisibleForTesting
    protected List<String> getApkInstalled() {
        return this.mApkInstalled;
    }

    @VisibleForTesting
    public void setSkipApexTearDown(boolean skip) {
        this.mSkipApexTearDown = skip;
    }

    @VisibleForTesting
    public void setIgnoreIfNotPreloaded(boolean skip) {
        this.mIgnoreIfNotPreloaded = skip;
    }

    @VisibleForTesting
    protected void addStagedReadyTimeoutForAdb(List<String> cmd) {
        if (this.mStagedReadyTimeoutMs > 0L) {
            cmd.add(STAGED_READY_TIMEOUT_OPTION);
            cmd.add(Long.toString(this.mStagedReadyTimeoutMs));
        }
    }

    @VisibleForTesting
    protected void addTimeoutMillisForBundletool(List<String> extraArgs) {
        if (this.mStagedReadyTimeoutMs > 0L) {
            extraArgs.add(TIMEOUT_MILLIS_OPTION + this.mStagedReadyTimeoutMs);
        }
    }
}

