/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BaseEmulatorPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.RunUtil;
import java.time.Duration;
import java.util.List;

public class LocalEmulatorLaunch
extends BaseEmulatorPreparer {
    @Option(name="boot-timeout", description="maximum duration to wait for emulator to boot")
    private Duration mBootTimeout = Duration.ofSeconds(30L);

    @Override
    public void setUp(TestInformation testInformation) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice allocatedDevice = testInformation.getDevice();
        IDeviceManager manager = GlobalConfiguration.getDeviceManagerInstance();
        List<String> args = this.buildEmulatorLaunchArgs();
        args.add("-read-only");
        RunUtil runUtil = this.buildRunUtilForEmulatorLaunch();
        manager.launchEmulator(allocatedDevice, this.mBootTimeout.toMillis(), runUtil, args);
    }

    @Override
    public void tearDown(TestInformation testInformation, Throwable e) throws DeviceNotAvailableException {
    }
}

