/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ILabPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@OptionClass(alias="mix-kernel-target-preparer")
public class MixKernelTargetPreparer
extends BaseTargetPreparer
implements ILabPreparer,
IConfigurationReceiver {
    @Option(name="device-file-label", description="The label for the test device that stores device images.")
    private String mDeviceLabel = "device";
    @Option(name="kernel-file-label", description="The file key prefix that is attached to the kernel images,  for example {kernel}Image.gz.")
    private String mKernelLabel = "kernel";
    @Option(name="gki-file-label", description="The file key prefix that is attached the GKI images, for example {gki}Image.gz.")
    private String mGkiLabel = "gki";
    @Option(name="mix-kernel-tool-path", description="The file path of mix kernel tool. It can be the absolute path of the tool path, or the absolute directory path that contains the tool. It can be used with flexible download feature for example --mix-kernel-tool-path ab://git_master/flame-userdebug/LATEST/.*flame-tests-.*.zip?unzip=true")
    private File mMixKernelToolPath = null;
    @Option(name="mix-kernel-tool-name", description="The mixing kernel tool file name, defaulted to build_mixed_kernels. If mix-kernel-tool-path is a directory, the mix-kernel-tool-name will be used to locate the tool in the directory of mix-kernel-tool-path.")
    private String mMixKernelToolName = "build_mixed_kernels_ramdisk";
    @Option(name="mix-kernel-script-wait-time", description="The maximum wait time for mix kernel script. By default is 20 minutes. ")
    private Duration mMixingWaitTime = Duration.ofMinutes(20L);
    @Option(name="mix-kernel-arg", description="Additional arguments to be passed to mix-kernel-script command, including leading dash, e.g. \"--nocompress\"")
    private Collection<String> mMixKernelArgs = new ArrayList<String>();
    private IConfiguration mConfig;

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfig = configuration;
    }

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        File tmpDeviceDir = null;
        File tmpKernelDir = null;
        File tmpGkiDir = null;
        File tmpNewDeviceDir = null;
        try {
            this.findMixKernelTool(buildInfo);
            tmpDeviceDir = FileUtil.createTempDir("device_dir");
            tmpKernelDir = FileUtil.createTempDir("kernel_dir");
            tmpNewDeviceDir = FileUtil.createTempDir("new_device_dir");
            tmpGkiDir = FileUtil.createTempDir("gki_dir");
            for (String fileKey : buildInfo.getVersionedFileKeys()) {
                LogUtil.CLog.i("Processing file %s", fileKey);
                File srcFile = buildInfo.getFile(fileKey);
                if (fileKey.contains("{" + this.mKernelLabel + "}")) {
                    this.copyLabelFileToDir(fileKey, srcFile, tmpKernelDir);
                    continue;
                }
                if (fileKey.contains("{" + this.mGkiLabel + "}")) {
                    this.copyLabelFileToDir(fileKey, srcFile, tmpGkiDir);
                    continue;
                }
                if (fileKey.contains("{" + this.mDeviceLabel + "}")) {
                    this.copyLabelFileToDir(fileKey, srcFile, tmpDeviceDir);
                    continue;
                }
                if (!BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE.getFileKey().equals(fileKey)) continue;
                this.copyDeviceImageToDir(srcFile, tmpDeviceDir);
            }
            if (tmpDeviceDir.listFiles().length == 0) {
                throw new TargetSetupError("Could not find device images", device.getDeviceDescriptor());
            }
            if (tmpKernelDir.listFiles().length == 0) {
                throw new TargetSetupError("Could not find kernel images", device.getDeviceDescriptor());
            }
            LogUtil.CLog.i("running mixkernel tool from %s", this.mMixKernelToolPath);
            this.runMixKernelTool(device, tmpDeviceDir, tmpKernelDir, tmpGkiDir, tmpNewDeviceDir);
            this.setNewDeviceImage(buildInfo, tmpNewDeviceDir);
        }
        catch (IOException e) {
            try {
                throw new TargetSetupError("Could not mix device and kernel images", (Throwable)e, device.getDeviceDescriptor());
            }
            catch (Throwable throwable) {
                FileUtil.recursiveDelete(tmpDeviceDir);
                FileUtil.recursiveDelete(tmpKernelDir);
                FileUtil.recursiveDelete(tmpGkiDir);
                FileUtil.recursiveDelete(tmpNewDeviceDir);
                throw throwable;
            }
        }
        FileUtil.recursiveDelete(tmpDeviceDir);
        FileUtil.recursiveDelete(tmpKernelDir);
        FileUtil.recursiveDelete(tmpGkiDir);
        FileUtil.recursiveDelete(tmpNewDeviceDir);
    }

    @VisibleForTesting
    void copyDeviceImageToDir(File srcFile, File destDir) throws IOException {
        String srcFileName = srcFile.getName();
        String suffix = FileUtil.getExtension(srcFileName);
        String base = FileUtil.getBaseName(srcFileName);
        Pattern pattern = Pattern.compile(".*-img-\\d+");
        Matcher matcher = pattern.matcher(base);
        String newFileName = matcher.find() ? matcher.group() : new String("device-img-001");
        newFileName = !suffix.isEmpty() ? newFileName + suffix : newFileName + ".zip";
        File dstFile = new File(destDir, newFileName);
        LogUtil.CLog.i("Copy %s to %s", srcFile.toString(), dstFile.toString());
        FileUtil.hardlinkFile(srcFile, dstFile);
    }

    @VisibleForTesting
    void copyLabelFileToDir(String fileKey, File srcFile, File destDir) throws IOException {
        String newFileName = fileKey.replace("{zip}", ".zip").replaceAll("\\{\\w+\\}", "");
        File dstFile = new File(destDir, newFileName);
        LogUtil.CLog.i("Copy %s %s to %s", fileKey, srcFile.toString(), dstFile.toString());
        FileUtil.hardlinkFile(srcFile, dstFile);
    }

    private void findMixKernelTool(IBuildInfo buildInfo) throws TargetSetupError, IOException {
        if (this.mMixKernelToolPath == null) {
            LogUtil.CLog.i("File mix-kernel-tool-path is not configured. Use devices build's testsdir as the mix kernel tool path.");
            this.mMixKernelToolPath = buildInfo.getFile(BuildInfoKey.BuildInfoFileKey.TESTDIR_IMAGE.getFileKey());
            if (this.mMixKernelToolPath == null || !this.mMixKernelToolPath.isDirectory()) {
                throw new TargetSetupError(String.format("There is no %s to search for mix kernel tool. Please assign a test artifact with name %s and type TEST_PACKAGE", BuildInfoKey.BuildInfoFileKey.TESTDIR_IMAGE.getFileKey(), BuildInfoKey.BuildInfoFileKey.TESTDIR_IMAGE.getFileKey()), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
            }
        }
        if (this.mMixKernelToolPath.isDirectory()) {
            File mixKernelTool = FileUtil.findFile(this.mMixKernelToolPath, this.mMixKernelToolName);
            if (mixKernelTool == null || !mixKernelTool.exists()) {
                throw new TargetSetupError(String.format("Could not find the mix kernel tool %s from %s", this.mMixKernelToolName, this.mMixKernelToolPath), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
            }
            this.mMixKernelToolPath = mixKernelTool;
        }
        if (!this.mMixKernelToolPath.canExecute()) {
            FileUtil.chmodGroupRWX(this.mMixKernelToolPath);
        }
    }

    @VisibleForTesting
    void setNewDeviceImage(IBuildInfo buildInfo, File newDeviceDir) throws TargetSetupError, IOException {
        LogUtil.CLog.i("Before mixing kernel, the device image %s is of size %d", buildInfo.getFile(BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE.getFileKey()).toString(), buildInfo.getFile(BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE.getFileKey()).length());
        File newDeviceImage = FileUtil.findFile(newDeviceDir, ".*-img-.*.zip$");
        if (newDeviceImage == null || !newDeviceImage.exists()) {
            throw new TargetSetupError("Failed to get a new device image after mixing", (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        LogUtil.CLog.i("Successfully generated new device image %s of size %d", newDeviceImage, newDeviceImage.length());
        String deviceImagePath = buildInfo.getFile(BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE).getAbsolutePath();
        buildInfo.getFile(BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE.getFileKey()).delete();
        FileUtil.hardlinkFile(newDeviceImage, new File(deviceImagePath));
        try {
            this.mConfig.injectOptionValue("incremental-flashing", "false");
            this.mConfig.injectOptionValue("force-disable-incremental-flashing", "false");
        }
        catch (ConfigurationException ignore) {
            LogUtil.CLog.e(ignore);
        }
        LogUtil.CLog.i("After mixing kernel, the device image %s is of size %d", buildInfo.getFile(BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE.getFileKey()).toString(), buildInfo.getFile(BuildInfoKey.BuildInfoFileKey.DEVICE_IMAGE.getFileKey()).length());
    }

    protected void runMixKernelTool(ITestDevice device, File oldDeviceDir, File kernelDir, File gkiDir, File newDeviceDir) throws TargetSetupError {
        List<String> cmd = ArrayUtil.list(this.mMixKernelToolPath.getAbsolutePath());
        cmd.addAll(this.mMixKernelArgs);
        if (gkiDir.listFiles().length > 0) {
            cmd.add("--gki_dir");
            cmd.add(gkiDir.toString());
        }
        cmd.add(oldDeviceDir.toString());
        cmd.add(kernelDir.toString());
        cmd.add(newDeviceDir.toString());
        LogUtil.CLog.i("Run %s to mix kernel and device build", this.mMixKernelToolPath.toString());
        CommandResult result = RunUtil.getDefault().runTimedCmd(this.mMixingWaitTime.toMillis(), cmd.toArray(new String[cmd.size()]));
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            LogUtil.CLog.e("Failed to run mix kernel tool. Exit code: %s, stdout: %s, stderr: %s", new Object[]{result.getStatus(), result.getStdout(), result.getStderr()});
            throw new TargetSetupError("Failed to run mix kernel tool. Stderr: " + result.getStderr());
        }
        LogUtil.CLog.i("Successfully mixed kernel to new device image in %s with files %s", newDeviceDir.toString(), Arrays.toString(newDeviceDir.list()));
    }
}

