/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.error.HarnessException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.InstallApexModuleTargetPreparer;
import com.android.tradefed.targetprep.ModulePusher;
import com.android.tradefed.targetprep.TargetSetupError;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.HashSet;
import java.util.List;

@OptionClass(alias="mainline-oem-installer")
public class ModuleOemTargetPreparer
extends InstallApexModuleTargetPreparer {
    private static final long DELAY_WAITING_TIME = 2000L;
    @Option(name="reboot-wait-time-ms", description="Additional wait for device to be ready after reboot.")
    private static long mRebootWaitTimeMs = 300000L;
    @Option(name="recover-preload-modules", description="Recover the preload mainline modules.")
    private boolean mRecoverPreloadModules = false;
    @Option(name="push-test-modules", description="Push the test mainline modules.")
    private boolean mPushTestModules = true;
    @Option(name="reload-by-factory-reset", description="If reload apex modules by factory reset.")
    private boolean mReloadByFactoryReset = false;
    @Option(name="disable-package-cache", description="Disable the cache of package manager")
    private boolean mDisablePackageCache = false;
    @Option(name="recover-module-folder", description="The path to recover module folder. All packages should have their own subfolder whose name is the package name.")
    private File mRecoverModuleFolder;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        this.setTestInformation(testInfo);
        ITestDevice device = testInfo.getDevice();
        int apiLevel = device.getApiLevel();
        if (apiLevel < 29) {
            LogUtil.CLog.i("Skip the target preparer because the api level is %i andthe build doesn't have mainline modules", apiLevel);
            return;
        }
        ModulePusher pusher = this.getPusher(device);
        if (this.mRecoverPreloadModules && this.mRecoverModuleFolder != null) {
            ImmutableMultimap<String, File> files = this.getRecoverModules();
            if (files.isEmpty()) {
                LogUtil.CLog.i("No recover modules to install.");
                return;
            }
            ImmutableMultimap<String, File> recoverFiles = this.filterModulesToInstall(testInfo, files);
            this.recoverPreloadModules(pusher, recoverFiles, device.getDeviceDescriptor());
        }
        if (this.mPushTestModules) {
            List<File> testAppFiles;
            if (this.mTrainFolderPath != null) {
                this.addApksToTestFiles();
            }
            if ((testAppFiles = this.getModulesToInstall(testInfo)).isEmpty()) {
                LogUtil.CLog.i("No modules to install.");
                return;
            }
            this.installTestModules(testInfo, pusher, testAppFiles, device.getDeviceDescriptor());
        }
    }

    private ImmutableMultimap<String, File> getRecoverModules() throws TargetSetupError {
        File rootFolder = this.getRecoverModuleFolder();
        if (!rootFolder.exists() || !rootFolder.isDirectory()) {
            throw new TargetSetupError(String.format("%s is not a dir", rootFolder), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
        }
        ImmutableMultimap.Builder<String, File> builder = ImmutableMultimap.builder();
        for (File moduleFolder : rootFolder.listFiles()) {
            if (!moduleFolder.exists() || !moduleFolder.isDirectory()) {
                throw new TargetSetupError(String.format("%s is not a dir", moduleFolder), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
            }
            String packageName = moduleFolder.getName();
            LogUtil.CLog.i("Get modules files %s for the package %s", moduleFolder.listFiles(), packageName);
            builder.putAll(packageName, moduleFolder.listFiles());
        }
        return builder.build();
    }

    private File getRecoverModuleFolder() {
        return this.mRecoverModuleFolder;
    }

    private ImmutableMultimap<String, File> filterModulesToInstall(TestInformation testInfo, ImmutableMultimap<String, File> moduleFiles) throws DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        ImmutableSet<String> installedPackages = this.getPreloadPackageNames(device);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (String packageName : moduleFiles.keySet()) {
            if (installedPackages.contains(packageName)) {
                LogUtil.CLog.i("Found preloaded module for %s.", packageName);
                builder.putAll(packageName, moduleFiles.get((Object)packageName));
                continue;
            }
            LogUtil.CLog.i("The module package %s is not preloaded on the device but is included in the train.", packageName);
        }
        return builder.build();
    }

    private void recoverPreloadModules(ModulePusher pusher, ImmutableMultimap<String, File> moduleFiles, DeviceDescriptor deviceDescriptor) throws TargetSetupError {
        try {
            pusher.installModules(moduleFiles, this.mReloadByFactoryReset, this.mDisablePackageCache);
        }
        catch (HarnessException e) {
            throw new TargetSetupError("Failed to recover modules", (Throwable)e, deviceDescriptor);
        }
    }

    private void installTestModules(TestInformation testInfo, ModulePusher pusher, List<File> testAppFiles, DeviceDescriptor deviceDescriptor) throws TargetSetupError {
        ImmutableMultimap.Builder<String, File> builder = ImmutableMultimap.builder();
        for (File moduleFile : testAppFiles) {
            File[] toPush = new File[]{moduleFile};
            if (ModulePusher.hasExtension(".apks", moduleFile)) {
                toPush = this.getSplitsForApks(testInfo, moduleFile).toArray(new File[0]);
            }
            String packageName = this.parsePackageName(toPush[0]);
            builder.putAll(packageName, toPush);
        }
        try {
            pusher.installModules(builder.build(), this.mReloadByFactoryReset, this.mDisablePackageCache);
        }
        catch (HarnessException e) {
            throw new TargetSetupError("Failed to install modules", (Throwable)e, deviceDescriptor);
        }
    }

    private ImmutableSet<String> getPreloadPackageNames(ITestDevice device) throws DeviceNotAvailableException {
        HashSet<String> installedPackages = new HashSet<String>(device.getInstalledPackageNames());
        HashSet<ITestDevice.ApexInfo> installedApexes = new HashSet<ITestDevice.ApexInfo>(device.getActiveApexes());
        for (ITestDevice.ApexInfo installedApex : installedApexes) {
            installedPackages.add(installedApex.name);
        }
        return ImmutableSet.copyOf(installedPackages);
    }

    @VisibleForTesting
    ModulePusher getPusher(ITestDevice device) {
        return new ModulePusher(device, mRebootWaitTimeMs, 2000L);
    }
}

