/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.StreamUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="native-leak-collector")
public class NativeLeakCollector
extends BaseTargetPreparer
implements ITestLoggerReceiver {
    private static final String UNREACHABLE_MEMINFO_CMD = "dumpsys -t %d meminfo --unreachable -a";
    private static final String DIRECT_UNREACHABLE_CMD = "dumpsys -t %d %s --unreachable";
    private static final String OUTPUT_HEADER = "\nExecuted command: %s\n";
    private ITestLogger mTestLogger;
    @Option(name="dump-timeout", description="Timeout limit for dumping unreachable native memory allocation information. Can be in any valid duration format, e.g. 5m, 1h.", isTimeVal=true)
    private long mDumpTimeout = 300000L;
    @Option(name="log-filename", description="The filename to give this log.")
    private String mLogFilename = "unreachable-meminfo";
    @Option(name="additional-proc", description="A list indicating any additional names to query for unreachable native memory.")
    private List<String> mAdditionalProc = new ArrayList<String>();
    @Option(name="additional-dump-timeout", description="An additional timeout limit for any direct unreachable memory dump commands specified by the 'additional-procs' option. Can be in any valid duration format, e.g. 5m, 1h.", isTimeVal=true)
    private long mAdditionalDumpTimeout = 60000L;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (this.isDisabled() || e instanceof DeviceNotAvailableException) {
            return;
        }
        ITestDevice device = testInfo.getDevice();
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        String allCommand = String.format(UNREACHABLE_MEMINFO_CMD, this.mDumpTimeout / 1000L);
        this.writeToReceiver(String.format(OUTPUT_HEADER, allCommand), receiver);
        device.executeShellCommand(allCommand, receiver, this.mDumpTimeout, TimeUnit.MILLISECONDS, 1);
        for (String proc : this.mAdditionalProc) {
            String procCommand = String.format(DIRECT_UNREACHABLE_CMD, this.mAdditionalDumpTimeout / 1000L, proc);
            this.writeToReceiver(String.format(OUTPUT_HEADER, procCommand), receiver);
            device.executeShellCommand(procCommand, receiver, this.mAdditionalDumpTimeout, TimeUnit.MILLISECONDS, 1);
        }
        if (receiver.getOutput() != null && !receiver.getOutput().isEmpty()) {
            if (this.mTestLogger != null) {
                ByteArrayInputStreamSource byteOutput = new ByteArrayInputStreamSource(receiver.getOutput().getBytes());
                this.mTestLogger.testLog(this.mLogFilename, LogDataType.TEXT, byteOutput);
                StreamUtil.cancel(byteOutput);
            } else {
                LogUtil.CLog.w("No test logger available, printing output here:\n%s", receiver.getOutput());
            }
        }
    }

    private void writeToReceiver(String msg, CollectingOutputReceiver receiver) {
        byte[] msgBytes = msg.getBytes();
        int byteCount = msgBytes.length;
        receiver.addOutput(msgBytes, 0, byteCount);
    }

    @Override
    public void setTestLogger(ITestLogger testLogger) {
        this.mTestLogger = testLogger;
    }
}

