/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import java.io.File;

@OptionClass(alias="perfetto-preparer")
public class PerfettoPreparer
extends BaseTargetPreparer {
    private static final String DEVICE_CONFIG_PATH = "/data/misc/perfetto-traces/trace_config.pb";
    @Option(name="abort-on-failure", description="If false, continue if preparer fail.  If true, abort the invocation on any failure.")
    private boolean mAbortOnFailure = true;
    @Option(name="binary-perfetto-config", description="Full path to the binary version of perfetto config file.")
    private File mBinaryPerfettoConfigFile = null;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mBinaryPerfettoConfigFile != null) {
            ITestDevice device = testInfo.getDevice();
            if (!this.mBinaryPerfettoConfigFile.exists()) {
                this.fail("Failed to find the local binary perfetto file", null, device);
            } else if (!device.pushFile(this.mBinaryPerfettoConfigFile, DEVICE_CONFIG_PATH)) {
                this.fail("Failed to push the binary perfetto file", null, device);
            }
        }
    }

    private void fail(String message2, Throwable cause, ITestDevice device) throws TargetSetupError {
        if (this.mAbortOnFailure) {
            if (cause != null) {
                throw new TargetSetupError(message2, cause, device.getDeviceDescriptor());
            }
            throw new TargetSetupError(message2, device.getDeviceDescriptor());
        }
        LogUtil.CLog.w(message2);
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        testInfo.getDevice().executeShellCommand("rm /data/misc/perfetto-traces/trace_config.pb");
    }
}

