/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.UserInfo;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ProfileTargetPreparer
extends BaseTargetPreparer {
    @VisibleForTesting
    static final String RUN_TESTS_AS_USER_KEY = "RUN_TESTS_AS_USER";
    @VisibleForTesting
    static final String TEST_PACKAGE_NAME_OPTION = "test-package-name";
    @VisibleForTesting
    static final String SKIP_TESTS_REASON_KEY = "skip-tests-reason";
    private static final int USERTYPE_NOT_SUPPORTED = -2;
    private UserInfo.UserType mTradefedUserType;
    private String mProfileUserType;
    private int profileIdToDelete = -1;
    private DeviceOwner mDeviceOwnerToSet = null;
    @Option(name="test-package-name", description="the name of a package to be installed on the profile. This must already be installed on the device.", importance=Option.Importance.IF_UNSET)
    private List<String> mTestPackages = new ArrayList<String>();

    ProfileTargetPreparer(UserInfo.UserType userType, String actualType) {
        this.mTradefedUserType = userType;
        this.mProfileUserType = actualType;
    }

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, DeviceNotAvailableException {
        if (this.checkIfUserTypeIsNotSupported(testInfo)) {
            return;
        }
        int profileId = this.getExistingProfileId(testInfo.getDevice());
        if (profileId == -1) {
            if (!this.checkTrueOrSkipOnDevice(this.canCreateAdditionalUsers(testInfo.getDevice(), 1), "Device cannot support additional users", testInfo)) {
                return;
            }
            profileId = this.createProfile(testInfo);
            if (profileId == -2) {
                return;
            }
            this.profileIdToDelete = profileId;
        }
        testInfo.getDevice().startUser(profileId, testInfo.getDevice().getApiLevel() >= 29);
        for (String pkg : this.mTestPackages) {
            testInfo.getDevice().executeShellCommand("pm install-existing --user " + profileId + " " + pkg);
        }
        testInfo.properties().put(RUN_TESTS_AS_USER_KEY, Integer.toString(profileId));
    }

    private boolean checkIfUserTypeIsNotSupported(TestInformation testInfo) throws TargetSetupError, DeviceNotAvailableException {
        if (this.mTradefedUserType.isManagedProfile() && !this.requireFeatures(testInfo, "android.software.managed_users")) {
            return true;
        }
        return this.mTradefedUserType.isCloneProfile() && !this.matchesApiLevel(testInfo, 34);
    }

    private boolean matchesApiLevel(TestInformation testInfo, int apiLevel) throws DeviceNotAvailableException, TargetSetupError {
        return this.checkTrueOrSkipOnDevice(testInfo.getDevice().getApiLevel() >= apiLevel, "Device does not support feature as api level " + apiLevel + " requirement does not match", testInfo);
    }

    private int getExistingProfileId(ITestDevice device) throws DeviceNotAvailableException {
        for (Map.Entry<Integer, UserInfo> userInfo : device.getUserInfos().entrySet()) {
            if (!userInfo.getValue().isUserType(this.mTradefedUserType, -1)) continue;
            return userInfo.getKey();
        }
        return -1;
    }

    private int createProfile(TestInformation testInfo) throws DeviceNotAvailableException, TargetSetupError {
        String createUserOutput;
        ITestDevice device = testInfo.getDevice();
        int parentProfile = device.getCurrentUser();
        String command = "";
        if (!this.mTradefedUserType.isProfile()) {
            return -1;
        }
        command = "pm create-user --profileOf " + parentProfile + " --user-type " + this.mProfileUserType;
        if (device.getApiLevel() >= 34) {
            command = command + " --for-testing";
        }
        command = command + " user";
        if (this.mTradefedUserType.isCloneProfile() || this.mTradefedUserType.isManagedProfile()) {
            this.removeDeviceOwnerIfPresent(device);
        }
        if (!this.checkTrueOrSkipOnDevice(!(createUserOutput = device.executeShellCommand(command)).contains("Cannot add a user of disabled type"), "Device does not support " + this.mProfileUserType, testInfo)) {
            return -2;
        }
        try {
            return Integer.parseInt(createUserOutput.split(" id ")[1].trim());
        }
        catch (RuntimeException e) {
            throw ProfileTargetPreparer.commandError("Error creating profile", command, createUserOutput, e, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
        }
    }

    private void removeDeviceOwnerIfPresent(ITestDevice device) throws DeviceNotAvailableException {
        this.mDeviceOwnerToSet = this.getDeviceOwner(device);
        if (this.mDeviceOwnerToSet != null) {
            LogUtil.CLog.d((Object)((Object)this.mTradefedUserType) + " cannot be created after device owner is set. Attempting to remove device owner");
            this.removeDeviceOwner(device, this.mDeviceOwnerToSet);
        }
    }

    private DeviceOwner getDeviceOwner(ITestDevice device) throws DeviceNotAvailableException {
        String command = "dumpsys device_policy";
        String dumpsysOutput = device.executeShellCommand(command);
        if (dumpsysOutput == null || !dumpsysOutput.contains("Device Owner:")) {
            return null;
        }
        try {
            String deviceOwnerOnwards = dumpsysOutput.split("Device Owner:", 2)[1];
            String componentName = deviceOwnerOnwards.split("ComponentInfo\\{", 2)[1].split("}", 2)[0];
            int userId = Integer.parseInt(deviceOwnerOnwards.split("User ID: ", 2)[1].split("\n", 2)[0].trim());
            return new DeviceOwner(componentName, userId);
        }
        catch (RuntimeException e) {
            throw ProfileTargetPreparer.commandError("Error reading device owner information", command, dumpsysOutput, e, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
        }
    }

    private void removeDeviceOwner(ITestDevice device, DeviceOwner deviceOwner) throws DeviceNotAvailableException {
        String command = "dpm remove-active-admin --user " + deviceOwner.userId + " " + deviceOwner.componentName;
        String commandOutput = device.executeShellCommand(command);
        if (!commandOutput.startsWith("Success")) {
            throw ProfileTargetPreparer.commandError("Error removing device owner", command, commandOutput, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
        }
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        String value = testInfo.properties().remove(SKIP_TESTS_REASON_KEY);
        if (value != null) {
            return;
        }
        testInfo.properties().remove(RUN_TESTS_AS_USER_KEY);
        if (this.profileIdToDelete != -1) {
            testInfo.getDevice().removeUser(this.profileIdToDelete);
        }
        if (this.mDeviceOwnerToSet != null) {
            testInfo.getDevice().setDeviceOwner(this.mDeviceOwnerToSet.componentName, this.mDeviceOwnerToSet.userId);
        }
    }

    private boolean checkTrueOrSkipOnDevice(boolean value, String reason, TestInformation testInfo) throws TargetSetupError {
        if (!value) {
            testInfo.properties().put(SKIP_TESTS_REASON_KEY, reason.replace(" ", "\\ "));
        }
        return value;
    }

    private boolean requireFeatures(TestInformation testInfo, String ... features) throws TargetSetupError, DeviceNotAvailableException {
        for (String feature : features) {
            if (this.checkTrueOrSkipOnDevice(testInfo.getDevice().hasFeature(feature), "Device does not have feature " + feature, testInfo)) continue;
            return false;
        }
        return true;
    }

    protected boolean canCreateAdditionalUsers(ITestDevice device, int numberOfUsers) throws DeviceNotAvailableException {
        return device.listUsers().size() + numberOfUsers <= device.getMaxNumberOfUsersSupported();
    }

    private static RuntimeException commandError(String error, String command, String commandOutput, ErrorIdentifier errorIdentifier) {
        return ProfileTargetPreparer.commandError(error, command, commandOutput, null, errorIdentifier);
    }

    private static RuntimeException commandError(String error, String command, String commandOutput, Exception exception, ErrorIdentifier errorIdentifier) {
        return new HarnessRuntimeException(error + ". Command was '" + command + "', output was '" + commandOutput + "'", exception, errorIdentifier);
    }

    @VisibleForTesting
    void setProfileUserType(String userType) {
        this.mProfileUserType = userType;
    }

    @VisibleForTesting
    void setTradefedUserType(UserInfo.UserType tradefedUserType) {
        this.mTradefedUserType = tradefedUserType;
    }

    private static class DeviceOwner {
        final String componentName;
        final int userId;

        DeviceOwner(String componentName, int userId) {
            this.componentName = componentName;
            this.userId = userId;
        }
    }
}

