/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import java.io.File;

public class RecoveryLogPreparer
extends BaseTargetPreparer
implements ITestLoggerReceiver {
    private static final String RECOVERY_LOG_NAME = "recovery.log";
    private static final String RECOVERY_LOG = "/tmp/recovery.log";
    private ITestLogger mLogger;

    @Override
    public void setTestLogger(ITestLogger testLogger) {
        this.mLogger = testLogger;
    }

    @Override
    public void setUp(TestInformation testInformation) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInformation.getDevice();
        if (TestDeviceState.RECOVERY.equals((Object)device.getDeviceState())) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.AUTO_RECOVERY_MODE_COUNT, 1L);
            String outputRoot = device.executeAdbCommand("root");
            LogUtil.CLog.d("Root output: %s", outputRoot);
            File recoveryLog = device.pullFile(RECOVERY_LOG);
            if (recoveryLog == null) {
                LogUtil.CLog.w("Failed to pull recovery.log file.");
            } else {
                try (FileInputStreamSource source = new FileInputStreamSource(recoveryLog, true);){
                    this.mLogger.testLog(RECOVERY_LOG_NAME, LogDataType.RECOVERY_MODE_LOG, source);
                }
            }
            this.rebootDevice(testInformation);
        }
    }

    protected void rebootDevice(TestInformation testInformation) throws DeviceNotAvailableException {
        testInformation.getDevice().rebootIntoBootloader();
    }
}

