/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.BackgroundDeviceAction;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.RunUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="run-command")
public class RunCommandTargetPreparer
extends BaseTargetPreparer {
    @Option(name="run-command", description="adb shell command to run")
    private List<String> mCommands = new ArrayList<String>();
    @Option(name="run-bg-command", description="Command to run repeatedly in the device background. Can be repeated to run multiple commands in the background.")
    private List<String> mBgCommands = new ArrayList<String>();
    @Option(name="hide-bg-output", description="if true, don't log background command output")
    private boolean mHideBgOutput = false;
    @Option(name="teardown-command", description="adb shell command to run at teardown time")
    private List<String> mTeardownCommands = new ArrayList<String>();
    @Option(name="delay-after-commands", description="Time to delay after running commands, in msecs")
    private long mDelayMsecs = 0L;
    @Option(name="run-command-timeout", description="Timeout for execute shell command", isTimeVal=true)
    private long mRunCmdTimeout = 0L;
    @Option(name="teardown-command-timeout", description="Timeout for execute shell teardown command", isTimeVal=true)
    private long mTeardownCmdTimeout = 0L;
    @Option(name="throw-if-cmd-fail", description="Whether or not to throw if a command fails")
    private boolean mThrowIfFailed = false;
    @Option(name="log-command-output", description="Whether or not to always log the commands output")
    private boolean mLogOutput = false;
    @Option(name="test-user-token", description="When set, that token will be replaced by the id of the user running the test. For example, if it's set as %TEST_USER%, a command that uses it could be written as something like 'cmd self-destruct --user %TEST_USER%'.")
    private String mTestUserToken = "";
    private Map<BackgroundDeviceAction, CollectingOutputReceiver> mBgDeviceActionsMap = new HashMap<BackgroundDeviceAction, CollectingOutputReceiver>();
    private final List<String> mExecutedCommands = new ArrayList<String>();
    private String mTestUser;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, DeviceNotAvailableException {
        ITestDevice device = this.getDevice(testInfo);
        if (!this.mTestUserToken.isEmpty()) {
            this.mTestUser = testInfo.properties().get("RUN_TESTS_AS_USER");
            if (this.mTestUser == null || this.mTestUser.isEmpty()) {
                this.mTestUser = String.valueOf(device.getCurrentUser());
            }
            LogUtil.CLog.d("Will replace '%s' by '%s' on all commands", this.mTestUserToken, this.mTestUser);
        }
        for (String rawCmd : this.mBgCommands) {
            String bgCmd = this.resolveCommand(rawCmd);
            this.mExecutedCommands.add(bgCmd);
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            BackgroundDeviceAction mBgDeviceAction = new BackgroundDeviceAction(bgCmd, bgCmd, device, receiver, 0);
            mBgDeviceAction.start();
            this.mBgDeviceActionsMap.put(mBgDeviceAction, receiver);
        }
        for (String rawCmd : this.mCommands) {
            String cmd = this.resolveCommand(rawCmd);
            this.mExecutedCommands.add(cmd);
            CommandResult result = this.mRunCmdTimeout > 0L ? device.executeShellV2Command(cmd, this.mRunCmdTimeout, TimeUnit.MILLISECONDS, 0) : device.executeShellV2Command(cmd);
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                if (this.mThrowIfFailed) {
                    throw new TargetSetupError(String.format("Failed to run '%s' without error. stdout: '%s'\nstderr: '%s'", cmd, result.getStdout(), result.getStderr()), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
                }
                LogUtil.CLog.d("cmd: '%s' failed, returned:\nstdout:%s\nstderr:%s", cmd, result.getStdout(), result.getStderr());
                continue;
            }
            if (!this.mLogOutput) continue;
            LogUtil.CLog.d("cmd: '%s', returned:\nstdout:%s\nstderr:%s", cmd, result.getStdout(), result.getStderr());
        }
        if (this.mDelayMsecs > 0L) {
            LogUtil.CLog.d("Sleeping %d msecs on device %s", this.mDelayMsecs, device.getSerialNumber());
            RunUtil.getDefault().sleep(this.mDelayMsecs);
        }
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        for (Map.Entry<BackgroundDeviceAction, CollectingOutputReceiver> bgAction : this.mBgDeviceActionsMap.entrySet()) {
            if (!this.mHideBgOutput) {
                LogUtil.CLog.d("Background command output : %s", bgAction.getValue().getOutput());
            }
            bgAction.getKey().cancel();
        }
        if (e instanceof DeviceNotAvailableException) {
            LogUtil.CLog.e("Skipping command teardown since exception was DeviceNotAvailable");
            return;
        }
        for (String rawCmd : this.mTeardownCommands) {
            String cmd = this.resolveCommand(rawCmd);
            try {
                CommandResult result = this.mTeardownCmdTimeout > 0L ? this.getDevice(testInfo).executeShellV2Command(cmd, this.mTeardownCmdTimeout, TimeUnit.MILLISECONDS, 0) : this.getDevice(testInfo).executeShellV2Command(cmd);
                if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                    LogUtil.CLog.d("tearDown cmd: '%s' failed, returned:\nstdout:%s\nstderr:%s", cmd, result.getStdout(), result.getStderr());
                    continue;
                }
                if (!this.mLogOutput) continue;
                LogUtil.CLog.d("tearDown cmd: '%s', returned:\nstdout:%s\nstderr:%s", cmd, result.getStdout(), result.getStderr());
            }
            catch (TargetSetupError tse) {
                LogUtil.CLog.e(tse);
            }
        }
    }

    public final void addRunCommand(String cmd) {
        this.mCommands.add(cmd);
    }

    public List<String> getCommands() {
        return this.mCommands;
    }

    public List<String> getExecutedCommands() {
        return this.mExecutedCommands;
    }

    protected ITestDevice getDevice(TestInformation testInfo) throws TargetSetupError {
        return testInfo.getDevice();
    }

    private String resolveCommand(String rawCmd) {
        return this.mTestUser == null ? rawCmd : rawCmd.replace(this.mTestUserToken, this.mTestUser);
    }
}

