/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.UserInfo;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@OptionClass(alias="run-on-secondary-user")
public class RunOnSecondaryUserTargetPreparer
extends BaseTargetPreparer {
    @VisibleForTesting
    static final String TEST_PACKAGE_NAME_OPTION = "test-package-name";
    @VisibleForTesting
    static final String SKIP_TESTS_REASON_KEY = "skip-tests-reason";
    private int userIdToDelete = -1;
    private int originalUserId;
    @Option(name="test-package-name", description="the name of a package to be installed on the secondary user. This must already be installed on the device.", importance=Option.Importance.IF_UNSET)
    private List<String> mTestPackages = new ArrayList<String>();

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, DeviceNotAvailableException {
        RunOnSecondaryUserTargetPreparer.removeNonForTestingUsers(testInfo.getDevice());
        int secondaryUserId = RunOnSecondaryUserTargetPreparer.getForTestingSecondaryUserId(testInfo.getDevice());
        if (secondaryUserId == -1) {
            if (!this.assumeTrue(this.canCreateAdditionalUsers(testInfo.getDevice(), 1), "Device cannot support additional users", testInfo)) {
                return;
            }
            this.userIdToDelete = secondaryUserId = RunOnSecondaryUserTargetPreparer.createSecondaryUser(testInfo.getDevice());
        }
        testInfo.getDevice().startUser(secondaryUserId, testInfo.getDevice().getApiLevel() >= 29);
        this.originalUserId = testInfo.getDevice().getCurrentUser();
        if (this.originalUserId != secondaryUserId) {
            testInfo.getDevice().switchUser(secondaryUserId);
        }
        for (String pkg : this.mTestPackages) {
            testInfo.getDevice().executeShellCommand("pm install-existing --user " + secondaryUserId + " " + pkg);
        }
        testInfo.properties().put("RUN_TESTS_AS_USER", Integer.toString(secondaryUserId));
    }

    private static int getForTestingSecondaryUserId(ITestDevice device) throws DeviceNotAvailableException {
        for (Map.Entry<Integer, UserInfo> userInfo : device.getUserInfos().entrySet()) {
            if (!userInfo.getValue().isFlagForTesting() && !userInfo.getValue().isMain() || !userInfo.getValue().isSecondary()) continue;
            return userInfo.getKey();
        }
        return -1;
    }

    private static int createSecondaryUser(ITestDevice device) throws DeviceNotAvailableException {
        return device.createUser("secondary", false, false, true);
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        String value = testInfo.properties().remove(SKIP_TESTS_REASON_KEY);
        if (value != null) {
            return;
        }
        testInfo.properties().remove("RUN_TESTS_AS_USER");
        ITestDevice device = testInfo.getDevice();
        int currentUser = device.getCurrentUser();
        if (currentUser != this.originalUserId) {
            device.switchUser(this.originalUserId);
        }
        if (this.userIdToDelete != -1) {
            device.removeUser(this.userIdToDelete);
        }
    }

    private boolean assumeTrue(boolean value, String reason, TestInformation testInfo) {
        if (!value) {
            testInfo.properties().put(SKIP_TESTS_REASON_KEY, reason.replace(" ", "\\ "));
        }
        return value;
    }

    private static void removeNonForTestingUsers(ITestDevice device) throws DeviceNotAvailableException {
        for (Map.Entry<Integer, UserInfo> userInfo : device.getUserInfos().entrySet()) {
            if (userInfo.getValue().isSystem() || userInfo.getValue().isFlagForTesting() || userInfo.getValue().isMain()) continue;
            device.removeUser(userInfo.getValue().userId());
        }
    }

    protected boolean canCreateAdditionalUsers(ITestDevice device, int numberOfUsers) throws DeviceNotAvailableException {
        return device.listUsers().size() + numberOfUsers <= device.getMaxNumberOfUsersSupported();
    }
}

