/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;

@OptionClass(alias="run-on-system-user")
public class RunOnSystemUserTargetPreparer
extends BaseTargetPreparer {
    private Integer mUserToSwitchTo;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, DeviceNotAvailableException {
        if (!testInfo.getDevice().isHeadlessSystemUserMode()) {
            this.ensureSwitchedToUser(testInfo.getDevice(), 0);
        }
        testInfo.properties().put("RUN_TESTS_AS_USER", "0");
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        testInfo.properties().remove("RUN_TESTS_AS_USER");
        if (this.mUserToSwitchTo != null) {
            this.ensureSwitchedToUser(testInfo.getDevice(), this.mUserToSwitchTo);
        }
    }

    private void ensureSwitchedToUser(ITestDevice device, int userId) throws DeviceNotAvailableException {
        int currentUser = device.getCurrentUser();
        if (currentUser == userId) {
            return;
        }
        if (!device.switchUser(userId)) {
            throw new IllegalStateException("Could not switch to user " + userId);
        }
        this.mUserToSwitchTo = currentUser;
    }
}

