/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.UserInfo;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.Map;

@OptionClass(alias="switch-user-target-preparer")
public class SwitchUserTargetPreparer
extends BaseTargetPreparer {
    @Option(name="user-type", description="The type of user to switch to before the module run.")
    private UserInfo.UserType mUserToSwitchTo = UserInfo.UserType.CURRENT;
    private int mPreExecutionCurrentUser;

    @Override
    public void setUp(TestInformation testInformation) throws TargetSetupError, DeviceNotAvailableException {
        ITestDevice device = testInformation.getDevice();
        this.setUserToSwitchTo(device);
        this.mPreExecutionCurrentUser = device.getCurrentUser();
        Map<Integer, UserInfo> userInfos = device.getUserInfos();
        if (userInfos.get(this.mPreExecutionCurrentUser).isUserType(this.mUserToSwitchTo, this.mPreExecutionCurrentUser)) {
            LogUtil.CLog.i("User %d is already user type %s, no action.", this.mPreExecutionCurrentUser, this.mUserToSwitchTo.toString());
            return;
        }
        for (UserInfo userInfo : userInfos.values()) {
            if (!userInfo.isUserType(this.mUserToSwitchTo, this.mPreExecutionCurrentUser)) continue;
            LogUtil.CLog.i("User %d is user type %s, switching from %d", userInfo.userId(), this.mUserToSwitchTo.toString(), this.mPreExecutionCurrentUser);
            if (!device.switchUser(userInfo.userId())) {
                throw new TargetSetupError(String.format("Device failed to switch to user %d", userInfo.userId()), device.getDeviceDescriptor());
            }
            return;
        }
        throw new TargetSetupError(String.format("Failed switch to user type %s, no user of that type exists", new Object[]{this.mUserToSwitchTo}), device.getDeviceDescriptor());
    }

    @Override
    public void tearDown(TestInformation testInformation, Throwable e) throws DeviceNotAvailableException {
        if (testInformation.getDevice().switchUser(this.mPreExecutionCurrentUser)) {
            LogUtil.CLog.d("Successfully switched back to user id: %d", this.mPreExecutionCurrentUser);
        } else {
            LogUtil.CLog.w("Could not switch back to the user id: %d", this.mPreExecutionCurrentUser);
        }
    }

    private void setUserToSwitchTo(ITestDevice device) throws DeviceNotAvailableException {
        try {
            if (UserInfo.UserType.SYSTEM.equals((Object)this.mUserToSwitchTo) && device.isHeadlessSystemUserMode() && !device.canSwitchToHeadlessSystemUser()) {
                this.mUserToSwitchTo = UserInfo.UserType.MAIN;
                LogUtil.CLog.i("SwitchUserTargetPreparer is configured to switch to the MAIN user.");
            }
        }
        catch (HarnessRuntimeException e) {
            LogUtil.CLog.w("Unable to get the main user switch-ability. Error: ", e);
        }
    }
}

