/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.incfs.install.IncrementalInstallSession;
import com.android.incfs.install.adb.ddmlib.DeviceConnection;
import com.android.incfs.install.adb.ddmlib.DeviceLogger;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.NativeDevice;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.observatory.IDiscoverDependencies;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.AltDirBehavior;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.util.AaptParser;
import com.android.tradefed.util.AbiFormatter;
import com.android.tradefed.util.BuildTestsZipUtils;
import com.android.utils.StdLogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimaps;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@OptionClass(alias="tests-zip-app")
public class TestAppInstallSetup
extends BaseTargetPreparer
implements IAbiReceiver,
IDiscoverDependencies {
    private static final String INSTALL_FAILED_UPDATE_INCOMPATIBLE = "INSTALL_FAILED_UPDATE_INCOMPATIBLE";
    static final String TEST_FILE_NAME_OPTION = "test-file-name";
    @Option(name="test-file-name", description="the name of an apk file to be installed on device. Can be repeated. Items that are directories will have any APKs contained therein, including subdirectories, grouped by package name and installed.", importance=Option.Importance.IF_UNSET)
    private List<File> mTestFiles = new ArrayList<File>();
    @Option(name="split-apk-file-names", description="the split apk file names separted by comma that will be installed on device. Can be repeated for multiple split apk sets.See https://developer.android.com/studio/build/configure-apk-splits on how to split apk to several files")
    private List<String> mSplitApkFileNames = new ArrayList<String>();
    static final String THROW_IF_NOT_FOUND_OPTION = "throw-if-not-found";
    @Option(name="throw-if-not-found", description="Throw exception if the specified file is not found.")
    private boolean mThrowIfNoFile = true;
    @Option(name="force-abi", description="The abi to use, can be either 32 or 64.", importance=Option.Importance.IF_UNSET)
    private String mForceAbi = null;
    @Option(name="install-arg", description="Additional arguments to be passed to install command, including leading dash, e.g. \"-d\"")
    private Collection<String> mInstallArgs = new ArrayList<String>();
    @Option(name="force-queryable", description="Whether apks should be installed as force queryable.")
    private Boolean mForceQueryable = null;
    @Option(name="cleanup-apks", description="Whether apks installed should be uninstalled after test. Note that the preparer does not verify if the apks are successfully removed.")
    private boolean mCleanup = true;
    static final String CHECK_MIN_SDK_OPTION = "check-min-sdk";
    @Option(name="check-min-sdk", description="check app's min sdk prior to install and skip if device api level is too low.")
    private boolean mCheckMinSdk = false;
    @Deprecated
    @Option(name="alt-dir", description="Alternate directory to look for the apk if the apk is not in the tests zip file. For each alternate dir, will look in //, //data/app, //DATA/app, //DATA/app/apk_name/ and //DATA/priv-app/apk_name/. Can be repeated. Look for apks in last alt-dir first.")
    private List<File> mAltDirs = new ArrayList<File>();
    @Deprecated
    @Option(name="alt-dir-behavior", description="The order of alternate directory to be used when searching for apks to install")
    private AltDirBehavior mAltDirBehavior = AltDirBehavior.FALLBACK;
    @Option(name="instant-mode", description="Whether or not to install apk in instant mode.")
    private boolean mInstantMode = false;
    @Option(name="aapt-version", description="The version of AAPT for APK parsing.")
    private AaptParser.AaptVersion mAaptVersion = AaptParser.AaptVersion.AAPT2;
    @Option(name="force-install-mode", description="Force the preparer to ignore instant-mode option, and install in the requested mode.")
    private InstallMode mInstallationMode = null;
    @Option(name="incremental", description="Performs an installation using incremental streaming. Given the non-deterministic nature of an incremental installation, it is not guaranteed that a test run with this option will yield the same results of previous or future invocations.")
    protected boolean mIncrementalInstallation = false;
    @Option(name="incremental-block-filter", description="Decimal representation of the percentage of data blocks to be filtered out during an incremental installation.")
    protected double mBlockFilterPercentage = 0.0;
    @Option(name="incremental-install-timeout-secs", description="Specifies the maximum permitted duration of an incremental installation.")
    protected int mIncrementalInstallTimeout = 1800;
    private IAbi mAbi = null;
    private Integer mUserId = null;
    private Boolean mGrantPermission = null;
    private Set<String> mPackagesInstalled = new HashSet<String>();
    private TestInformation mTestInfo;
    protected IncrementalInstallSession incrementalInstallSession;

    protected void setTestInformation(TestInformation testInfo) {
        this.mTestInfo = testInfo;
    }

    public void addTestFile(File file2) {
        this.mTestFiles.add(file2);
    }

    public void addTestFileName(String fileName) {
        this.addTestFile(new File(fileName));
    }

    AaptParser doAaptParse(File apkFile) {
        return AaptParser.parse(apkFile);
    }

    void clearTestFile() {
        this.mTestFiles.clear();
    }

    public void addSplitApkFileNames(String fileNames) {
        this.mSplitApkFileNames.add(fileNames);
    }

    void clearSplitApkFileNames() {
        this.mSplitApkFileNames.clear();
    }

    public List<File> getTestsFileName() {
        return this.mTestFiles;
    }

    public void setCleanApk(boolean shouldClean) {
        this.mCleanup = shouldClean;
    }

    public void setUserId(int userId) {
        this.mUserId = userId;
    }

    public void setShouldGrantPermission(boolean shouldGrant) {
        this.mGrantPermission = shouldGrant;
    }

    public void setAaptVersion(AaptParser.AaptVersion aaptVersion) {
        this.mAaptVersion = aaptVersion;
    }

    public void addInstallArg(String arg) {
        this.mInstallArgs.add(arg);
    }

    public void setForceQueryable(boolean forceQueryable) {
        this.mForceQueryable = forceQueryable;
    }

    protected File getLocalPathForFilename(TestInformation testInfo, String apkFileName) throws TargetSetupError {
        try {
            return BuildTestsZipUtils.getApkFile(testInfo.getBuildInfo(), apkFileName, this.mAltDirs, this.mAltDirBehavior, false, null);
        }
        catch (IOException ioe) {
            throw new TargetSetupError(String.format("failed to resolve apk path for apk %s in build %s", apkFileName, testInfo.getBuildInfo().toString()), (Throwable)ioe, testInfo.getDevice().getDeviceDescriptor(), InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
        }
    }

    @Override
    @Deprecated
    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        InvocationContext context = new InvocationContext();
        context.addAllocatedDevice("device", device);
        context.addDeviceBuildInfo("device", buildInfo);
        TestInformation backwardCompatible = TestInformation.newBuilder().setInvocationContext(context).build();
        this.setUp(backwardCompatible);
    }

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        this.mTestInfo = testInfo;
        if (this.mTestFiles.isEmpty() && this.mSplitApkFileNames.isEmpty()) {
            LogUtil.CLog.i("No test apps to install, skipping");
            return;
        }
        if (this.mAbi != null && this.mForceAbi != null) {
            throw new IllegalStateException("cannot specify both abi flags: --abi and --force-abi");
        }
        if (this.getDevice() instanceof NativeDevice) {
            ((NativeDevice)this.getDevice()).batchPrefetchStartupBuildProps();
        }
        String abiName = null;
        if (this.mAbi != null) {
            abiName = this.mAbi.getName();
        } else if (this.mForceAbi != null) {
            abiName = AbiFormatter.getDefaultAbi(this.getDevice(), this.mForceAbi);
        }
        if (abiName != null && testInfo.getDevice().getApiLevel() > 20) {
            this.mInstallArgs.add(String.format("--abi %s", abiName));
        }
        if (this.mInstallationMode != null) {
            if (InstallMode.INSTANT.equals((Object)this.mInstallationMode)) {
                this.mInstallArgs.add("--instant");
            }
        } else if (this.mInstantMode) {
            this.mInstallArgs.add("--instant");
        }
        if (this.mUserId == null && testInfo.properties().get("RUN_TESTS_AS_USER") != null) {
            this.mUserId = Integer.parseInt(testInfo.properties().get("RUN_TESTS_AS_USER"));
            if (!testInfo.getDevice().getUserInfos().containsKey(this.mUserId)) {
                LogUtil.CLog.w("User requested: %s doesn't exist on device. Ignoring it.", this.mUserId);
                this.mUserId = null;
            } else {
                LogUtil.CLog.d("Using user %s from testInfo properties.", this.mUserId);
            }
        }
        if (this.mForceQueryable == null) {
            this.mForceQueryable = !this.getDevice().checkApiLevelAgainstNextRelease(34) || "TM".equals(this.getDevice().getBuildAlias());
        }
        if (this.mForceQueryable.booleanValue() && this.getDevice().isAppEnumerationSupported()) {
            this.mInstallArgs.add("--force-queryable");
        }
        if (this.getDevice().isBypassLowTargetSdkBlockSupported()) {
            this.mInstallArgs.add("--bypass-low-target-sdk-block");
        }
        for (File testAppName : this.mTestFiles) {
            Map<File, String> appFilesAndPackages = this.resolveApkFiles(testInfo, this.findApkFiles(testAppName));
            this.installer(testInfo, appFilesAndPackages);
        }
        for (String testAppNames : this.mSplitApkFileNames) {
            List<String> apkNames = Arrays.asList(testAppNames.split(","));
            List<File> apkFileNames = apkNames.stream().map(a -> new File((String)a)).collect(Collectors.toList());
            Map<File, String> appFilesAndPackages = this.resolveApkFiles(testInfo, apkFileNames);
            this.installer(testInfo, appFilesAndPackages);
        }
    }

    public ITestDevice getDevice() throws TargetSetupError {
        return this.mTestInfo.getDevice();
    }

    public TestInformation getTestInfo() {
        return this.mTestInfo;
    }

    @Override
    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    @Override
    public IAbi getAbi() {
        return this.mAbi;
    }

    public final void setInstantMode(boolean mode) {
        this.mInstantMode = mode;
    }

    public final boolean isInstantMode() {
        return this.mInstantMode;
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        this.mTestInfo = testInfo;
        if (this.mCleanup && !(e instanceof DeviceNotAvailableException)) {
            for (String packageName : this.mPackagesInstalled) {
                try {
                    this.uninstallPackage(this.getDevice(), packageName);
                }
                catch (TargetSetupError tse) {
                    LogUtil.CLog.e(tse);
                }
            }
        }
    }

    public void setAltDir(File altDir) {
        this.mAltDirs.add(altDir);
    }

    public void setAltDirBehavior(AltDirBehavior altDirBehavior) {
        this.mAltDirBehavior = altDirBehavior;
    }

    public boolean isCleanUpEnabled() {
        return this.mCleanup;
    }

    protected void installer(TestInformation testInfo, Map<File, String> appFilesAndPackages) throws TargetSetupError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        ImmutableMultimap packageToFiles = ImmutableListMultimap.copyOf(appFilesAndPackages.entrySet()).inverse();
        IncrementalInstallSession.Builder builder = null;
        if (this.mIncrementalInstallation) {
            builder = this.getIncrementalInstallSessionBuilder();
        }
        for (Map.Entry e : Multimaps.asMap(packageToFiles).entrySet()) {
            if (this.mIncrementalInstallation) {
                LogUtil.CLog.d("Performing incremental installation of apk %s with %s ...", e.getKey(), e.getValue());
                this.addPackageToIncrementalInstallSession(builder, (String)e.getKey(), e.getValue());
                if (!this.mCleanup) continue;
                this.mPackagesInstalled.add((String)e.getKey());
                continue;
            }
            this.installSinglePackage(device, (String)e.getKey(), e.getValue());
        }
        if (this.mIncrementalInstallation && builder != null) {
            this.installPackageIncrementally(builder);
        }
    }

    private void installSinglePackage(ITestDevice testDevice, String packageName, List<File> apkFiles) throws TargetSetupError, DeviceNotAvailableException {
        if (apkFiles.isEmpty()) {
            return;
        }
        LogUtil.CLog.d("Installing apk %s with %s ...", packageName, apkFiles);
        String result = this.installPackage(testDevice, apkFiles);
        if (result != null && result.startsWith(INSTALL_FAILED_UPDATE_INCOMPATIBLE)) {
            this.uninstallPackage(testDevice, packageName);
            result = this.installPackage(testDevice, apkFiles);
        }
        if (result != null) {
            throw new TargetSetupError(String.format("Failed to install %s with %s on %s. Reason: '%s'", packageName, apkFiles, testDevice.getSerialNumber(), result), testDevice.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.APK_INSTALLATION_FAILED);
        }
        if (this.mCleanup) {
            this.mPackagesInstalled.add(packageName);
        }
    }

    protected Map<File, String> resolveApkFiles(TestInformation testInfo, List<File> apkFiles) throws TargetSetupError, DeviceNotAvailableException {
        LinkedHashMap<File, String> appFiles = new LinkedHashMap<File, String>();
        ITestDevice device = testInfo.getDevice();
        for (File apkFile : apkFiles) {
            File testAppFile = null;
            if (apkFile.isAbsolute()) {
                testAppFile = apkFile;
            }
            if (testAppFile == null) {
                testAppFile = this.getLocalPathForFilename(testInfo, apkFile.getName());
            }
            if (testAppFile == null) {
                if (this.mThrowIfNoFile) {
                    throw new TargetSetupError(String.format("Test app %s was not found.", apkFile.getName()), device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
                }
                LogUtil.CLog.d("Test app %s was not found.", apkFile.getName());
                continue;
            }
            if (!testAppFile.canRead()) {
                if (this.mThrowIfNoFile) {
                    throw new TargetSetupError(String.format("Could not read file %s.", testAppFile.toString()), device.getDeviceDescriptor());
                }
                LogUtil.CLog.d("Could not read file %s.", testAppFile.toString());
                continue;
            }
            if (this.mCheckMinSdk) {
                AaptParser aaptParser = this.doAaptParse(testAppFile);
                if (aaptParser == null) {
                    throw new TargetSetupError(String.format("Failed to extract info from `%s` using aapt", testAppFile.getAbsoluteFile().getName()), device.getDeviceDescriptor());
                }
                if (device.getApiLevel() < aaptParser.getSdkVersion()) {
                    LogUtil.CLog.w("Skipping installing apk %s on device %s because SDK level require is %d, but device SDK level is %d", apkFile.toString(), device.getSerialNumber(), aaptParser.getSdkVersion(), device.getApiLevel());
                    continue;
                }
                appFiles.put(testAppFile, this.parsePackageName(testAppFile));
                continue;
            }
            appFiles.put(testAppFile, this.parsePackageName(testAppFile));
        }
        return appFiles;
    }

    private List<File> findApkFiles(File fileOrDirectory) throws TargetSetupError {
        List<File> apkFiles;
        if (!fileOrDirectory.isDirectory()) {
            return ImmutableList.of(fileOrDirectory);
        }
        try (Stream<Path> paths = Files.walk(fileOrDirectory.toPath(), new FileVisitOption[0]);){
            apkFiles = paths.filter(p -> p.toString().endsWith(".apk")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new TargetSetupError(String.format("Could not list files of specified directory: %s", fileOrDirectory), e, null, false, InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
        }
        if (this.mThrowIfNoFile && apkFiles.isEmpty()) {
            throw new TargetSetupError(String.format("Could not find any files in specified directory: %s", fileOrDirectory), null, null, false, InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
        }
        return apkFiles;
    }

    private String installPackage(ITestDevice device, List<File> appFiles) throws DeviceNotAvailableException {
        if (this.mUserId == null) {
            if (appFiles.size() == 1) {
                return device.installPackage(appFiles.get(0), true, this.mInstallArgs.toArray(new String[0]));
            }
            return device.installPackages(appFiles, true, this.mInstallArgs.toArray(new String[0]));
        }
        if (this.mGrantPermission != null) {
            if (appFiles.size() == 1) {
                return device.installPackageForUser(appFiles.get(0), true, this.mGrantPermission, this.mUserId, this.mInstallArgs.toArray(new String[0]));
            }
            return device.installPackagesForUser(appFiles, true, this.mGrantPermission, this.mUserId, this.mInstallArgs.toArray(new String[0]));
        }
        if (appFiles.size() == 1) {
            return device.installPackageForUser(appFiles.get(0), true, this.mUserId, this.mInstallArgs.toArray(new String[0]));
        }
        return device.installPackagesForUser(appFiles, true, this.mUserId, this.mInstallArgs.toArray(new String[0]));
    }

    protected void uninstallPackage(ITestDevice device, String packageName) throws DeviceNotAvailableException {
        String msg = this.mUserId == null ? device.uninstallPackage(packageName) : device.uninstallPackageForUser(packageName, this.mUserId);
        if (msg != null) {
            LogUtil.CLog.w(String.format("error uninstalling package '%s': %s", packageName, msg));
        }
        if (this.mIncrementalInstallation) {
            this.incrementalInstallSession.close();
        }
    }

    protected String parsePackageName(File testAppFile) throws TargetSetupError {
        AaptParser parser = AaptParser.parse(testAppFile, this.mAaptVersion);
        if (parser == null) {
            throw new TargetSetupError(String.format("AaptParser failed for file %s. The APK won't be installed", testAppFile.getName()), null, null, false, DeviceErrorIdentifier.AAPT_PARSER_FAILED);
        }
        return parser.getPackageName();
    }

    private void addPackageToIncrementalInstallSession(IncrementalInstallSession.Builder builder, String packageName, List<File> packageFiles) throws TargetSetupError {
        for (File apk : packageFiles) {
            Path apkPath = apk.toPath();
            Path apkSignaturePath = Paths.get(String.format("%s.idsig", apkPath.toString()), new String[0]);
            if (!apkSignaturePath.toFile().exists()) {
                throw new TargetSetupError(String.format("Unable to retrieve v4 signature for file: %s", apkPath.getFileName()), this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
            }
            builder.addApk(apkPath, apkSignaturePath);
        }
    }

    protected void installPackageIncrementally(IncrementalInstallSession.Builder builder) throws TargetSetupError {
        try {
            this.incrementalInstallSession = builder.build();
            String deviceSerialNumber = this.getDevice().getSerialNumber();
            DeviceConnection.Factory deviceConnection = DeviceConnection.getFactory(deviceSerialNumber);
            this.incrementalInstallSession.start(Executors.newCachedThreadPool(), deviceConnection);
            this.incrementalInstallSession.waitForInstallCompleted(this.mIncrementalInstallTimeout, TimeUnit.SECONDS);
        }
        catch (IOException | InterruptedException e) {
            throw new TargetSetupError(String.format("Failed to start incremental install session.", new Object[0]), (Throwable)e, this.getDevice().getDeviceDescriptor(), DeviceErrorIdentifier.APK_INSTALLATION_FAILED);
        }
    }

    protected IncrementalInstallSession.Builder getIncrementalInstallSessionBuilder() {
        if (this.mGrantPermission != null && this.mGrantPermission.booleanValue()) {
            this.mInstallArgs.add("-g");
        }
        if (this.mUserId != null) {
            this.mInstallArgs.add("--user");
            this.mInstallArgs.add(Integer.toString(this.mUserId));
        }
        IncrementalInstallSession.Builder incrementalInstallSessionBuilder = new IncrementalInstallSession.Builder().setLogger(new DeviceLogger(new StdLogger(StdLogger.Level.ERROR))).addExtraArgs(this.mInstallArgs.toArray(new String[0]));
        if (this.mBlockFilterPercentage > 0.0) {
            long randomSeed = new SecureRandom().nextLong();
            Random randomBlock = new Random(randomSeed);
            HashMap apkBlockMappings = new HashMap();
            LogUtil.CLog.i("Block filter seed: %d.", randomSeed);
            incrementalInstallSessionBuilder.setBlockFilter(b -> {
                Path apkPath = b.getPath();
                Map map = apkBlockMappings;
                synchronized (map) {
                    if (!apkBlockMappings.containsKey(apkPath)) {
                        int blockCount = b.getFileBlockCount();
                        int numBlocks = (int)((double)blockCount * this.mBlockFilterPercentage);
                        HashSet<Integer> blocksToFilter = new HashSet<Integer>(numBlocks);
                        while (blocksToFilter.size() < numBlocks) {
                            int blockIndex = randomBlock.nextInt(blockCount);
                            blocksToFilter.add(blockIndex);
                        }
                        apkBlockMappings.put(apkPath, blocksToFilter);
                    }
                    return !((Set)apkBlockMappings.get(apkPath)).contains(b.getBlockIndex());
                }
            });
        }
        return incrementalInstallSessionBuilder;
    }

    @Override
    public Set<String> reportDependencies() {
        HashSet<String> deps = new HashSet<String>();
        for (File f : this.getTestsFileName()) {
            if (f.exists()) continue;
            deps.add(f.getName());
        }
        for (String testAppNames : this.mSplitApkFileNames) {
            List<String> apkNames = Arrays.asList(testAppNames.split(","));
            deps.addAll(apkNames);
        }
        return deps;
    }

    private static enum InstallMode {
        FULL,
        INSTANT;

    }
}

