/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.UserInfo;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class UserHelper {
    private static final String TF_CREATED_USER = "tf_created_user";
    static final String USER_SETUP_COMPLETE = "user_setup_complete";
    public static final String RUN_TESTS_AS_USER_KEY = "RUN_TESTS_AS_USER";

    public static int createUser(ITestDevice device, boolean reuseTestUser) throws DeviceNotAvailableException, TargetSetupError {
        Integer existingTFUser;
        if (reuseTestUser && (existingTFUser = UserHelper.findExistingTradefedUser(device)) != null) {
            return existingTFUser;
        }
        UserHelper.cleanupOldUsersIfLimitReached(device);
        try {
            int userId = device.createUser(TF_CREATED_USER);
            LogUtil.CLog.d("Marking user %d as setup complete", userId);
            device.setSetting(userId, "secure", USER_SETUP_COMPLETE, "1");
            return userId;
        }
        catch (IllegalStateException e) {
            throw new TargetSetupError("Failed to create user.", (Throwable)e, device.getDeviceDescriptor());
        }
    }

    private static void cleanupOldUsersIfLimitReached(ITestDevice device) throws DeviceNotAvailableException {
        ArrayList<Integer> tfCreatedUsers = new ArrayList<Integer>();
        int existingUsersCount = 0;
        for (Map.Entry<Integer, UserInfo> entry : device.getUserInfos().entrySet()) {
            UserInfo userInfo = entry.getValue();
            String userName = userInfo.userName();
            if (!userInfo.isGuest()) {
                ++existingUsersCount;
            }
            if (userName == null || !userName.equals(TF_CREATED_USER)) continue;
            tfCreatedUsers.add(entry.getKey());
        }
        if (existingUsersCount >= device.getMaxNumberOfUsersSupported()) {
            Iterator<Map.Entry<Integer, UserInfo>> iterator2 = tfCreatedUsers.iterator();
            while (iterator2.hasNext()) {
                int userId = (Integer)((Object)iterator2.next());
                device.removeUser(userId);
            }
        }
    }

    private static Integer findExistingTradefedUser(ITestDevice device) throws DeviceNotAvailableException {
        for (Map.Entry<Integer, UserInfo> entry : device.getUserInfos().entrySet()) {
            String userName = entry.getValue().userName();
            if (userName == null || !userName.equals(TF_CREATED_USER)) continue;
            return entry.getKey();
        }
        return null;
    }

    private UserHelper() {
        throw new UnsupportedOperationException("provide only static methods");
    }
}

