/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.UserHelper;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

@OptionClass(alias="visible-background-user-preparer")
public class VisibleBackgroundUserPreparer
extends BaseTargetPreparer {
    public static final int INVALID_DISPLAY = -1;
    public static final int DEFAULT_DISPLAY = 0;
    @Option(name="reuse-test-user", description="Whether or not to reuse already created tradefed test user, or remove them  and re-create them between module runs.")
    private boolean mReuseTestUser;
    @Option(name="display-id", description="Which display to start the user visible on")
    private int mDisplayId = -1;
    private Integer mUserId;
    private boolean mUserAlreadyVisible;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        if (!device.isVisibleBackgroundUsersSupported()) {
            throw new TargetSetupError("feature not supported", device.getDeviceDescriptor());
        }
        LogUtil.CLog.i("setUp(): mReuseTestUser=%b, mDisplayId=%d", this.mReuseTestUser, this.mDisplayId);
        this.mUserId = UserHelper.createUser(device, this.mReuseTestUser);
        this.startUserVisibleOnBackground(testInfo, device, this.mUserId);
        device.waitForDeviceAvailable();
        device.postBootSetup();
    }

    public void setDisplayId(int displayId) {
        if (displayId == -1) {
            throw new IllegalArgumentException("Cannot set it as INVALID_DISPLAY (-1)");
        }
        this.mDisplayId = displayId;
    }

    @Nullable
    public Integer getDisplayId() {
        return this.mDisplayId;
    }

    private void startUserVisibleOnBackground(TestInformation testInfo, ITestDevice device, int userId) throws TargetSetupError, DeviceNotAvailableException {
        int displayId = this.mDisplayId;
        if (displayId == -1) {
            Set<Integer> displays = device.listDisplayIdsForStartingVisibleBackgroundUsers();
            LogUtil.CLog.d("Displays: %s", displays);
            if (displays.isEmpty()) {
                throw new TargetSetupError(String.format("No display available to start to user '%d'", userId), device.getDeviceDescriptor());
            }
            Iterator<Integer> iterator2 = displays.iterator();
            displayId = iterator2.next();
            if (displayId == 0 && device.isVisibleBackgroundUsersOnDefaultDisplaySupported()) {
                LogUtil.CLog.d("Ignoring DEFAULT_DISPLAY because device supports background users on default display");
                if (!iterator2.hasNext()) {
                    throw new TargetSetupError(String.format("Only DEFAULT_DISPLAY available to start to user '%d'", userId), device.getDeviceDescriptor());
                }
                displayId = iterator2.next();
            }
        }
        this.mUserAlreadyVisible = device.isUserVisibleOnDisplay(userId, displayId);
        if (this.mUserAlreadyVisible) {
            LogUtil.CLog.d("startUserVisibleOnBackground(): user %d already visible on display %d", userId, displayId);
        } else {
            LogUtil.CLog.d("startUserVisibleOnBackground(): starting user %d visible on display %d", userId, displayId);
            if (!device.startVisibleBackgroundUser(userId, displayId, true)) {
                throw new TargetSetupError(String.format("Failed to start to user '%s' on display %d", this.mUserId, displayId), device.getDeviceDescriptor());
            }
        }
        LogUtil.CLog.i("Setting test property %s=%d", "RUN_TESTS_AS_USER", this.mUserId);
        testInfo.properties().put("RUN_TESTS_AS_USER", Integer.toString(this.mUserId));
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (this.mUserId == null) {
            LogUtil.CLog.d("Skipping teardown because no user was created or reused");
            return;
        }
        testInfo.properties().remove("RUN_TESTS_AS_USER");
        if (e instanceof DeviceNotAvailableException) {
            LogUtil.CLog.d("Skipping teardown due to dnae: %s", e.getMessage());
            return;
        }
        ITestDevice device = testInfo.getDevice();
        this.stopTestUser(device);
        if (!this.mReuseTestUser) {
            device.removeUser(this.mUserId);
        }
    }

    private void stopTestUser(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mUserAlreadyVisible) {
            LogUtil.CLog.d("stopTestUser(): user %d was already visible on start", this.mUserId);
            return;
        }
        LogUtil.CLog.d("stopTestUser(): stopping user %d ", this.mUserId);
        if (!device.stopUser(this.mUserId, true, true)) {
            LogUtil.CLog.e("Failed to stop user '%d'", this.mUserId);
        }
    }
}

