/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.dependencies.ExternalDependency;
import com.android.tradefed.dependencies.IExternalDependency;
import com.android.tradefed.dependencies.connectivity.NetworkDependency;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.LocalAndroidVirtualDevice;
import com.android.tradefed.device.cloud.NestedRemoteDevice;
import com.android.tradefed.device.cloud.RemoteAndroidVirtualDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.DeviceFailedToBootError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.google.common.base.Strings;
import java.util.LinkedHashSet;
import java.util.Set;

@OptionClass(alias="wifi")
public class WifiPreparer
extends BaseTargetPreparer
implements IExternalDependency {
    @Option(name="wifi-network", description="the name of wifi network to connect to.")
    private String mWifiNetwork = null;
    @Option(name="wifi-psk", description="WPA-PSK passphrase of wifi network to connect to.")
    private String mWifiPsk = null;
    @Option(name="disconnect-wifi-after-test", description="disconnect from wifi network after test completes.")
    private boolean mDisconnectWifiAfterTest = true;
    @Option(name="monitor-network", description="monitor network connectivity during test.")
    private boolean mMonitorNetwork = true;
    @Option(name="skip", description="skip the connectivity check and wifi setup")
    private boolean mSkip = false;
    @Option(name="verify-only", description="Skip setup and verify a wifi connection.")
    private boolean mVerifyOnly = false;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mSkip) {
            return;
        }
        ITestDevice device = testInfo.getDevice();
        if (this.mVerifyOnly) {
            if (!device.isWifiEnabled()) {
                throw new TargetSetupError("The device does not have wifi enabled.", device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.NO_WIFI);
            }
            if (!device.checkConnectivity()) {
                throw new TargetSetupError("The device has no wifi connection.", device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.NO_WIFI);
            }
            return;
        }
        if (this.mWifiNetwork == null) {
            throw new TargetSetupError("wifi-network not specified", device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.WIFI_AP_NAME, this.mWifiNetwork);
        if (!device.connectToWifiNetworkIfNeeded(this.mWifiNetwork, this.mWifiPsk)) {
            InfraErrorIdentifier errorIdentifier = InfraErrorIdentifier.WIFI_FAILED_CONNECT;
            if (device instanceof RemoteAndroidVirtualDevice || device instanceof NestedRemoteDevice || device instanceof LocalAndroidVirtualDevice) {
                errorIdentifier = InfraErrorIdentifier.VIRTUAL_WIFI_FAILED_CONNECT;
            }
            throw new TargetSetupError(String.format("Failed to connect to wifi network %s on %s", this.mWifiNetwork, device.getSerialNumber()), device.getDeviceDescriptor(), (ErrorIdentifier)errorIdentifier);
        }
        if (this.mMonitorNetwork) {
            device.enableNetworkMonitor();
        }
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (this.mSkip || this.mVerifyOnly) {
            return;
        }
        ITestDevice device = testInfo.getDevice();
        if (e instanceof DeviceFailedToBootError) {
            LogUtil.CLog.d("boot failure: skipping wifi teardown");
            return;
        }
        if (e instanceof DeviceNotAvailableException) {
            LogUtil.CLog.d("device is not available. skipping wifi teardown");
            return;
        }
        if (this.mMonitorNetwork) {
            device.disableNetworkMonitor();
        }
        if (this.mWifiNetwork != null && this.mDisconnectWifiAfterTest && device.isWifiEnabled()) {
            if (!device.disconnectFromWifi()) {
                LogUtil.CLog.w("Failed to disconnect from wifi network on %s", device.getSerialNumber());
                return;
            }
            LogUtil.CLog.i("Successfully disconnected from wifi network on %s", device.getSerialNumber());
        }
    }

    @Override
    public Set<ExternalDependency> getDependencies() {
        LinkedHashSet<ExternalDependency> externalDependencies = new LinkedHashSet<ExternalDependency>();
        if (!(this.mSkip || !this.mVerifyOnly && Strings.isNullOrEmpty(this.mWifiNetwork))) {
            externalDependencies.add(new NetworkDependency());
        }
        return externalDependencies;
    }
}

